/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.util.List;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/container/UITabContainer.gtmpl", events={@EventConfig(listeners={SelectTabActionListener.class})})
public class UITabContainer
extends UIContainer {
    public static final String TAB_CONTAINER = "TabContainer";
    public static final String FIRST_TAB = "FirstTab";
    public static final String LAST_TAB = "LastTab";

    public String getTabState(UIComponent uiChild, UITabContainer uiContainer) {
        String tabState = "";
        List<UIComponent> children = uiContainer.getChildren();
        int tabIndex = children.indexOf(uiChild);
        if (tabIndex == 0) {
            tabState = FIRST_TAB;
        } else if (tabIndex == children.size() - 1) {
            tabState = LAST_TAB;
        }
        return tabState;
    }

    public static class SelectTabActionListener
    extends EventListener<UITabContainer> {
        @Override
        public void execute(Event<UITabContainer> event) throws Exception {
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            UITabContainer container = event.getSource();
            Object goal = container.findComponentById(objectId);
            if (goal == null) {
                return;
            }
            UITabContainer parent = (UITabContainer)((UIComponent)goal).getParent();
            List<UIComponent> children = parent.getChildren();
            for (UIComponent child : children) {
                if (child.getId().equals(objectId)) {
                    child.setRendered(true);
                    continue;
                }
                child.setRendered(false);
            }
        }
    }
}

