/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.model;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class StatisticData
implements Serializable {
    private static final long serialVersionUID = -2660993500359866340L;
    private static final int PRIME = 59;
    private DateFormat dateFormat;
    private long timestamp;
    private long userId;
    private long spaceId;
    private String module;
    private String subModule;
    private String operation;
    private StatisticStatus status = StatisticStatus.OK;
    private String errorMessage;
    private long duration;
    private long errorCode;
    private Map<String, String> parameters;
    private Map<String, Collection<String>> listParameters;

    public void addParameter(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            List<String> values = collection.stream().filter(Objects::nonNull).map(this::getFieldValue).toList();
            if (this.listParameters == null) {
                this.listParameters = new HashMap<String, Collection<String>>();
            }
            this.listParameters.put(key, values);
        } else {
            this.parameters.put(key, this.getFieldValue(value));
        }
    }

    private String getFieldValue(Object value) {
        if (value instanceof Date) {
            return this.buildDateFormat().format(value);
        }
        return String.valueOf(value);
    }

    private DateFormat buildDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z");
        }
        return this.dateFormat;
    }

    public long computeId() {
        long result = this.timestamp;
        result = result * 59L + (long)((int)(this.userId >>> 32 ^ this.userId));
        result = result * 59L + (long)((int)(this.spaceId >>> 32 ^ this.spaceId));
        result = result * 59L + (long)(this.module == null ? 43 : this.module.hashCode());
        result = result * 59L + (long)(this.subModule == null ? 43 : this.subModule.hashCode());
        result = result * 59L + (long)(this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59L + (long)(this.parameters == null ? 43 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticData)) {
            return false;
        }
        StatisticData other = (StatisticData)o;
        return this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return (int)this.computeId();
    }

    @Generated
    public String toString() {
        return "StatisticData(timestamp=" + this.getTimestamp() + ", userId=" + this.getUserId() + ", spaceId=" + this.getSpaceId() + ", module=" + this.getModule() + ", subModule=" + this.getSubModule() + ", operation=" + this.getOperation() + ", status=" + String.valueOf((Object)this.getStatus()) + ", errorMessage=" + this.getErrorMessage() + ", duration=" + this.getDuration() + ", errorCode=" + this.getErrorCode() + ", parameters=" + String.valueOf(this.getParameters()) + ", listParameters=" + String.valueOf(this.getListParameters()) + ")";
    }

    @Generated
    public StatisticData(DateFormat dateFormat, long timestamp, long userId, long spaceId, String module, String subModule, String operation, StatisticStatus status, String errorMessage, long duration, long errorCode, Map<String, String> parameters, Map<String, Collection<String>> listParameters) {
        this.dateFormat = dateFormat;
        this.timestamp = timestamp;
        this.userId = userId;
        this.spaceId = spaceId;
        this.module = module;
        this.subModule = subModule;
        this.operation = operation;
        this.status = status;
        this.errorMessage = errorMessage;
        this.duration = duration;
        this.errorCode = errorCode;
        this.parameters = parameters;
        this.listParameters = listParameters;
    }

    @Generated
    public StatisticData() {
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getUserId() {
        return this.userId;
    }

    @Generated
    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Generated
    public long getSpaceId() {
        return this.spaceId;
    }

    @Generated
    public void setSpaceId(long spaceId) {
        this.spaceId = spaceId;
    }

    @Generated
    public String getModule() {
        return this.module;
    }

    @Generated
    public void setModule(String module) {
        this.module = module;
    }

    @Generated
    public String getSubModule() {
        return this.subModule;
    }

    @Generated
    public void setSubModule(String subModule) {
        this.subModule = subModule;
    }

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Generated
    public StatisticStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(StatisticStatus status) {
        this.status = status;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public long getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public Map<String, Collection<String>> getListParameters() {
        return this.listParameters;
    }

    @Generated
    public void setListParameters(Map<String, Collection<String>> listParameters) {
        this.listParameters = listParameters;
    }

    public static enum StatisticStatus {
        OK,
        KO;

    }
}

