/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.exoplatform.commons.utils.Safe;

public abstract class AccessTokenContext
implements Serializable {
    private static final long serialVersionUID = -7034897192745766989L;
    public static final String DELIMITER = " ";
    private final Set<String> scopes = new HashSet<String>();

    public AccessTokenContext(String ... scopes) {
        if (scopes != null && scopes.length > 0) {
            for (String scope : scopes) {
                this.scopes.add(scope);
            }
        }
    }

    public AccessTokenContext(String scopesAsString) {
        String[] scopes;
        if (scopesAsString == null) {
            scopesAsString = "";
        }
        for (String scope : scopes = scopesAsString.split(DELIMITER)) {
            this.scopes.add(scope);
        }
    }

    public AccessTokenContext(Collection<String> scopes) {
        if (scopes != null) {
            this.scopes.addAll(scopes);
        }
    }

    public boolean isScopeAvailable(String scope) {
        return this.scopes.contains(scope);
    }

    public String getScopesAsString() {
        StringBuilder result;
        Iterator<String> iterator = this.scopes.iterator();
        if (iterator.hasNext()) {
            result = new StringBuilder(iterator.next());
        } else {
            return "";
        }
        while (iterator.hasNext()) {
            result.append(DELIMITER + iterator.next());
        }
        return result.toString();
    }

    public boolean addScope(String scope) {
        return this.scopes.add(scope);
    }

    public abstract String getAccessToken();

    public String toString() {
        return " scope=" + this.getScopesAsString() + "]";
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!that.getClass().equals(this.getClass())) {
            return false;
        }
        AccessTokenContext thatt = (AccessTokenContext)that;
        return Safe.equals(this.scopes, thatt.scopes);
    }

    public int hashCode() {
        return this.scopes.hashCode();
    }
}

