/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ComparisonRestriction;
import org.hibernate.sql.CompleteRestriction;
import org.hibernate.sql.Restriction;
import org.hibernate.sql.RestrictionRenderingContext;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

@Internal
public class SimpleSelect
implements RestrictionRenderingContext {
    protected String tableName;
    protected String orderBy;
    protected String comment;
    protected List<String> columns = new ArrayList<String>();
    protected Map<String, String> aliases = new HashMap<String, String>();
    protected List<Restriction> restrictions = new ArrayList<Restriction>();
    protected LockOptions lockOptions = new LockOptions(LockMode.READ);
    private final Dialect dialect;
    private final ParameterMarkerStrategy parameterMarkerStrategy;
    private int parameterCount;

    public SimpleSelect(SessionFactoryImplementor factory) {
        JdbcServices jdbcServices = factory.getJdbcServices();
        this.dialect = jdbcServices.getDialect();
        this.parameterMarkerStrategy = jdbcServices.getParameterMarkerStrategy();
    }

    @Override
    public String makeParameterMarker() {
        return this.parameterMarkerStrategy.createMarker(++this.parameterCount, null);
    }

    public SimpleSelect setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SimpleSelect addColumns(String[] columnNames) {
        for (String columnName : columnNames) {
            if (columnName == null) continue;
            this.addColumn(columnName);
        }
        return this;
    }

    public SimpleSelect addColumn(String columnName) {
        this.columns.add(columnName);
        return this;
    }

    public SimpleSelect addColumn(String columnName, String alias) {
        this.columns.add(columnName);
        this.aliases.put(columnName, alias);
        return this;
    }

    public SimpleSelect addWhereToken(String condition) {
        if (condition != null) {
            this.restrictions.add(new CompleteRestriction(condition));
        }
        return this;
    }

    public SimpleSelect addRestriction(String columnName) {
        this.restrictions.add(new ComparisonRestriction(columnName));
        return this;
    }

    public SimpleSelect addRestriction(String lhs, ComparisonRestriction.Operator op, String rhs) {
        this.restrictions.add(new ComparisonRestriction(lhs, op, rhs));
        return this;
    }

    public SimpleSelect addRestriction(String ... columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i] == null) continue;
            this.addRestriction(columnNames[i]);
        }
        return this;
    }

    public SimpleSelect setLockOptions(LockOptions lockOptions) {
        LockOptions.copy(lockOptions, this.lockOptions);
        return this;
    }

    public SimpleSelect setLockMode(LockMode lockMode) {
        this.lockOptions.setLockMode(lockMode);
        return this;
    }

    public SimpleSelect setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public SimpleSelect setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public String toStatementString() {
        StringBuilder buf = new StringBuilder(this.columns.size() * 10 + this.tableName.length() + this.restrictions.size() * 10 + 10);
        this.applyComment(buf);
        this.applySelectClause(buf);
        this.applyFromClause(buf);
        this.applyWhereClause(buf);
        this.applyOrderBy(buf);
        String selectString = this.lockOptions != null ? this.dialect.applyLocksToSql(buf.toString(), this.lockOptions, null) : buf.toString();
        return this.dialect.transformSelectString(selectString);
    }

    private void applyComment(StringBuilder buf) {
        if (this.comment != null) {
            buf.append("/* ").append(Dialect.escapeComment(this.comment)).append(" */ ");
        }
    }

    private void applySelectClause(StringBuilder buf) {
        buf.append("select ");
        boolean appendComma = false;
        HashSet<String> uniqueColumns = new HashSet<String>();
        for (int i = 0; i < this.columns.size(); ++i) {
            String col = this.columns.get(i);
            String alias = this.aliases.get(col);
            if (!uniqueColumns.add(alias == null ? col : alias)) continue;
            if (appendComma) {
                buf.append(", ");
            }
            buf.append(col);
            if (alias != null && !alias.equals(col)) {
                buf.append(" as ").append(alias);
            }
            appendComma = true;
        }
    }

    private void applyFromClause(StringBuilder buf) {
        buf.append(" from ").append(this.dialect.appendLockHint(this.lockOptions, this.tableName));
    }

    private void applyWhereClause(StringBuilder buf) {
        if (this.restrictions.isEmpty()) {
            return;
        }
        buf.append(" where ");
        for (int i = 0; i < this.restrictions.size(); ++i) {
            if (i > 0) {
                buf.append(" and ");
            }
            Restriction restriction = this.restrictions.get(i);
            restriction.render(buf, this);
        }
    }

    private void applyOrderBy(StringBuilder buf) {
        if (this.orderBy != null) {
            buf.append(' ').append(this.orderBy);
        }
    }
}

