/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.router;

import java.util.Iterator;
import java.util.Map;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoRouterConfig
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(ExoRouterConfig.class);
    private Map<String, String> routeMapping;

    public ExoRouterConfig() {
    }

    public ExoRouterConfig(InitParams initParams) {
        if (initParams == null) {
            LOG.warn((Object)"Failed to register this plugin: initParams is null");
            return;
        }
        Iterator itr = initParams.getObjectParamIterator();
        if (!itr.hasNext()) {
            LOG.warn((Object)"Failed to register this route configuration: no <object-param>");
            return;
        }
        ObjectParameter objectParameter = (ObjectParameter)itr.next();
        ExoRouterConfig routeConfig = (ExoRouterConfig)((Object)objectParameter.getObject());
        if (routeConfig.getRouteMapping() == null || routeConfig.getRouteMapping().size() == 0) {
            LOG.warn((Object)"Failed to register route configuration: no <entry> found for <object-param> config");
            return;
        }
        this.routeMapping = routeConfig.getRouteMapping();
    }

    public Map<String, String> getRouteMapping() {
        return this.routeMapping;
    }

    public void setRouteMapping(Map<String, String> mapping) {
        if (mapping == null || mapping.size() == 0) {
            LOG.warn((Object)"mapping is null or size = 0");
            return;
        }
        this.routeMapping = mapping;
    }
}

