/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.databind.Module;
import java.util.Collections;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonLinkDiscoverer;
import org.springframework.hateoas.mediatype.collectionjson.Jackson2CollectionJsonModule;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;

@Configuration(proxyBeanMethods=false)
class CollectionJsonMediaTypeConfiguration
implements HypermediaMappingInformation {
    CollectionJsonMediaTypeConfiguration() {
    }

    @Bean
    LinkDiscoverer collectionJsonLinkDiscoverer() {
        return new CollectionJsonLinkDiscoverer();
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return Collections.singletonList(EnableHypermediaSupport.HypermediaType.COLLECTION_JSON.getMediaType());
    }

    @Override
    @NonNull
    public Module getJacksonModule() {
        return new Jackson2CollectionJsonModule();
    }
}

