/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.model.NameSpace;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.file.services.NameSpaceService;
import org.exoplatform.commons.file.services.impl.FileServiceImpl$AjcClosure1;
import org.exoplatform.commons.file.services.impl.FileServiceImpl$AjcClosure3;
import org.exoplatform.commons.file.services.util.FileChecksum;
import org.exoplatform.commons.file.storage.DataStorage;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileServiceImpl
implements FileService {
    private static final Log LOG;
    private static final String FILE_CREATED_EVENT = "file.created";
    private static final String FILE_UPDATED_EVENT = "file.updated";
    private static final String FILE_DELETED_EVENT = "file.deleted";
    private DataStorage dataStorage;
    private BinaryProvider binaryProvider;
    private NameSpaceService nameSpaceService;
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public FileServiceImpl(DataStorage dataStorage, BinaryProvider resourceProvider, NameSpaceService nameSpaceService, ListenerService listenerService) {
        this.dataStorage = dataStorage;
        this.binaryProvider = resourceProvider;
        this.nameSpaceService = nameSpaceService;
        this.listenerService = listenerService;
    }

    @Override
    public FileInfo getFileInfo(long id) {
        FileInfo fileInfo = this.dataStorage.getFileInfo(id);
        if (fileInfo != null && fileInfo.isDeleted()) {
            return null;
        }
        return fileInfo;
    }

    @Override
    public List<FileInfo> getFileInfoListByChecksum(String checksum) {
        return this.dataStorage.getFileInfoListByChecksum(checksum);
    }

    @Override
    public FileItem getFile(long id) throws FileStorageException {
        FileInfo fileInfo = this.getFileInfo(id);
        if (fileInfo == null || fileInfo.isDeleted() || StringUtils.isEmpty((CharSequence)fileInfo.getChecksum())) {
            return null;
        }
        try {
            FileItem fileItem = new FileItem(fileInfo, null);
            InputStream inputStream = this.binaryProvider.getStream(fileInfo.getChecksum());
            fileItem.setInputStream(inputStream);
            return fileItem;
        }
        catch (Exception e) {
            throw new FileStorageException("Cannot get File Item ID=" + id, e);
        }
    }

    @Override
    @ExoTransactional
    public FileItem writeFile(FileItem file) throws FileStorageException, IOException {
        FileItem fileItem = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)fileItem);
        Object[] objectArray = new Object[]{this, fileItem, joinPoint};
        FileServiceImpl$AjcClosure1 fileServiceImpl$AjcClosure1 = new FileServiceImpl$AjcClosure1(objectArray);
        return (FileItem)ExoTransactionalAspect.aspectOf().around(fileServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public FileItem updateFile(FileItem file) throws FileStorageException, IOException {
        FileItem fileItem = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)fileItem);
        Object[] objectArray = new Object[]{this, fileItem, joinPoint};
        FileServiceImpl$AjcClosure3 fileServiceImpl$AjcClosure3 = new FileServiceImpl$AjcClosure3(objectArray);
        return (FileItem)ExoTransactionalAspect.aspectOf().around(fileServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    public FileInfo deleteFile(long id) {
        FileInfo fileInfo = this.dataStorage.getFileInfo(id);
        if (fileInfo == null || fileInfo.isDeleted()) {
            return null;
        }
        String checksum = fileInfo.getChecksum();
        if (this.dataStorage.sharedChecksum(checksum) == 1) {
            try {
                this.binaryProvider.remove(checksum);
            }
            catch (IOException e) {
                LOG.warn("Error while effective removal of file with id {} and checksum {}. Continue deleting file definition.", new Object[]{id, checksum, e});
            }
            this.dataStorage.deleteFileInfo(fileInfo.getId());
        } else {
            fileInfo.setDeleted(true);
            fileInfo = this.dataStorage.updateFileInfo(fileInfo);
        }
        this.listenerService.broadcast(FILE_DELETED_EVENT, (Object)fileInfo, null);
        return fileInfo;
    }

    @Override
    public List<FileItem> getFilesByChecksum(String checksum) throws FileStorageException {
        ArrayList<FileItem> fileItemList = new ArrayList<FileItem>();
        List<FileInfo> fileInfoList = this.getFileInfoListByChecksum(checksum);
        try {
            for (FileInfo fileInfo : fileInfoList) {
                FileItem fileItem = new FileItem(fileInfo, null);
                InputStream inputStream = this.binaryProvider.getStream(fileInfo.getChecksum());
                fileItem.setInputStream(inputStream);
                fileItemList.add(fileItem);
            }
        }
        catch (Exception e) {
            throw new FileStorageException("Cannot get File Item CHECKSUM=" + checksum, e);
        }
        return fileItemList;
    }

    private FileInfo insertFile(FileInfo fileInfo, NameSpace nameSpace, InputStream inputStream) throws FileStorageException, IOException {
        String checksum = this.generateChecksum(inputStream);
        fileInfo.setChecksum(checksum);
        if (!this.binaryProvider.exists(checksum)) {
            inputStream.reset();
            this.binaryProvider.put(checksum, inputStream);
        }
        try {
            return this.dataStorage.create(fileInfo, nameSpace);
        }
        catch (Exception e) {
            try {
                this.binaryProvider.remove(checksum);
            }
            catch (IOException e1) {
                LOG.error((Object)"Error while rollback writing file");
            }
            throw new FileStorageException(String.format("Error while writing file %s", fileInfo.getName()), e);
        }
    }

    private FileInfo updateFile(FileInfo fileInfo, InputStream inputStream) throws FileStorageException, IOException {
        String oldChecksum = this.getFileChecksum(fileInfo.getId());
        String newChecksum = this.generateChecksum(inputStream);
        if (!this.binaryProvider.exists(newChecksum)) {
            inputStream.reset();
            this.binaryProvider.put(newChecksum, inputStream);
        }
        try {
            fileInfo.setChecksum(newChecksum);
            fileInfo = this.dataStorage.updateFileInfo(fileInfo);
        }
        catch (Exception e) {
            try {
                this.binaryProvider.remove(newChecksum);
            }
            catch (IOException e1) {
                LOG.warn("Error while rollback written file {}", new Object[]{fileInfo.getId(), e1});
            }
            throw new FileStorageException("Error while writing file " + fileInfo.getName(), e);
        }
        this.removeFileByChecksum(oldChecksum);
        return fileInfo;
    }

    private void removeFileByChecksum(String checksum) {
        try {
            if (StringUtils.isNotBlank((CharSequence)checksum) && this.binaryProvider.exists(checksum) && this.dataStorage.sharedChecksum(checksum) == 1) {
                this.binaryProvider.remove(checksum);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Error while cleaning replaced file, ignore removing file and continue", (Throwable)e);
        }
    }

    private String getFileChecksum(Long fileId) {
        FileInfo fileInfo = this.dataStorage.getFileInfo(fileId);
        return fileInfo == null ? null : fileInfo.getChecksum();
    }

    private String generateChecksum(InputStream inputStream) {
        String fileChecksum = FileChecksum.getChecksum(inputStream);
        return FileChecksum.getChecksum(fileChecksum + UUID.randomUUID().toString());
    }

    static {
        FileServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(FileServiceImpl.class);
    }

    static final /* synthetic */ FileItem writeFile_aroundBody0(FileServiceImpl ajc$this, FileItem file, JoinPoint joinPoint) {
        FileInfo fileInfo = file.getFileInfo();
        if (fileInfo.getId() != null && fileInfo.getId() > 0L) {
            return ajc$this.updateFile(file);
        }
        InputStream inputStream = file.getAsStream();
        NameSpace nSpace = ajc$this.dataStorage.getNameSpace((String)StringUtils.firstNonBlank((CharSequence[])new String[]{fileInfo.getNameSpace(), ajc$this.nameSpaceService.getDefaultNameSpace()}));
        FileInfo createdFileInfo = ajc$this.insertFile(fileInfo, nSpace, inputStream);
        file.setFileInfo(createdFileInfo);
        ajc$this.listenerService.broadcast(FILE_CREATED_EVENT, (Object)createdFileInfo, null);
        return file;
    }

    static final /* synthetic */ FileItem updateFile_aroundBody2(FileServiceImpl ajc$this, FileItem file, JoinPoint joinPoint) {
        FileInfo fileInfo = file.getFileInfo();
        if (fileInfo == null || fileInfo.getId() == null) {
            throw new IllegalArgumentException("FileInfo id is required to update the binary");
        }
        FileInfo updatedFileInfo = ajc$this.updateFile(fileInfo, file.getAsStream());
        if (updatedFileInfo != null) {
            file.setFileInfo(updatedFileInfo);
            ajc$this.listenerService.broadcast(FILE_UPDATED_EVENT, (Object)updatedFileInfo, null);
            return file;
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FileServiceImpl.java", FileServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "writeFile", "org.exoplatform.commons.file.services.impl.FileServiceImpl", "org.exoplatform.commons.file.model.FileItem", "file", "org.exoplatform.commons.file.services.FileStorageException:java.io.IOException", "org.exoplatform.commons.file.model.FileItem"), 94);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateFile", "org.exoplatform.commons.file.services.impl.FileServiceImpl", "org.exoplatform.commons.file.model.FileItem", "file", "org.exoplatform.commons.file.services.FileStorageException:java.io.IOException", "org.exoplatform.commons.file.model.FileItem"), 111);
    }
}

