/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.suggest;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIAspect;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.rest.suggest.PeopleRestServices$AjcClosure1;
import org.exoplatform.social.service.rest.Util;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/homepage/intranet/people/")
@Produces(value={"application/json"})
@Deprecated
public class PeopleRestServices
implements ResourceContainer {
    private static final int NUMBER_OF_SUGGESTIONS = 10;
    private static Log log;
    private static final CacheControl cacheControl;
    private UserACL userACL;
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public PeopleRestServices(UserACL userACL, IdentityManager identityManager, RelationshipManager relationshipManager) {
        this.userACL = userACL;
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
    }

    @GET
    @Path(value="contacts/suggestions")
    @DeprecatedAPI(value="Use UserRestResourcesV1.getUsers instead")
    public Response getSuggestions(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        SecurityContext securityContext = sc;
        UriInfo uriInfo2 = uriInfo;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)securityContext, (Object)uriInfo2);
        Object[] objectArray = new Object[]{this, securityContext, uriInfo2, joinPoint};
        PeopleRestServices$AjcClosure1 peopleRestServices$AjcClosure1 = new PeopleRestServices$AjcClosure1(objectArray);
        return (Response)DeprecatedAPIAspect.aspectOf().around(peopleRestServices$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        PeopleRestServices.ajc$preClinit();
        log = ExoLogger.getLogger(PeopleRestServices.class);
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    static final /* synthetic */ Response getSuggestions_aroundBody0(PeopleRestServices ajc$this, SecurityContext sc, UriInfo uriInfo, JoinPoint joinPoint) {
        try {
            Map connectionsSuggestions;
            String userId = ajc$this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            Identity identity = ajc$this.identityManager.getOrCreateIdentity("organization", userId, false);
            ListAccess connectionList = ajc$this.relationshipManager.getConnections(identity);
            int size = connectionList.getSize();
            if (size > 0) {
                connectionsSuggestions = ajc$this.relationshipManager.getSuggestions(identity, 20, 50, 10);
                if (connectionsSuggestions.size() == 1 && ((Identity)connectionsSuggestions.keySet().iterator().next()).getRemoteId().equals(ajc$this.userACL.getSuperUser())) {
                    connectionsSuggestions = Collections.emptyMap();
                }
            } else {
                connectionsSuggestions = Collections.emptyMap();
            }
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            Map<Identity, Integer> suggestions = new LinkedHashMap(connectionsSuggestions);
            if ((suggestions = (Map)suggestions.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new))).size() < 10) {
                List identities = ajc$this.identityManager.getLastIdentities(10 - suggestions.size());
                for (Identity id : identities) {
                    if (identity.equals((Object)id) || ajc$this.relationshipManager.get(identity, id) != null) continue;
                    suggestions.putIfAbsent(id, 0);
                }
            }
            for (Map.Entry suggestion : suggestions.entrySet()) {
                String position;
                Identity id;
                id = (Identity)suggestion.getKey();
                if (id == null) continue;
                boolean isExternal = Util.isExternal(id.getId());
                if (id.getRemoteId().equals(ajc$this.userACL.getSuperUser()) || isExternal) continue;
                JSONObject json = new JSONObject();
                Profile socialProfile = id.getProfile();
                String avatar = socialProfile.getAvatarUrl();
                if (avatar == null) {
                    avatar = "/platform-ui/skin/images/avatar/DefaultUserAvatar.png";
                }
                if ((position = socialProfile.getPosition()) == null) {
                    position = "";
                }
                json.put("username", (Object)id.getRemoteId());
                json.put("suggestionName", (Object)socialProfile.getFullName());
                json.put("suggestionId", (Object)id.getId());
                json.put("avatar", (Object)avatar);
                json.put("profile", (Object)socialProfile.getUrl());
                json.put("title", (Object)position);
                json.put("number", suggestion.getValue());
                json.put("createdDate", socialProfile.getCreatedTime());
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("items", (Object)jsonArray);
            jsonGlobal.put("noConnections", size);
            jsonGlobal.put("username", (Object)userId);
            return Response.ok((Object)jsonGlobal.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in getting GS progress: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PeopleRestServices.java", PeopleRestServices.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSuggestions", "org.exoplatform.social.rest.suggest.PeopleRestServices", "javax.ws.rs.core.SecurityContext:javax.ws.rs.core.UriInfo", "sc:uriInfo", "", "javax.ws.rs.core.Response"), 65);
    }
}

