/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.exoplatform.commons.file.model.FileInfo;

public class FileItem {
    protected FileInfo fileInfo;
    protected byte[] data;

    public FileItem(FileInfo fileInfo, InputStream inputStream) throws Exception {
        this.fileInfo = fileInfo;
        if (inputStream != null) {
            this.data = IOUtils.toByteArray((InputStream)inputStream);
        }
    }

    public FileItem(Long id, String name, String mimetype, String nameSpace, long size, Date updatedDate, String updater, boolean deleted, InputStream inputStream) throws Exception {
        this.fileInfo = new FileInfo(id, name, mimetype, nameSpace, size, updatedDate, updater, null, deleted);
        if (inputStream != null) {
            this.data = IOUtils.toByteArray((InputStream)inputStream);
        }
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public InputStream getAsStream() {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        return null;
    }

    public byte[] getAsByte() {
        return this.data;
    }

    public void setInputStream(InputStream inputStream) throws Exception {
        if (inputStream != null) {
            this.data = IOUtils.toByteArray((InputStream)inputStream);
        }
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }
}

