/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.web.transaction;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.EnvironmentContext;

public class PortalTransactionFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger(PortalTransactionFilter.class);
    private PortalContainer container;
    private List<ComponentRequestLifecycle> transactionalServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.container == null) {
            this.initFilter();
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            Map results = RequestLifeCycle.end();
            for (Map.Entry entry : results.entrySet()) {
                if (entry.getValue() == null) continue;
                LOG.error((Object)("An error occurred while calling the method endRequest on " + entry.getKey()), (Throwable)entry.getValue());
            }
            EnvironmentContext.setCurrent(null);
            for (ComponentRequestLifecycle service : this.transactionalServices) {
                if (!service.isStarted((ExoContainer)this.container)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The service {} didn't called endRequest, uri = {}, http method = {}. Commit transaction anyway.", new Object[]{service.getClass().getName(), ((HttpServletRequest)request).getRequestURI(), ((HttpServletRequest)request).getMethod()});
                }
                service.endRequest((ExoContainer)this.container);
                if (!service.isStarted((ExoContainer)this.container)) continue;
                LOG.error("The service {} didn't ended properly even after calling endRequest", new Object[]{service.getClass().getName(), ((HttpServletRequest)request).getRequestURI(), ((HttpServletRequest)request).getMethod()});
            }
            throw throwable;
        }
        Map results = RequestLifeCycle.end();
        for (Map.Entry entry : results.entrySet()) {
            if (entry.getValue() == null) continue;
            LOG.error((Object)("An error occurred while calling the method endRequest on " + entry.getKey()), (Throwable)entry.getValue());
        }
        EnvironmentContext.setCurrent(null);
        for (ComponentRequestLifecycle service : this.transactionalServices) {
            if (!service.isStarted((ExoContainer)this.container)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("The service {} didn't called endRequest, uri = {}, http method = {}. Commit transaction anyway.", new Object[]{service.getClass().getName(), ((HttpServletRequest)request).getRequestURI(), ((HttpServletRequest)request).getMethod()});
            }
            service.endRequest((ExoContainer)this.container);
            if (!service.isStarted((ExoContainer)this.container)) continue;
            LOG.error("The service {} didn't ended properly even after calling endRequest", new Object[]{service.getClass().getName(), ((HttpServletRequest)request).getRequestURI(), ((HttpServletRequest)request).getMethod()});
        }
    }

    private void initFilter() {
        this.container = PortalContainer.getInstance();
        this.transactionalServices = this.container.getComponentInstancesOfType(ComponentRequestLifecycle.class);
    }
}

