/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RuntimeField {
    private final String name;
    private final String type;
    @Nullable
    private final String script;
    @Nullable
    Map<String, Object> params;

    public RuntimeField(String name, String type) {
        this(name, type, null, null);
    }

    public RuntimeField(String name, String type, String script) {
        this(name, type, script, null);
    }

    public RuntimeField(String name, String type, @Nullable String script, @Nullable Map<String, Object> params) {
        Assert.notNull((Object)name, (String)"name must not be null");
        Assert.notNull((Object)type, (String)"type must not be null");
        this.name = name;
        this.type = type;
        this.script = script;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getMapping() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.type);
        if (this.script != null) {
            map.put("script", this.script);
        }
        return map;
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public String getScript() {
        return this.script;
    }

    @Nullable
    public Map<String, Object> getParams() {
        return this.params;
    }
}

