/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.ShardsStatsSummaryItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardsStatsSummary
implements JsonpSerializable {
    private final ShardsStatsSummaryItem incremental;
    private final ShardsStatsSummaryItem total;
    private final long startTimeInMillis;
    @Nullable
    private final Time time;
    private final long timeInMillis;
    public static final JsonpDeserializer<ShardsStatsSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsStatsSummary::setupShardsStatsSummaryDeserializer);

    private ShardsStatsSummary(Builder builder) {
        this.incremental = ApiTypeHelper.requireNonNull(builder.incremental, this, "incremental");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, this, "startTimeInMillis");
        this.time = builder.time;
        this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, this, "timeInMillis");
    }

    public static ShardsStatsSummary of(Function<Builder, ObjectBuilder<ShardsStatsSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardsStatsSummaryItem incremental() {
        return this.incremental;
    }

    public final ShardsStatsSummaryItem total() {
        return this.total;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    public final long timeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("incremental");
        this.incremental.serialize(generator, mapper);
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.time != null) {
            generator.writeKey("time");
            this.time.serialize(generator, mapper);
        }
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupShardsStatsSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::incremental, ShardsStatsSummaryItem._DESERIALIZER, "incremental");
        op.add(Builder::total, ShardsStatsSummaryItem._DESERIALIZER, "total");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::time, Time._DESERIALIZER, "time");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardsStatsSummary> {
        private ShardsStatsSummaryItem incremental;
        private ShardsStatsSummaryItem total;
        private Long startTimeInMillis;
        @Nullable
        private Time time;
        private Long timeInMillis;

        public final Builder incremental(ShardsStatsSummaryItem value) {
            this.incremental = value;
            return this;
        }

        public final Builder incremental(Function<ShardsStatsSummaryItem.Builder, ObjectBuilder<ShardsStatsSummaryItem>> fn) {
            return this.incremental(fn.apply(new ShardsStatsSummaryItem.Builder()).build());
        }

        public final Builder total(ShardsStatsSummaryItem value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<ShardsStatsSummaryItem.Builder, ObjectBuilder<ShardsStatsSummaryItem>> fn) {
            return this.total(fn.apply(new ShardsStatsSummaryItem.Builder()).build());
        }

        public final Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardsStatsSummary build() {
            this._checkSingleUse();
            return new ShardsStatsSummary(this);
        }
    }
}

