/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.application.StandaloneAppRequestContext;
import org.exoplatform.portal.application.StandaloneApplication;
import org.exoplatform.portal.application.StandaloneApplicationFactory;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.Application;

public class StandaloneAppRequestHandler
extends PortalRequestHandler {
    private static StandaloneApplicationFactory appProvider;
    private String webuiConfigPath;

    public StandaloneAppRequestHandler(InitParams params) {
        ValueParam valueParam = params.getValueParam("webui.configuration");
        if (valueParam != null) {
            this.webuiConfigPath = valueParam.getValue();
        }
    }

    @Override
    public String getHandlerName() {
        return "standalone";
    }

    @Override
    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        StandaloneApplication application = appProvider != null ? (StandaloneApplication)appProvider.createApplication(sConfig) : new StandaloneApplication(sConfig);
        application.setWebUIConfigPath(this.webuiConfigPath);
        application.onInit();
        controller.addApplication((Application)application);
    }

    @Override
    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpServletRequest req = controllerContext.getRequest();
        HttpServletResponse res = controllerContext.getResponse();
        log.debug((Object)("Session ID = " + req.getSession().getId()));
        res.setHeader("Cache-Control", "no-cache");
        String siteName = req.getRemoteUser();
        String requestPath = controllerContext.getParameter(REQUEST_PATH);
        StandaloneApplication app = (StandaloneApplication)controllerContext.getController().getApplication("StandaloneApplication");
        StandaloneAppRequestContext context = new StandaloneAppRequestContext(app, controllerContext, siteName == null ? "" : siteName, requestPath);
        if (req.getRemoteUser() == null) {
            context.requestAuthenticationLogin();
        } else {
            this.processRequest(context, app);
        }
        return true;
    }

    static {
        block0: {
            StandaloneApplicationFactory factory;
            ServiceLoader<StandaloneApplicationFactory> loader = ServiceLoader.load(StandaloneApplicationFactory.class);
            Iterator<StandaloneApplicationFactory> iterator = loader.iterator();
            if (!iterator.hasNext()) break block0;
            appProvider = factory = iterator.next();
        }
    }
}

