/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.entity;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Map;

@Entity(name="EventEntity")
@Table(name="GAMIFICATION_EVENTS")
@NamedQueries(value={@NamedQuery(name="EventEntity.getEventByTitleAndTrigger", query="SELECT event FROM EventEntity event WHERE event.title =: title AND event.trigger =: trigger"), @NamedQuery(name="EventEntity.getEventsByTitle", query="SELECT event FROM EventEntity event WHERE event.title =: title ORDER BY event.type ASC")})
public class EventEntity
implements Serializable {
    private static final long serialVersionUID = 5354086158209637891L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_EVENTS_ID", sequenceName="SEQ_GAMIFICATION_EVENTS_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_EVENTS_ID")
    @Column(name="ID")
    private Long id;
    @Column(name="TITLE", nullable=false)
    private String title;
    @Column(name="TYPE", nullable=false)
    private String type;
    @Column(name="EVENT_TRIGGER", nullable=false)
    private String trigger;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE")
    @CollectionTable(name="GAMIFICATION_EVENT_SETTINGS", joinColumns={@JoinColumn(name="ID")})
    private Map<String, String> properties;

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventEntity)) {
            return false;
        }
        EventEntity other = (EventEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$trigger = this.getTrigger();
        String other$trigger = other.getTrigger();
        if (this$trigger == null ? other$trigger != null : !this$trigger.equals(other$trigger)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : $trigger.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "EventEntity(id=" + this.getId() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", trigger=" + this.getTrigger() + ", properties=" + this.getProperties() + ")";
    }
}

