/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.service;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.kudos.exception.KudosAlreadyLinkedException;
import org.exoplatform.kudos.model.AccountSettings;
import org.exoplatform.kudos.model.GlobalSettings;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosPeriod;
import org.exoplatform.kudos.model.KudosPeriodType;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.kudos.storage.KudosStorage;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class KudosService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(KudosService.class);
    private static final String CLUSTER_GLOBAL_SETTINGS_UPDATED = "KudosService-GlobalSettings-Updated";
    private static final String CLUSTER_NODE_ID = UUID.randomUUID().toString();
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private KudosStorage kudosStorage;
    private SettingService settingService;
    private PortalContainer container;
    private RPCService rpcService;
    private GlobalSettings globalSettings;
    private RemoteCommand reloadSettingsCommand;

    public KudosService(KudosStorage kudosStorage, SettingService settingService, ActivityManager activityManager, SpaceService spaceService, IdentityManager identityManager, ListenerService listenerService, PortalContainer container, InitParams params) {
        this.kudosStorage = kudosStorage;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
        this.spaceService = spaceService;
        this.settingService = settingService;
        this.listenerService = listenerService;
        this.container = container;
        if (params != null) {
            this.globalSettings = new GlobalSettings();
            if (params.containsKey((Object)"defaultAccessPermission")) {
                String defaultAccessPermission = params.getValueParam("defaultAccessPermission").getValue();
                this.globalSettings.setAccessPermission(defaultAccessPermission);
            }
            if (params.containsKey((Object)"defaultKudosPerPeriod")) {
                String defaultKudosPerPeriod = params.getValueParam("defaultKudosPerPeriod").getValue();
                this.globalSettings.setKudosPerPeriod(Long.parseLong(defaultKudosPerPeriod));
            }
        }
    }

    public void start() {
        GlobalSettings loadedGlobalSettings = this.loadGlobalSettings();
        if (loadedGlobalSettings != null) {
            this.globalSettings = loadedGlobalSettings;
        }
        this.installClusterListener();
    }

    public void stop() {
    }

    public GlobalSettings getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = this.loadGlobalSettings();
        }
        return this.globalSettings;
    }

    public void saveGlobalSettings(GlobalSettings settings) {
        this.settingService.set(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS", SettingValue.create((String)settings.toStringToPersist()));
        this.globalSettings = null;
        this.clearCacheClusterWide();
    }

    public AccountSettings getAccountSettings(String username) {
        AccountSettings accountSettings = new AccountSettings();
        if (!this.isAuthorizedOnKudosModule(username)) {
            accountSettings.setDisabled(true);
            return accountSettings;
        }
        org.exoplatform.social.core.identity.model.Identity senderIdentity = (org.exoplatform.social.core.identity.model.Identity)this.checkStatusAndGetReceiver("organization", username);
        long senderIdentityId = Long.parseLong(senderIdentity.getId());
        long sentKudos = this.kudosStorage.countKudosByPeriodAndSender(this.getCurrentKudosPeriod(), senderIdentityId);
        accountSettings.setRemainingKudos(this.getAllowedKudosPerPeriod() - sentKudos);
        return accountSettings;
    }

    public Kudos createKudos(Kudos kudos, String currentUser) throws Exception {
        org.exoplatform.social.core.identity.model.Identity senderIdentity;
        long senderIdentityId;
        if (!StringUtils.equals((CharSequence)currentUser, (CharSequence)kudos.getSenderId())) {
            throw new IllegalAccessException("User with id '" + currentUser + "' is not authorized to send kudos on behalf of " + kudos.getSenderId());
        }
        if (StringUtils.equals((CharSequence)currentUser, (CharSequence)kudos.getReceiverId())) {
            throw new IllegalAccessException("User with username '" + currentUser + "' is not authorized to send kudos to himseld!");
        }
        KudosPeriod currentPeriod = this.getCurrentKudosPeriod();
        if (this.kudosStorage.countKudosByPeriodAndSender(currentPeriod, senderIdentityId = Long.parseLong((senderIdentity = (org.exoplatform.social.core.identity.model.Identity)this.checkStatusAndGetReceiver("organization", currentUser)).getId())) >= this.getAllowedKudosPerPeriod()) {
            throw new IllegalAccessException("User having username'" + currentUser + "' is not authorized to send more kudos");
        }
        if (kudos.getSenderIdentityId() == null) {
            kudos.setSenderIdentityId(senderIdentity.getId());
        }
        Object receiverObject = this.checkStatusAndGetReceiver(kudos.getReceiverType(), kudos.getReceiverId());
        if (kudos.getReceiverIdentityId() == null) {
            if (receiverObject instanceof org.exoplatform.social.core.identity.model.Identity) {
                org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)receiverObject;
                kudos.setReceiverIdentityId(identity.getId());
            } else if (receiverObject instanceof Space) {
                Space space = (Space)receiverObject;
                kudos.setReceiverIdentityId(space.getId());
            }
        }
        kudos.setTimeInSeconds(Utils.timeToSeconds(LocalDateTime.now()));
        Kudos createdKudos = this.kudosStorage.createKudos(kudos);
        createdKudos.setSpacePrettyName(kudos.getSpacePrettyName());
        this.listenerService.broadcast("exo.kudos.sent", (Object)this, (Object)createdKudos);
        return this.kudosStorage.getKudoById(createdKudos.getTechnicalId());
    }

    public void deleteKudosById(long kudosId, String username) throws Exception {
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        if (kudosId <= 0L) {
            throw new IllegalArgumentException("Kudos id has to be positive integer");
        }
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        if (kudos == null) {
            throw new ObjectNotFoundException("Kudos with id " + kudosId + " wasn't found");
        }
        if (!kudos.getSenderId().equals(username)) {
            throw new IllegalAccessException("user " + username + " is not allowed to delete kudos with id " + kudosId);
        }
        long kudosOfActivityCount = this.kudosStorage.countKudosOfActivity(kudos.getActivityId());
        if (kudosOfActivityCount > 1L) {
            throw new KudosAlreadyLinkedException("kudos with id " + kudosId + "already linked to kudos entities");
        }
        this.deleteKudosById(kudosId);
        this.listenerService.broadcast("kudos.cancel.activity", (Object)this, (Object)kudos);
    }

    public void deleteKudosById(long kudosId) throws ObjectNotFoundException {
        if (kudosId <= 0L) {
            throw new IllegalArgumentException("Kudos id has to be positive integer");
        }
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        if (kudos == null) {
            throw new ObjectNotFoundException("Kudos with id " + kudosId + " wasn't found");
        }
        this.kudosStorage.deleteKudosById(kudosId);
    }

    public void updateKudosGeneratedActivityId(long kudosId, long activityId) throws Exception {
        this.kudosStorage.saveKudosActivityId(kudosId, activityId);
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        this.listenerService.broadcast("exo.kudos.activity", (Object)this, (Object)kudos);
    }

    public Kudos getKudosByActivityId(Long activityId, Identity currentUser) throws IllegalAccessException {
        Kudos kudos = this.kudosStorage.getKudosByActivityId(activityId);
        if (kudos == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)kudos.getSenderId(), (CharSequence)currentUser.getUserId()) || StringUtils.equals((CharSequence)kudos.getReceiverId(), (CharSequence)currentUser.getUserId())) {
            return kudos;
        }
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(activityId));
        if (activity == null) {
            return null;
        }
        if (!this.activityManager.isActivityViewable(activity, currentUser)) {
            throw new IllegalAccessException("User " + currentUser.getUserId() + " isn't allowed to access kudos of activity with id " + activityId);
        }
        return kudos;
    }

    public Kudos getKudosByActivityId(Long activityId) {
        return this.kudosStorage.getKudosByActivityId(activityId);
    }

    public Kudos updateKudos(Kudos kudos) {
        return this.kudosStorage.updateKudos(kudos);
    }

    public List<Kudos> getKudosByPeriod(long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod period = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByPeriod(long dateInSeconds, KudosPeriodType periodType, int limit) {
        if (periodType == null) {
            throw new IllegalArgumentException("'periodType' is mandatory");
        }
        KudosPeriod period = periodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByPeriodOfDate(long dateInSeconds, int limit) {
        KudosPeriod period = this.getKudosPeriodOfTime(dateInSeconds);
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByEntity(String entityType, String entityId, int limit) {
        return this.kudosStorage.getKudosByEntity(entityType, entityId, limit);
    }

    public long countKudosByEntity(String entityType, String entityId) {
        return this.kudosStorage.countKudosByEntity(entityType, entityId);
    }

    public long countKudosByEntityAndSender(String entityType, String entityId, String senderIdentityId) {
        return this.kudosStorage.countKudosByEntityAndSender(entityType, entityId, senderIdentityId);
    }

    public long countKudosByPeriodAndSender(long senderIdentityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.countKudosByPeriodAndSender(kudosPeriod, senderIdentityId);
    }

    public List<Kudos> getKudosByPeriodAndSender(long senderIdentityId, long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.getKudosByPeriodAndSender(kudosPeriod, senderIdentityId, limit);
    }

    public long countKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (identity == null) {
            return 0L;
        }
        return this.kudosStorage.countKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId());
    }

    public Map<Long, Long> countKudosByPeriodAndReceivers(List<Long> identitiesId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.countKudosByPeriodAndReceivers(kudosPeriod, identitiesId);
    }

    public List<Kudos> getKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.kudosStorage.getKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId(), limit);
    }

    public List<Kudos> getKudosListOfActivity(String activityId, Identity currentUser) throws IllegalAccessException {
        if (currentUser == null) {
            throw new IllegalArgumentException("User is mandatory");
        }
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            return Collections.emptyList();
        }
        if (!this.activityManager.isActivityViewable(activity, currentUser)) {
            throw new IllegalAccessException("User " + currentUser.getUserId() + " isn't allowed to access kudos of activity with id " + activityId);
        }
        return this.getKudosListOfActivity(activityId);
    }

    public List<Kudos> getKudosListOfActivity(String activityId) {
        return this.kudosStorage.getKudosListOfActivity(Utils.getActivityId(activityId));
    }

    public boolean isAuthorizedOnKudosModule(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        String accessPermission = this.getAccessPermission();
        if (StringUtils.isBlank((CharSequence)accessPermission)) {
            return true;
        }
        Space space = Utils.getSpace(accessPermission);
        return this.spaceService.isSuperManager(username) || space != null && this.spaceService.isMember(space, username);
    }

    public KudosPeriodType getDefaultKudosPeriodType() {
        return Utils.getPeriodType(this.getGlobalSettings());
    }

    public KudosPeriod getCurrentKudosPeriod() {
        return Utils.getCurrentPeriod(this.getGlobalSettings());
    }

    public KudosPeriod getKudosPeriodOfTime(long dateInSeconds) {
        return Utils.getPeriodOfTime(this.getGlobalSettings(), Utils.timeFromSeconds(dateInSeconds));
    }

    public KudosPeriod getKudosPeriodOfTime(KudosPeriodType periodType, long dateInSeconds) {
        return periodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
    }

    private Object checkStatusAndGetReceiver(String type, String id) {
        if ("user".equals(type) || "organization".equals(type)) {
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", id);
            if (identity == null || !identity.isEnable() || identity.isDeleted()) {
                throw new IllegalStateException("User with identity id '" + id + "' doesn't have a valid and enabled social identity");
            }
            if (!this.isAuthorizedOnKudosModule(id)) {
                throw new IllegalStateException("User with identity id '" + id + "' isn't member of authorized group to send/receive kudos: " + this.getAccessPermission());
            }
            return identity;
        }
        Space space = Utils.getSpace(id);
        if (space == null) {
            throw new IllegalStateException("Space with id '" + id + "' wasn't found, thus it can't receive/send kudos");
        }
        return space;
    }

    private long getAllowedKudosPerPeriod() {
        GlobalSettings storedGlobalSettings = this.getGlobalSettings();
        return storedGlobalSettings == null ? 0L : storedGlobalSettings.getKudosPerPeriod();
    }

    private String getAccessPermission() {
        GlobalSettings storedGlobalSettings = this.getGlobalSettings();
        return storedGlobalSettings == null ? null : storedGlobalSettings.getAccessPermission();
    }

    private GlobalSettings loadGlobalSettings() {
        SettingValue globalSettingsValue = this.settingService.get(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS");
        if (globalSettingsValue == null || StringUtils.isBlank((CharSequence)globalSettingsValue.getValue().toString())) {
            return null;
        }
        return GlobalSettings.parseStringToObject(globalSettingsValue.getValue().toString());
    }

    private void installClusterListener() {
        RPCService clusterRpcService = this.getRpcService();
        if (clusterRpcService != null) {
            this.reloadSettingsCommand = clusterRpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return KudosService.CLUSTER_GLOBAL_SETTINGS_UPDATED;
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    if (!CLUSTER_NODE_ID.equals(args[0])) {
                        KudosService.this.globalSettings = null;
                    }
                    return Boolean.valueOf(true);
                }
            });
        }
    }

    private void clearCacheClusterWide() {
        if (this.reloadSettingsCommand != null) {
            try {
                this.getRpcService().executeCommandOnAllNodes(this.reloadSettingsCommand, false, new Serializable[]{CLUSTER_NODE_ID});
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occurred while clearing global settings cache on other nodes", (Throwable)e);
            }
        }
    }

    private RPCService getRpcService() {
        if (this.rpcService == null) {
            this.rpcService = (RPCService)this.container.getComponentInstanceOfType(RPCService.class);
        }
        return this.rpcService;
    }
}

