/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.CachedRelationshipStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.data.IdentityData;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ProfileData;
import org.exoplatform.social.core.storage.cache.model.key.IdentityCompositeKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListSpaceMembersKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceKey;
import org.exoplatform.social.core.storage.cache.selector.IdentityCacheSelector;

public class CachedIdentityStorage
implements IdentityStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedIdentityStorage.class);
    private final FutureExoCache<IdentityKey, IdentityData, ServiceContext<IdentityData>> identityCache;
    private final FutureExoCache<IdentityCompositeKey, IdentityKey, ServiceContext<IdentityKey>> identityIndexCache;
    private final FutureExoCache<IdentityKey, ProfileData, ServiceContext<ProfileData>> profileCache;
    private final FutureExoCache<IdentityFilterKey, IntegerData, ServiceContext<IntegerData>> identitiesCountCache;
    private final FutureExoCache<ListIdentitiesKey, ListIdentitiesData, ServiceContext<ListIdentitiesData>> identitiesCache;
    private final FutureExoCache<IdentityKey, Long, ServiceContext<Long>> profileAvatarCache;
    private final IdentityStorage storage;
    private final SocialStorageCacheService cacheService;
    private final FileService fileService;
    private CachedRelationshipStorage cachedRelationshipStorage;

    public CachedIdentityStorage(RDBMSIdentityStorageImpl storage, SocialStorageCacheService cacheService, FileService fileService) {
        this.storage = storage;
        this.cacheService = cacheService;
        this.fileService = fileService;
        this.identityCache = CacheType.IDENTITY.createFutureCache(cacheService.getIdentityCache());
        this.identityIndexCache = CacheType.IDENTITY_INDEX.createFutureCache(cacheService.getIdentityIndexCache());
        this.profileCache = CacheType.PROFILE.createFutureCache(cacheService.getProfileCache());
        this.identitiesCountCache = CacheType.IDENTITIES_COUNT.createFutureCache(cacheService.getCountIdentitiesCache());
        this.identitiesCache = CacheType.IDENTITIES.createFutureCache(cacheService.getIdentitiesCache());
        this.profileAvatarCache = CacheType.PROFILE_AVATAR.createFutureCache(cacheService.getProfileAvatarCache());
    }

    public void saveIdentity(Identity identity) throws IdentityStorageException {
        try {
            this.storage.saveIdentity(identity);
        }
        finally {
            this.clearIdentityCache(identity, true, true);
        }
    }

    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        try {
            Identity identity2 = this.storage.updateIdentity(identity);
            return identity2;
        }
        finally {
            this.clearIdentityCache(identity, false, true);
        }
    }

    public void updateIdentityMembership(String remoteId) throws IdentityStorageException {
        this.clearUserIdentitiesCache();
    }

    public String findIdentityId(String providerId, String remoteId) {
        IdentityCompositeKey key = new IdentityCompositeKey(providerId, remoteId);
        IdentityKey keyById = (IdentityKey)this.identityIndexCache.get(() -> {
            String identityId = this.storage.findIdentityId(providerId, remoteId);
            return new IdentityKey(identityId);
        }, (Object)key);
        return keyById != null && keyById.getId() != null ? keyById.getId() : null;
    }

    public Identity findIdentity(String providerId, String remoteId) throws IdentityStorageException {
        String identityId = this.findIdentityId(providerId, remoteId);
        if (identityId != null) {
            return this.findIdentityById(identityId);
        }
        return null;
    }

    public Identity findIdentityById(String identityId) throws IdentityStorageException {
        Identity identity = ((IdentityData)this.identityCache.get(() -> new IdentityData(this.storage.findIdentityById(identityId)), (Object)new IdentityKey(identityId))).build();
        if (identity != null) {
            identity.setProfile(null);
            identity.setProfileLoader(() -> this.loadProfile(new Profile(identity)));
        }
        return identity;
    }

    public void deleteIdentity(Identity identity) throws IdentityStorageException {
        try {
            this.storage.deleteIdentity(identity);
        }
        finally {
            this.clearIdentityCache(identity, true, true);
        }
    }

    public void hardDeleteIdentity(Identity identity) throws IdentityStorageException {
        try {
            this.storage.hardDeleteIdentity(identity);
        }
        finally {
            this.clearIdentityCache(identity, true, true);
        }
    }

    public Profile loadProfile(Profile profile) throws IdentityStorageException {
        Identity identity = profile.getIdentity();
        ProfileData profileData = (ProfileData)this.profileCache.get(() -> {
            Profile loadedProfile = this.storage.loadProfile(profile);
            if (loadedProfile == null) {
                LOG.warn((Object)("Null profile for identity: " + identity.getRemoteId()));
                return ProfileData.NULL_OBJECT;
            }
            return new ProfileData(loadedProfile);
        }, (Object)new IdentityKey(identity.getId()));
        if (profileData == null || profileData.getProfileId() == null) {
            identity.setProfile(null);
            return profile;
        }
        Profile loadedProfile = profileData.build();
        loadedProfile.setIdentity(identity);
        identity.setProfile(loadedProfile);
        return loadedProfile;
    }

    public void saveProfile(Profile profile) throws IdentityStorageException {
        try {
            this.storage.saveProfile(profile);
        }
        finally {
            this.clearIdentityCache(profile.getIdentity(), true, true);
        }
    }

    public void updateProfile(Profile profile) throws IdentityStorageException {
        try {
            this.storage.updateProfile(profile);
        }
        finally {
            this.clearIdentityCache(profile.getIdentity(), false, true);
        }
    }

    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        return this.storage.getIdentitiesCount(providerId);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        ListIdentitiesKey listKey = new ListIdentitiesKey(key, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(() -> {
            List got = this.storage.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
            return this.buildIds(got);
        }, (Object)listKey);
        return this.buildIdentities(keys);
    }

    public List<Identity> getIdentitiesForMentions(String providerId, ProfileFilter profileFilter, Relationship.Type type, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        return this.storage.getIdentitiesForMentions(providerId, profileFilter, type, offset, limit, forceLoadOrReloadProfile);
    }

    public int getIdentitiesForMentionsCount(String providerId, ProfileFilter profileFilter, Relationship.Type type) throws IdentityStorageException {
        return this.storage.getIdentitiesForMentionsCount(providerId, profileFilter, type);
    }

    public int getIdentitiesByProfileFilterCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        return (Integer)((IntegerData)this.identitiesCountCache.get(() -> new IntegerData(this.storage.getIdentitiesByProfileFilterCount(providerId, profileFilter)), (Object)new IdentityFilterKey(providerId, profileFilter))).build();
    }

    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, long offset, long limit) throws IdentityStorageException {
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(() -> {
            List got = this.storage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, type, offset, limit);
            return this.buildIds(got);
        }, (Object)new ListSpaceMembersKey(new SpaceKey(space.getId()), new IdentityFilterKey("space", profileFilter), type, offset, limit));
        return this.buildIdentities(keys);
    }

    public void updateProfileActivityId(Identity identity, String activityId, Profile.AttachedActivityType type) {
        this.storage.updateProfileActivityId(identity, activityId, type);
        IdentityKey key = new IdentityKey(new Identity(identity.getId()));
        this.profileCache.remove((Serializable)key);
        this.clearUserIdentitiesCache();
    }

    public String getProfileActivityId(Profile profile, Profile.AttachedActivityType type) {
        return this.storage.getProfileActivityId(profile, type);
    }

    public List<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter, long offset, long limit) throws IdentityStorageException {
        return this.storage.getIdentitiesForUnifiedSearch(providerId, profileFilter, offset, limit);
    }

    public void processEnabledIdentity(Identity identity, boolean isEnable) {
        try {
            this.storage.processEnabledIdentity(identity, isEnable);
        }
        finally {
            this.clearIdentityCache(identity, false, true);
            this.getCachedRelationshipStorage().clearAllRelationshipCache();
        }
    }

    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, int offset, int limit) {
        return this.storage.getIdentitiesWithRelationships(identityId, offset, limit);
    }

    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, String sortFieldName, String sortDirection, int offset, int limit) {
        return this.storage.getIdentitiesWithRelationships(identityId, sortFieldName, sortDirection, offset, limit);
    }

    public int countIdentitiesWithRelationships(String identityId) throws Exception {
        return this.storage.countIdentitiesWithRelationships(identityId);
    }

    public InputStream getAvatarInputStreamById(Identity identity) throws IOException {
        return this.storage.getAvatarInputStreamById(identity);
    }

    public FileItem getAvatarFile(Identity identity) {
        Long avatarId = (Long)this.profileAvatarCache.get(() -> {
            FileItem avatarFile = this.storage.getAvatarFile(identity);
            if (avatarFile == null) {
                return null;
            }
            return avatarFile.getFileInfo().getId();
        }, (Object)new IdentityKey(identity.getId()));
        try {
            return avatarId == null ? null : this.fileService.getFile(avatarId.longValue());
        }
        catch (FileStorageException e) {
            LOG.error((Object)("Error reading file with id " + avatarId), (Throwable)e);
            return null;
        }
    }

    public InputStream getBannerInputStreamById(Identity identity) throws IOException {
        return this.storage.getBannerInputStreamById(identity);
    }

    public int countSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type) {
        return this.storage.countSpaceMemberIdentitiesByProfileFilter(space, profileFilter, type);
    }

    public List<String> getIdentityIds(String providerId, String sortField, String sortDirection, boolean isEnabled, String userType, Boolean isConnected, String enrollmentStatus, long offset, long limit) {
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setEnabled(isEnabled);
        profileFilter.setUserType(userType);
        profileFilter.setConnected(isConnected);
        profileFilter.setEnrollmentStatus(enrollmentStatus);
        profileFilter.setSorting(Sorting.valueOf((String)sortField, (String)sortDirection));
        IdentityFilterKey key = new IdentityFilterKey(providerId, profileFilter);
        ListIdentitiesKey listKey = new ListIdentitiesKey(key, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.identitiesCache.get(() -> {
            List identityIds = this.storage.getIdentityIds(providerId, sortField, sortDirection, isEnabled, userType, isConnected, enrollmentStatus, offset, limit);
            return new ListIdentitiesData(identityIds.stream().map(IdentityKey::new).toList());
        }, (Object)listKey);
        return keys.getIds().stream().map(IdentityKey::getId).toList();
    }

    public List<Identity> getIdentities(String providerId, String sortField, String sortDirection, boolean isEnabled, String userType, Boolean isConnected, String enrollmentStatus, long offset, long limit) {
        List<String> identityIds = this.getIdentityIds(providerId, sortField, sortDirection, isEnabled, userType, isConnected, enrollmentStatus, offset, limit);
        return this.buildIdentities(identityIds);
    }

    public List<Identity> getIdentities(String providerId, long offset, long limit) {
        return this.getIdentities(providerId, null, null, true, null, null, null, offset, limit);
    }

    public List<String> sortIdentities(List<String> identityRemoteIds, String sortField, String sortDirection) {
        return this.storage.sortIdentities(identityRemoteIds, sortField, sortDirection);
    }

    public void setImageUploadLimit(int imageUploadLimit) {
        this.storage.setImageUploadLimit(imageUploadLimit);
    }

    public IdentityStorage getStorage() {
        return this.storage;
    }

    private CachedRelationshipStorage getCachedRelationshipStorage() {
        if (this.cachedRelationshipStorage == null) {
            this.cachedRelationshipStorage = (CachedRelationshipStorage)PortalContainer.getInstance().getComponentInstanceOfType(CachedRelationshipStorage.class);
        }
        return this.cachedRelationshipStorage;
    }

    private ListIdentitiesData buildIds(List<Identity> identities) {
        return new ListIdentitiesData(identities.stream().map(IdentityKey::new).toList());
    }

    private List<Identity> buildIdentities(ListIdentitiesData data) {
        return data.getIds().stream().map(k -> this.findIdentityById(k.getId())).toList();
    }

    private List<Identity> buildIdentities(List<String> ids) {
        return ids.stream().map(this::findIdentityById).toList();
    }

    void clearUserIdentitiesCache() {
        try {
            this.cacheService.getIdentitiesCache().select((CachedObjectSelector)new IdentityCacheSelector("organization"));
            this.cacheService.getCountIdentitiesCache().select((CachedObjectSelector)new IdentityCacheSelector("organization"));
        }
        catch (Exception e) {
            LOG.error((Object)"Error when clearing cache", (Throwable)e);
        }
    }

    public void clearIdentityCached(Identity identity, String oldRemoteId) {
        IdentityKey key = new IdentityKey(identity.getId());
        this.identityCache.remove((Serializable)key);
        this.identityIndexCache.remove((Serializable)new IdentityCompositeKey(identity.getProviderId(), oldRemoteId));
        this.profileCache.remove((Serializable)key);
        this.profileAvatarCache.remove((Serializable)key);
        this.clearUserIdentitiesCache();
    }

    public void clearIdentityCache(String providerId, String remoteId, boolean clearList) {
        Identity identity = this.findIdentity(providerId, remoteId);
        if (identity == null) {
            IdentityCompositeKey compositeKey = new IdentityCompositeKey(providerId, remoteId);
            IdentityKey identityKey = (IdentityKey)this.identityIndexCache.get((Serializable)compositeKey);
            if (identityKey != null) {
                this.identityIndexCache.remove((Serializable)compositeKey);
                this.identityCache.remove((Serializable)identityKey);
                this.profileCache.remove((Serializable)identityKey);
                this.profileAvatarCache.remove((Serializable)identityKey);
            }
        } else {
            IdentityKey key = new IdentityKey(identity.getId());
            this.identityCache.remove((Serializable)key);
            this.profileCache.remove((Serializable)key);
            this.profileAvatarCache.remove((Serializable)key);
            this.identityIndexCache.remove((Serializable)new IdentityCompositeKey(identity.getProviderId(), identity.getRemoteId()));
        }
        if (clearList) {
            this.clearUserIdentitiesCache();
        }
    }

    private void clearIdentityCache(Identity identity, boolean removeCachedId, boolean clearList) {
        IdentityKey key = new IdentityKey(identity.getId());
        this.identityCache.remove((Serializable)key);
        this.profileCache.remove((Serializable)key);
        this.profileAvatarCache.remove((Serializable)key);
        if (removeCachedId) {
            this.identityIndexCache.remove((Serializable)new IdentityCompositeKey(identity.getProviderId(), identity.getRemoteId()));
        }
        if (clearList) {
            this.clearUserIdentitiesCache();
        }
    }
}

