/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.integration;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.integration.SSOUtils;

public class SSODelegateValve
implements Valve,
Contained,
MBeanRegistration,
Lifecycle {
    private static final Log log = ExoLogger.getLogger(SSODelegateValve.class);
    private boolean delegationEnabled;
    private String delegateValveClassName;
    private Valve delegate;
    private Valve next;
    private Container context;
    private String samlSPConfigFile;

    public void setDelegateValveClassName(String delegateValve) {
        this.delegateValveClassName = this.substituteSystemProperty(delegateValve);
        log.debug((Object)("delegateValveClassName: " + this.delegateValveClassName));
    }

    public void setSsoDelegationEnabled(String enabled) {
        enabled = this.substituteSystemProperty(enabled);
        this.delegationEnabled = Boolean.parseBoolean(enabled);
        log.debug((Object)("ssoDelegationEnabled: " + this.delegationEnabled));
    }

    public void setSamlSPConfigFile(String configFile) {
        this.samlSPConfigFile = this.substituteSystemProperty(configFile);
    }

    public Valve getNext() {
        if (this.delegationEnabled) {
            Valve delegate = this.getOrLoadDelegate(this.delegateValveClassName);
            return delegate.getNext();
        }
        return this.next;
    }

    public void setNext(Valve valve) {
        if (this.delegationEnabled) {
            Valve delegate = this.getOrLoadDelegate(this.delegateValveClassName);
            delegate.setNext(valve);
        } else {
            this.next = valve;
        }
    }

    public void backgroundProcess() {
        if (this.delegationEnabled) {
            Valve delegate = this.getOrLoadDelegate(this.delegateValveClassName);
            delegate.backgroundProcess();
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.delegationEnabled) {
            Valve delegate = this.getOrLoadDelegate(this.delegateValveClassName);
            delegate.invoke(request, response);
        } else {
            this.next.invoke(request, response);
        }
    }

    public Container getContainer() {
        return this.context;
    }

    public void setContainer(Container container) {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Contained) {
            ((Contained)delegate).setContainer(container);
        }
        this.context = container;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof MBeanRegistration) {
            return ((MBeanRegistration)delegate).preRegister(server, name);
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof MBeanRegistration) {
            ((MBeanRegistration)delegate).postRegister(registrationDone);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof MBeanRegistration) {
            ((MBeanRegistration)delegate).preDeregister();
        }
    }

    @Override
    public void postDeregister() {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof MBeanRegistration) {
            ((MBeanRegistration)delegate).postDeregister();
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            ((Lifecycle)delegate).addLifecycleListener(listener);
            return;
        }
    }

    public LifecycleListener[] findLifecycleListeners() {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            return ((Lifecycle)delegate).findLifecycleListeners();
        }
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            ((Lifecycle)delegate).removeLifecycleListener(listener);
            return;
        }
    }

    public void start() throws LifecycleException {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            ((Lifecycle)delegate).start();
        }
    }

    public void stop() throws LifecycleException {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            ((Lifecycle)delegate).stop();
        }
    }

    private Valve getOrLoadDelegate(String className) {
        if (this.delegate == null) {
            if (className == null) {
                throw new IllegalStateException("Delegate className is null in SSODelegateValve");
            }
            Class<?> delegateClass = SSOUtils.loadClass(className);
            try {
                this.delegate = (Valve)delegateClass.newInstance();
                log.info((Object)("Delegating valve created successfully: " + this.delegate));
            }
            catch (Exception e) {
                throw new RuntimeException("Can't instantiate " + delegateClass, e);
            }
            if (this.samlSPConfigFile != null) {
                try {
                    Method m = delegateClass.getMethod("setConfigFile", String.class);
                    m.invoke((Object)this.delegate, this.samlSPConfigFile);
                    log.info((Object)("Picketlink configuration file successfully set to location: " + this.samlSPConfigFile));
                }
                catch (Exception e) {
                    log.trace((Object)("Can't set SAML config file. Method 'setConfigFile' not supported on class " + delegateClass), (Throwable)e);
                }
            }
        }
        return this.delegate;
    }

    private String substituteSystemProperty(String input) {
        input = input.replace("#", "$");
        return SSOUtils.substituteSystemProperty(input);
    }

    public void init() throws LifecycleException {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            ((Lifecycle)delegate).init();
        }
    }

    public void destroy() throws LifecycleException {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            ((Lifecycle)delegate).destroy();
        }
    }

    public LifecycleState getState() {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            return ((Lifecycle)delegate).getState();
        }
        return null;
    }

    public String getStateName() {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Lifecycle) {
            return ((Lifecycle)delegate).getStateName();
        }
        return null;
    }

    public boolean isAsyncSupported() {
        Valve delegate;
        if (this.delegationEnabled && (delegate = this.getOrLoadDelegate(this.delegateValveClassName)) instanceof Valve) {
            return delegate.isAsyncSupported();
        }
        return false;
    }
}

