/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.activity.processor;

import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.service.AnnouncementService;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;

@Deprecated(forRemoval=true, since="1.5.0")
public class AnnouncementActivityProcessor
extends BaseActivityProcessorPlugin {
    public static final String ANNOUNCEMENT_COMMENT_PARAM = "announcementComment";
    private static final Log LOG = ExoLogger.getLogger(AnnouncementActivityProcessor.class);
    private static final String APP_URL = "/contributions/actions/";
    private AnnouncementService announcementService;
    private IdentityManager identityManager;

    public AnnouncementActivityProcessor(AnnouncementService announcementService, IdentityManager identityManager, InitParams params) {
        super(params);
        this.announcementService = announcementService;
        this.identityManager = identityManager;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (!"challenges-announcement".equals(activity.getType())) {
            return;
        }
        if (activity.isComment() || activity.getType() == null) {
            return;
        }
        String announcementId = (String)activity.getTemplateParams().get("announcementId");
        if (StringUtils.isBlank((CharSequence)announcementId)) {
            LOG.error((Object)"announcement id must not null");
            return;
        }
        Announcement announcement = this.announcementService.getAnnouncementById(Long.parseLong(announcementId));
        if (announcement == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        Identity identity = this.identityManager.getIdentity(String.valueOf(announcement.getAssignee()));
        if (identity != null) {
            String title;
            params.put("announcementAssigneeUsername", identity.getRemoteId());
            params.put("announcementAssigneeFullName", identity.getProfile().getFullName());
            params.put("announcementChallenge", this.getAnnouncementChallenge(String.valueOf(announcement.getChallengeId()), (String)activity.getTemplateParams().get("announcementDescription")));
            if (activity.getTemplateParams().containsKey(ANNOUNCEMENT_COMMENT_PARAM) && StringUtils.isNotBlank((CharSequence)(title = (String)activity.getTemplateParams().get(ANNOUNCEMENT_COMMENT_PARAM)))) {
                activity.setTitle(title);
                activity.getTemplateParams().put(ANNOUNCEMENT_COMMENT_PARAM, null);
            }
            activity.getTemplateParams().putAll(params);
        }
    }

    private String getAnnouncementChallenge(String challengeId, String challengeDescription) {
        StringBuilder challenge = new StringBuilder();
        challenge.append("<a class='primary--text' href=\"");
        String portalName = LinkProvider.getPortalName((String)"");
        String portalOwner = LinkProvider.getPortalOwner((String)"");
        String url = "/" + portalName + "/" + portalOwner + APP_URL + challengeId;
        challenge.append(url);
        challenge.append("\" target=\"_self\"  rel=\"nofollow\"> ");
        challenge.append(challengeDescription);
        challenge.append(" </a>");
        return String.valueOf(challenge);
    }
}

