/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.transform.get_transform_stats.TransformStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetTransformStatsResponse
implements JsonpSerializable {
    private final long count;
    private final List<TransformStats> transforms;
    public static final JsonpDeserializer<GetTransformStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTransformStatsResponse::setupGetTransformStatsResponseDeserializer);

    private GetTransformStatsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.transforms = ApiTypeHelper.unmodifiableRequired(builder.transforms, (Object)this, "transforms");
    }

    public static GetTransformStatsResponse of(Function<Builder, ObjectBuilder<GetTransformStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<TransformStats> transforms() {
        return this.transforms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.transforms)) {
            generator.writeKey("transforms");
            generator.writeStartArray();
            for (TransformStats item0 : this.transforms) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetTransformStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::transforms, JsonpDeserializer.arrayDeserializer(TransformStats._DESERIALIZER), "transforms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetTransformStatsResponse> {
        private Long count;
        private List<TransformStats> transforms;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder transforms(List<TransformStats> list) {
            this.transforms = Builder._listAddAll(this.transforms, list);
            return this;
        }

        public final Builder transforms(TransformStats value, TransformStats ... values) {
            this.transforms = Builder._listAdd(this.transforms, value, values);
            return this;
        }

        public final Builder transforms(Function<TransformStats.Builder, ObjectBuilder<TransformStats>> fn) {
            return this.transforms(fn.apply(new TransformStats.Builder()).build(), new TransformStats[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetTransformStatsResponse build() {
            this._checkSingleUse();
            return new GetTransformStatsResponse(this);
        }
    }
}

