/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.storage.dao.impl;

import jakarta.persistence.TypedQuery;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.file.storage.dao.FileInfoDAO;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileInfoDAOImpl
extends GenericDAOJPAImpl<FileInfoEntity, Long>
implements FileInfoDAO {
    private static Log Log = ExoLogger.getLogger(FileInfoDAOImpl.class);

    @Override
    public List<FileInfoEntity> findDeletedFiles(Date date) {
        TypedQuery query = this.getEntityManager().createNamedQuery("fileEntity.findDeletedFiles", FileInfoEntity.class).setParameter("updatedDate", (Object)date);
        return query.getResultList();
    }

    @Override
    public List<FileInfoEntity> findFilesByChecksum(String checksum) {
        TypedQuery query = this.getEntityManager().createNamedQuery("fileEntity.findByChecksum", FileInfoEntity.class).setParameter("checksum", (Object)checksum);
        return query.getResultList();
    }

    @Override
    public List<FileInfoEntity> findAllByPage(int offset, int limit) {
        return this.getEntityManager().createNamedQuery("fileEntity.getAllByLimitOffset").setFirstResult(offset).setMaxResults(limit).getResultList();
    }
}

