/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageActionListener {

    public static class RemoveChildActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (uiPage.isModifiable()) {
                uiPage.removeChildById(id);
                Page page = (Page)PortalDataMapper.buildModelObject((UIComponent)uiPage);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                PageState pageState = Utils.toPageState((Page)page);
                LayoutService dataService = (LayoutService)uiPage.getApplicationComponent(LayoutService.class);
                dataService.save(new PageContext(page.getPageKey(), pageState), page);
                pcontext.ignoreAJAXUpdateOnPortlets(false);
                pcontext.setResponseComplete(true);
                pcontext.getWriter().write("OK");
            } else {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPage.msg.EditPermission.null", null));
            }
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UIPortalApplication> {
        public void execute(Event<UIPortalApplication> event) throws Exception {
            PortalRequestContext pcontext = PortalRequestContext.getCurrentInstance();
            UserPortal userPortal = pcontext.getUserPortalConfig().getUserPortal();
            UIPortalApplication uiPortalApp = (UIPortalApplication)((Object)event.getSource());
            UIPortal showedUIPortal = uiPortalApp.getCurrentSite();
            UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
            builder.withReadCheck();
            PageNodeEvent pageNodeEvent = (PageNodeEvent)event;
            String nodePath = pageNodeEvent.getTargetNodeUri();
            UserNode targetNode = null;
            SiteKey siteKey = pageNodeEvent.getSiteKey();
            if (siteKey != null) {
                NavigationService service;
                NavigationContext navContext;
                if (pcontext.getRemoteUser() == null && (siteKey.getType().equals((Object)SiteType.GROUP) || siteKey.getType().equals((Object)SiteType.USER)) && (navContext = (service = (NavigationService)uiPortalApp.getApplicationComponent(NavigationService.class)).loadNavigation(siteKey)) != null) {
                    uiPortalApp.setLastRequestNavData(null);
                    pcontext.requestAuthenticationLogin();
                    return;
                }
                UserNavigation navigation = userPortal.getNavigation(siteKey);
                if (navigation != null && (targetNode = userPortal.resolvePath(navigation, builder.build(), nodePath)) == null) {
                    if (pcontext.getRemoteUser() == null && siteKey.getType().equals((Object)SiteType.PORTAL)) {
                        targetNode = userPortal.resolvePath(navigation, null, nodePath);
                        if (targetNode != null) {
                            uiPortalApp.setLastRequestNavData(null);
                            pcontext.requestAuthenticationLogin();
                            return;
                        }
                    } else {
                        targetNode = userPortal.getDefaultPath(navigation, builder.build());
                    }
                }
            }
            if (targetNode == null && (targetNode = userPortal.getDefaultPath(builder.build())) == null) {
                if (showedUIPortal != null) {
                    UIPageBody uiPageBody = (UIPageBody)showedUIPortal.findFirstComponentOfType(UIPageBody.class);
                    uiPageBody.setUIComponent(null);
                }
                return;
            }
            UserNode currentNavPath = null;
            if (showedUIPortal != null) {
                currentNavPath = showedUIPortal.getNavPath();
            }
            if (currentNavPath != null && currentNavPath.getNavigation().getKey().equals((Object)siteKey)) {
                if (!currentNavPath.getURI().equals(targetNode.getURI())) {
                    showedUIPortal.setNavPath(targetNode);
                }
            } else {
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                uiWorkingWS.setRenderedChild("UIViewWS");
                uiPortalApp.setModeState(0);
                showedUIPortal = uiPortalApp.getCachedUIPortal(siteKey);
                if (showedUIPortal != null) {
                    showedUIPortal.setNavPath(targetNode);
                    uiPortalApp.setCurrentSite(showedUIPortal);
                    PortalConfig associatedPortalConfig = pcontext.getDynamicPortalConfig();
                    UserPortalConfig userPortalConfig = pcontext.getUserPortalConfig();
                    userPortalConfig.setPortalConfig(associatedPortalConfig);
                } else {
                    showedUIPortal = this.buildUIPortal(uiPortalApp, pcontext);
                    if (showedUIPortal == null) {
                        return;
                    }
                    showedUIPortal.setNavPath(targetNode);
                    uiPortalApp.setCurrentSite(showedUIPortal);
                    uiPortalApp.putCachedUIPortal(showedUIPortal);
                }
            }
            showedUIPortal.refreshUIPage();
            pcontext.ignoreAJAXUpdateOnPortlets(!pcontext.useAjax());
        }

        private UIPortal buildUIPortal(UIPortalApplication uiPortalApp, PortalRequestContext pcontext) throws Exception {
            PortalConfig portalConfig = pcontext.getDynamicPortalConfig();
            Container layout = portalConfig.getPortalLayout();
            if (layout != null) {
                pcontext.getUserPortalConfig().setPortalConfig(portalConfig);
            }
            UIPortal uiPortal = (UIPortal)uiPortalApp.createUIComponent(UIPortal.class, null, null);
            PortalDataMapper.toUIPortalWithMetaLayout(uiPortal, pcontext.getDynamicPortalConfig());
            return uiPortal;
        }
    }
}

