/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web.openid;

import io.meeds.oauth.openid.OpenIdAccessTokenContext;
import io.meeds.oauth.openid.OpenIdProcessor;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.utils.OAuthUtils;
import io.meeds.oauth.web.OAuthProviderFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class OpenIdFilter
extends OAuthProviderFilter<OpenIdAccessTokenContext> {
    @Override
    protected OAuthProviderType<OpenIdAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("OPENID", OpenIdAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_authState");
        request.getSession().removeAttribute("_verificationState");
    }

    @Override
    protected OAuthPrincipal<OpenIdAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<OpenIdAccessTokenContext> interactionState) {
        OpenIdAccessTokenContext accessTokenContext = interactionState.getAccessTokenContext();
        JSONObject userInfo = ((OpenIdProcessor)this.getOauthProviderProcessor()).obtainUserInfo(accessTokenContext);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Obtained tokenResponse from OpenId authentication: " + accessTokenContext));
        }
        return OAuthUtils.convertOpenIdInfoToOAuthPrincipal(userInfo, accessTokenContext, this.getOAuthProvider());
    }
}

