/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class FrequentItemSetsBucket
extends MultiBucketBase {
    private final Map<String, List<String>> key;
    private final double support;
    public static final JsonpDeserializer<FrequentItemSetsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FrequentItemSetsBucket::setupFrequentItemSetsBucketDeserializer);

    private FrequentItemSetsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.unmodifiableRequired(builder.key, (Object)this, "key");
        this.support = ApiTypeHelper.requireNonNull(builder.support, this, "support");
    }

    public static FrequentItemSetsBucket of(Function<Builder, ObjectBuilder<FrequentItemSetsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, List<String>> key() {
        return this.key;
    }

    public final double support() {
        return this.support;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.key)) {
            generator.writeKey("key");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.key.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (String item1 : item0.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("support");
        generator.write(this.support);
    }

    protected static void setupFrequentItemSetsBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "key");
        op.add(Builder::support, JsonpDeserializer.doubleDeserializer(), "support");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FrequentItemSetsBucket> {
        private Map<String, List<String>> key;
        private Double support;

        public final Builder key(Map<String, List<String>> map) {
            this.key = Builder._mapPutAll(this.key, map);
            return this;
        }

        public final Builder key(String key, List<String> value) {
            this.key = Builder._mapPut(this.key, key, value);
            return this;
        }

        public final Builder support(double value) {
            this.support = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FrequentItemSetsBucket build() {
            this._checkSingleUse();
            return new FrequentItemSetsBucket(this);
        }
    }
}

