/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.PreRemove;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.jdbc.entity.NavigationEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.mop.NodeTarget;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.services.listener.ListenerService;

@Entity(name="GateInNavigationNode")
@ExoEntity
@Table(name="PORTAL_NAVIGATION_NODES")
@NamedQueries(value={@NamedQuery(name="NodeEntity.findByPage", query="SELECT n FROM GateInNavigationNode n INNER JOIN n.page p WHERE p.id = :pageId")})
public class NodeEntity
implements Serializable {
    private static final long serialVersionUID = 8630708630711337929L;
    @Id
    @SequenceGenerator(name="SEQ_GTN_NAVIGATION_NODE_ID", sequenceName="SEQ_GTN_NAVIGATION_NODE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GTN_NAVIGATION_NODE_ID")
    @Column(name="NODE_ID")
    private Long id;
    @Column(name="NAME", length=200)
    private String name;
    @Column(name="LABEL", length=200)
    private String label;
    @Column(name="ICON", length=200)
    private String icon;
    @Column(name="START_TIME")
    private long startTime;
    @Column(name="END_TIME")
    private long endTime;
    @Column(name="VISIBILITY")
    private Visibility visibility = Visibility.DISPLAYED;
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="PAGE_ID", nullable=true)
    private PageEntity page;
    @Column(name="NODE_INDEX")
    private int index;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="parent")
    @OrderBy(value="index ASC")
    private List<NodeEntity> children = new ArrayList<NodeEntity>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_ID")
    private NodeEntity parent;
    @OneToOne(fetch=FetchType.EAGER, mappedBy="rootNode")
    private NavigationEntity navigationEntity;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TARGET")
    private NodeTarget target;
    @Column(name="UPDATED_DATE")
    private long updatedDate;
    public static final String REMOVED_EVENT = "org.exoplatform.portal.jdbc.entity.NodeEntity.removed";

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public PageEntity getPage() {
        return this.page;
    }

    public void setPage(PageEntity page) {
        this.page = page;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<NodeEntity> getChildren() {
        return this.children;
    }

    public void setChildren(List<NodeEntity> children) {
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                children.get(i).setIndex(i);
            }
        }
        this.children = children;
    }

    public NodeTarget getTarget() {
        return this.target;
    }

    public void setTarget(NodeTarget target) {
        this.target = target;
    }

    public NodeEntity getParent() {
        return this.parent;
    }

    public long getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(long updatedDate) {
        this.updatedDate = updatedDate;
    }

    public void setParent(NodeEntity parent) {
        this.parent = parent;
    }

    public NavigationEntity getNavigationEntity() {
        return this.navigationEntity;
    }

    public void setNavigationEntity(NavigationEntity navigationEntity) {
        this.navigationEntity = navigationEntity;
    }

    @PreRemove
    public void preRemove() throws Exception {
        ListenerService listenerService;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container != null && (listenerService = (ListenerService)container.getComponentInstanceOfType(ListenerService.class)) != null) {
            listenerService.broadcast(REMOVED_EVENT, (Object)this, (Object)this.getId());
        }
    }
}

