/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import java.util.List;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.AlterTableUniqueDelegate;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.UniqueKey;

public class AlterTableUniqueIndexDelegate
extends AlterTableUniqueDelegate {
    public AlterTableUniqueIndexDelegate(Dialect dialect) {
        super(dialect);
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        if (uniqueKey.hasNullableColumn()) {
            Dialect dialect = context.getDialect();
            String name = uniqueKey.getName();
            String tableName = context.format(uniqueKey.getTable().getQualifiedTableName());
            List<Column> columns = uniqueKey.getColumns();
            Map<Column, String> columnOrderMap = uniqueKey.getColumnOrderMap();
            StringBuilder statement = new StringBuilder(dialect.getCreateIndexString(true)).append(" ").append(dialect.qualifyIndexName() ? name : StringHelper.unqualify(name)).append(" on ").append(tableName).append(" (");
            boolean first = true;
            for (Column column : columns) {
                if (first) {
                    first = false;
                } else {
                    statement.append(", ");
                }
                statement.append(column.getQuotedName(dialect));
                if (!columnOrderMap.containsKey(column)) continue;
                statement.append(" ").append(columnOrderMap.get(column));
            }
            statement.append(")");
            statement.append(dialect.getCreateIndexTail(true, columns));
            return statement.toString();
        }
        return super.getAlterTableToAddUniqueKeyCommand(uniqueKey, metadata, context);
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        if (uniqueKey.hasNullableColumn()) {
            String tableName = context.format(uniqueKey.getTable().getQualifiedTableName());
            return "drop index " + StringHelper.qualify(tableName, uniqueKey.getName());
        }
        return super.getAlterTableToDropUniqueKeyCommand(uniqueKey, metadata, context);
    }
}

