/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.criteria.Predicate;
import java.util.List;
import java.util.Locale;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPath;
import org.hibernate.metamodel.model.domain.internal.EntityDiscriminatorSqmPath;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.NonAggregatedCompositeSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmCteRoot;
import org.hibernate.query.sqm.tree.domain.SqmDerivedRoot;
import org.hibernate.query.sqm.tree.domain.SqmElementAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmFkExpression;
import org.hibernate.query.sqm.tree.domain.SqmIndexAggregateFunction;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmPluralPartJoin;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmAnyDiscriminatorValue;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCoalesce;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmHqlNumericLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmModifiedSubQueryExpression;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmOver;
import org.hibernate.query.sqm.tree.expression.SqmOverflow;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.expression.SqmWindow;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmCteJoin;
import org.hibernate.query.sqm.tree.from.SqmDerivedJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmTruthnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmJpaCompoundSelection;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.jboss.logging.Logger;

public class SqmTreePrinter
implements SemanticQueryWalker<Object> {
    private static final Logger log = Logger.getLogger(SqmTreePrinter.class);
    private static final Logger LOGGER = QueryLogging.subLogger("sqm.ast");
    private static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private final StringBuffer buffer = new StringBuffer();
    private int depth = 2;
    private boolean inJoinPredicate;

    public static void logTree(SqmQuerySpec sqmQuerySpec, String header) {
        if (!DEBUG_ENABLED) {
            return;
        }
        SqmTreePrinter treePrinter = new SqmTreePrinter();
        treePrinter.visitQuerySpec(sqmQuerySpec);
        String title = header != null ? header : "SqmQuerySpec Tree";
        LOGGER.debugf("%s :%n%s", (Object)title, (Object)treePrinter.buffer.toString());
    }

    public static void logTree(SqmStatement sqmStatement) {
        if (!DEBUG_ENABLED) {
            return;
        }
        SqmTreePrinter printer = new SqmTreePrinter();
        if (sqmStatement instanceof SqmSelectStatement) {
            printer.visitSelectStatement((SqmSelectStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmDeleteStatement) {
            printer.visitDeleteStatement((SqmDeleteStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmUpdateStatement) {
            printer.visitUpdateStatement((SqmUpdateStatement)sqmStatement);
        } else if (sqmStatement instanceof SqmInsertSelectStatement) {
            printer.visitInsertSelectStatement((SqmInsertSelectStatement)sqmStatement);
        }
        LOGGER.debugf("SqmStatement Tree :%n%s", (Object)printer.buffer.toString());
    }

    private void processStanza(String name, Runnable continuation) {
        this.processStanza(name, false, continuation);
    }

    private void processStanza(String name, String description, Runnable continuation) {
        this.processStanza(name, description, false, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStanza(String name, boolean indentContinuation, Runnable continuation) {
        this.logWithIndentation("-> [%s]", (Object)name);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            continuation.run();
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Error processing stanza {%s}", (Object)name);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("<- [%s]", (Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStanza(String name, String description, boolean indentContinuation, Runnable continuation) {
        String stanzaLabel = description == null ? "[" + name + "]" : "[" + name + "] - " + description;
        this.logWithIndentation("-> " + stanzaLabel);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            continuation.run();
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Error processing stanza {%s}", (Object)name);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("<- " + stanzaLabel);
    }

    private void logWithIndentation(Object line) {
        this.pad(this.depth);
        this.buffer.append(line).append(System.lineSeparator());
    }

    private void pad(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.buffer.append("  ");
        }
    }

    private void logWithIndentation(String pattern, Object arg1) {
        this.logWithIndentation(String.format(pattern, arg1));
    }

    private void logWithIndentation(String pattern, Object arg1, Object arg2) {
        this.logWithIndentation(String.format(pattern, arg1, arg2));
    }

    private void logWithIndentation(String pattern, Object ... args) {
        this.logWithIndentation(String.format(pattern, args));
    }

    private void logIndented(String line) {
        ++this.depth;
        this.logWithIndentation(line);
        --this.depth;
    }

    private void logIndented(String pattern, Object arg) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, arg));
        --this.depth;
    }

    private void logIndented(String pattern, Object arg1, Object arg2) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, arg1, arg2));
        --this.depth;
    }

    private void logIndented(String pattern, Object ... args) {
        ++this.depth;
        this.logWithIndentation(String.format(Locale.ROOT, pattern, args));
        --this.depth;
    }

    @Override
    public Object visitDeleteStatement(SqmDeleteStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("delete", () -> {
                this.logWithIndentation("[target = %s]", (Object)((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath());
                this.visitWhereClause(statement.getWhereClause());
            });
        }
        return null;
    }

    @Override
    public Object visitInsertSelectStatement(SqmInsertSelectStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("insert", () -> {
                this.logWithIndentation("[target = %s]", (Object)((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath());
                this.processStanza("into", () -> statement.getInsertionTargetPaths().forEach(sqmPath -> sqmPath.accept(this)));
                statement.getSelectQueryPart().accept(this);
            });
        }
        return null;
    }

    @Override
    public Object visitInsertValuesStatement(SqmInsertValuesStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("insert", () -> {
                this.logWithIndentation("[target = %s]", (Object)((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath());
                this.processStanza("into", () -> statement.getInsertionTargetPaths().forEach(sqmPath -> sqmPath.accept(this)));
            });
        }
        return null;
    }

    @Override
    public Object visitSelectStatement(SqmSelectStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza("select", () -> statement.getQueryPart().accept(this));
        }
        return null;
    }

    @Override
    public Object visitCteStatement(SqmCteStatement sqmCteStatement) {
        if (DEBUG_ENABLED) {
            this.logIndented("cte");
        }
        return null;
    }

    @Override
    public Object visitCteContainer(SqmCteContainer consumer) {
        return null;
    }

    @Override
    public Object visitUpdateStatement(SqmUpdateStatement<?> statement) {
        if (DEBUG_ENABLED) {
            this.processStanza(statement.isVersioned() ? "update versioned" : "update", () -> {
                this.logWithIndentation("[target = %s]", (Object)((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath());
                this.visitSetClause(statement.getSetClause());
                this.visitWhereClause(statement.getWhereClause());
            });
        }
        return null;
    }

    @Override
    public Object visitSetClause(SqmSetClause setClause) {
        this.processStanza("set", () -> setClause.getAssignments().forEach(this::visitAssignment));
        return null;
    }

    @Override
    public Object visitAssignment(SqmAssignment<?> assignment) {
        this.processStanza("assignment", () -> {
            this.logWithIndentation("=");
            ++this.depth;
            this.logWithIndentation("[%s]", (Object)assignment.getTargetPath().getNavigablePath());
            assignment.getValue().accept(this);
            --this.depth;
        });
        return null;
    }

    @Override
    public Object visitQueryGroup(SqmQueryGroup<?> queryGroup) {
        this.processStanza("query-group", () -> {
            for (SqmQueryPart queryPart : queryGroup.getQueryParts()) {
                if (queryPart instanceof SqmQuerySpec) {
                    this.visitQuerySpec((SqmQuerySpec)queryPart);
                    continue;
                }
                this.visitQueryGroup((SqmQueryGroup)queryPart);
            }
        });
        return null;
    }

    @Override
    public Object visitQuerySpec(SqmQuerySpec<?> querySpec) {
        this.processStanza("query-spec", () -> {
            this.visitSelectClause(querySpec.getSelectClause());
            this.visitFromClause(querySpec.getFromClause());
            this.visitWhereClause(querySpec.getWhereClause());
            this.visitGroupByClause(querySpec.getGroupByClauseExpressions());
            this.visitHavingClause(querySpec.getHavingClausePredicate());
            this.visitOrderByClause(querySpec.getOrderByClause());
            this.visitOffsetExpression((SqmExpression)querySpec.getOffsetExpression());
            this.visitFetchExpression((SqmExpression)querySpec.getFetchExpression());
        });
        return null;
    }

    @Override
    public Object visitGroupByClause(List<SqmExpression<?>> groupByClauseExpressions) {
        if (groupByClauseExpressions != null && !groupByClauseExpressions.isEmpty()) {
            this.processStanza("group-by", () -> groupByClauseExpressions.forEach(e -> e.accept(this)));
        }
        return null;
    }

    @Override
    public Object visitHavingClause(SqmPredicate predicate) {
        if (predicate != null) {
            this.processStanza("having", () -> predicate.accept(this));
        }
        return null;
    }

    @Override
    public Object visitJpaCompoundSelection(SqmJpaCompoundSelection<?> selection) {
        this.processStanza("JpaCompoundSelection", () -> {
            for (SqmSelectableNode<?> selectionItem : selection.getSelectionItems()) {
                selectionItem.accept(this);
            }
        });
        return null;
    }

    @Override
    public Object visitFromClause(SqmFromClause fromClause) {
        this.processStanza("from", () -> fromClause.visitRoots(this::visitRootPath));
        return null;
    }

    @Override
    public Object visitRootPath(SqmRoot sqmRoot) {
        this.processStanza("root", "`" + sqmRoot.getNavigablePath() + "`", () -> this.processJoins(sqmRoot));
        return null;
    }

    @Override
    public Object visitRootDerived(SqmDerivedRoot<?> sqmRoot) {
        this.processStanza("derived", "`" + sqmRoot.getNavigablePath() + "`", () -> this.processJoins(sqmRoot));
        return null;
    }

    @Override
    public Object visitRootCte(SqmCteRoot<?> sqmRoot) {
        this.processStanza("cte", "`" + sqmRoot.getNavigablePath() + "`", () -> this.processJoins(sqmRoot));
        return null;
    }

    private void processJoins(SqmFrom<?, ?> sqmFrom) {
        if (!sqmFrom.hasJoins()) {
            return;
        }
        this.processStanza("joins", () -> sqmFrom.visitSqmJoins(sqmJoin -> sqmJoin.accept(this)));
    }

    @Override
    public Object visitCrossJoin(SqmCrossJoin joinedFromElement) {
        this.processStanza("cross", "`" + joinedFromElement.getNavigablePath() + "`", () -> this.processJoins(joinedFromElement));
        return null;
    }

    @Override
    public Object visitPluralPartJoin(SqmPluralPartJoin<?, ?> joinedFromElement) {
        this.processStanza("plural-part", "`" + joinedFromElement.getNavigablePath() + "`", () -> this.processJoins(joinedFromElement));
        return null;
    }

    private void processJoinPredicate(SqmQualifiedJoin<?, ?> joinedFromElement) {
        if (joinedFromElement.getJoinPredicate() != null) {
            boolean oldInJoinPredicate = this.inJoinPredicate;
            this.inJoinPredicate = true;
            this.processStanza("on", () -> joinedFromElement.getJoinPredicate().accept(this));
            this.inJoinPredicate = oldInJoinPredicate;
        }
    }

    @Override
    public Object visitQualifiedEntityJoin(SqmEntityJoin joinedFromElement) {
        if (this.inJoinPredicate) {
            this.logWithIndentation("-> [joined-path] - `%s`", (Object)joinedFromElement.getNavigablePath());
        } else {
            this.processStanza("entity", "`" + joinedFromElement.getNavigablePath() + "`", () -> {
                this.processJoinPredicate(joinedFromElement);
                this.processJoins(joinedFromElement);
            });
        }
        return null;
    }

    @Override
    public Object visitQualifiedAttributeJoin(SqmAttributeJoin joinedFromElement) {
        if (this.inJoinPredicate) {
            this.logWithIndentation("-> [joined-path] - `%s`", (Object)joinedFromElement.getNavigablePath());
        } else {
            this.processStanza("attribute", "`" + joinedFromElement.getNavigablePath() + "`", () -> {
                this.logIndented("[fetched = " + joinedFromElement.isFetched() + "]");
                this.processJoinPredicate(joinedFromElement);
                this.processJoins(joinedFromElement);
            });
        }
        return null;
    }

    @Override
    public Object visitQualifiedDerivedJoin(SqmDerivedJoin<?> joinedFromElement) {
        if (this.inJoinPredicate) {
            this.logWithIndentation("-> [joined-path] - `%s`", (Object)joinedFromElement.getNavigablePath());
        } else {
            this.processStanza("derived", "`" + joinedFromElement.getNavigablePath() + "`", () -> {
                this.processJoinPredicate(joinedFromElement);
                this.processJoins(joinedFromElement);
            });
        }
        return null;
    }

    @Override
    public Object visitQualifiedCteJoin(SqmCteJoin<?> joinedFromElement) {
        if (this.inJoinPredicate) {
            this.logWithIndentation("-> [joined-path] - `%s`", (Object)joinedFromElement.getNavigablePath());
        } else {
            this.processStanza("cte", "`" + joinedFromElement.getNavigablePath() + "`", () -> {
                this.processJoinPredicate(joinedFromElement);
                this.processJoins(joinedFromElement);
            });
        }
        return null;
    }

    @Override
    public Object visitBasicValuedPath(SqmBasicValuedSimplePath path) {
        this.logWithIndentation("-> [basic-path] - `%s`", (Object)path.getNavigablePath());
        return null;
    }

    @Override
    public Object visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath path) {
        this.logWithIndentation("-> [embedded-path] - `%s`", (Object)path.getNavigablePath());
        return null;
    }

    @Override
    public Object visitAnyValuedValuedPath(SqmAnyValuedSimplePath<?> path) {
        this.logWithIndentation("-> [any-path] - `%s`", (Object)path.getNavigablePath());
        return null;
    }

    @Override
    public Object visitNonAggregatedCompositeValuedPath(NonAggregatedCompositeSimplePath<?> path) {
        this.logWithIndentation("-> [non-aggregated-composite-path] - `%s`", (Object)path.getNavigablePath());
        return null;
    }

    @Override
    public Object visitFkExpression(SqmFkExpression<?> fkExpression) {
        this.logWithIndentation("-> [fk-ref] - `%s`", (Object)fkExpression.getToOnePath().getNavigablePath());
        return null;
    }

    @Override
    public Object visitDiscriminatorPath(EntityDiscriminatorSqmPath sqmPath) {
        this.logWithIndentation("-> [discriminator-path] - `%s`", (Object)sqmPath.getNavigablePath());
        return null;
    }

    @Override
    public Object visitEntityValuedPath(SqmEntityValuedSimplePath path) {
        this.logWithIndentation("-> [entity-path] - `%s`", (Object)path.getNavigablePath());
        return null;
    }

    @Override
    public Object visitPluralValuedPath(SqmPluralValuedSimplePath path) {
        this.logWithIndentation("-> [plural-path] - `%s`", (Object)path.getNavigablePath());
        return null;
    }

    @Override
    public Object visitIndexedPluralAccessPath(SqmIndexedCollectionAccessPath<?> path) {
        return null;
    }

    @Override
    public Object visitTreatedPath(SqmTreatedPath sqmTreatedPath) {
        return null;
    }

    @Override
    public Object visitCorrelation(SqmCorrelation<?, ?> correlation) {
        return null;
    }

    @Override
    public Object visitSelectClause(SqmSelectClause selectClause) {
        this.processStanza(selectClause.isDistinct() ? "select(distinct)" : "select", () -> selectClause.getSelections().forEach(this::visitSelection));
        return null;
    }

    @Override
    public Object visitSelection(SqmSelection selection) {
        this.processStanza((String)(selection.getAlias() == null ? "selection" : "selection(" + selection.getAlias() + ")"), () -> selection.getSelectableNode().accept(this));
        return null;
    }

    @Override
    public Object visitValues(SqmValues values) {
        return null;
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter expression) {
        this.logWithIndentation("?%s", (Object)expression.getPosition());
        return null;
    }

    @Override
    public Object visitNamedParameterExpression(SqmNamedParameter expression) {
        this.logWithIndentation(":%s", (Object)expression.getName());
        return null;
    }

    @Override
    public Object visitJpaCriteriaParameter(JpaCriteriaParameter expression) {
        return null;
    }

    @Override
    public Object visitEntityTypeLiteralExpression(SqmLiteralEntityType expression) {
        return null;
    }

    @Override
    public Object visitParameterizedEntityTypeExpression(SqmParameterizedEntityType expression) {
        return null;
    }

    @Override
    public Object visitUnaryOperationExpression(SqmUnaryOperation expression) {
        return null;
    }

    @Override
    public Object visitFunction(SqmFunction<?> tSqmFunction) {
        return null;
    }

    @Override
    public Object visitCoalesce(SqmCoalesce<?> sqmCoalesce) {
        return null;
    }

    @Override
    public Object visitToDuration(SqmToDuration<?> toDuration) {
        return null;
    }

    @Override
    public Object visitByUnit(SqmByUnit sqmByUnit) {
        return null;
    }

    @Override
    public Object visitExtractUnit(SqmExtractUnit<?> extractUnit) {
        return null;
    }

    @Override
    public Object visitFormat(SqmFormat sqmFormat) {
        return null;
    }

    @Override
    public Object visitCastTarget(SqmCastTarget<?> sqmCastTarget) {
        return null;
    }

    @Override
    public Object visitTrimSpecification(SqmTrimSpecification trimSpecification) {
        return null;
    }

    @Override
    public Object visitDistinct(SqmDistinct<?> distinct) {
        return null;
    }

    @Override
    public Object visitOverflow(SqmOverflow<?> sqmOverflow) {
        return null;
    }

    @Override
    public Object visitDurationUnit(SqmDurationUnit<?> durationUnit) {
        return null;
    }

    @Override
    public Object visitStar(SqmStar sqmStar) {
        return null;
    }

    @Override
    public Object visitOver(SqmOver<?> over) {
        return null;
    }

    @Override
    public Object visitWindow(SqmWindow window) {
        return null;
    }

    @Override
    public Object visitWhereClause(SqmWhereClause whereClause) {
        if (whereClause != null && whereClause.getPredicate() != null) {
            this.processStanza("where", () -> whereClause.getPredicate().accept(this));
        }
        return null;
    }

    @Override
    public Object visitGroupedPredicate(SqmGroupedPredicate predicate) {
        this.processStanza("grouped", () -> {
            ++this.depth;
            predicate.getSubPredicate().accept(this);
            --this.depth;
        });
        return null;
    }

    @Override
    public Object visitJunctionPredicate(SqmJunctionPredicate predicate) {
        this.processStanza(predicate.getOperator() == Predicate.BooleanOperator.AND ? "and" : "or", () -> {
            for (SqmPredicate subPredicate : predicate.getPredicates()) {
                subPredicate.accept(this);
            }
        });
        return null;
    }

    @Override
    public Object visitComparisonPredicate(SqmComparisonPredicate predicate) {
        this.processStanza(predicate.isNegated() ? predicate.getSqmOperator().negated().name() : predicate.getSqmOperator().name(), () -> {
            ++this.depth;
            try {
                predicate.getLeftHandExpression().accept(this);
                predicate.getRightHandExpression().accept(this);
            }
            finally {
                --this.depth;
            }
        });
        return null;
    }

    @Override
    public Object visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-empty" : "is-empty", () -> {
            ++this.depth;
            predicate.getPluralPath().accept(this);
            --this.depth;
        });
        return null;
    }

    @Override
    public Object visitIsNullPredicate(SqmNullnessPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-null" : "is-null", true, () -> predicate.getExpression().accept(this));
        return null;
    }

    @Override
    public Object visitIsTruePredicate(SqmTruthnessPredicate predicate) {
        this.processStanza((predicate.isNegated() ? "is-not-" : "is-") + predicate.getBooleanValue(), true, () -> predicate.getExpression().accept(this));
        return null;
    }

    @Override
    public Object visitBetweenPredicate(SqmBetweenPredicate predicate) {
        this.processStanza(predicate.isNegated() ? "is-not-between" : "is-between", () -> {
            predicate.getExpression().accept(this);
            predicate.getLowerBound().accept(this);
            predicate.getUpperBound().accept(this);
        });
        return null;
    }

    @Override
    public Object visitLikePredicate(SqmLikePredicate predicate) {
        String likeType = predicate.isCaseSensitive() ? "like" : "ilike";
        this.processStanza((predicate.isNegated() ? "is-not-" : "is-") + likeType, () -> {
            predicate.getPattern().accept(this);
            predicate.getMatchExpression().accept(this);
            if (predicate.getEscapeCharacter() != null) {
                predicate.getEscapeCharacter().accept(this);
            }
        });
        return null;
    }

    @Override
    public Object visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
        return null;
    }

    @Override
    public Object visitNegatedPredicate(SqmNegatedPredicate predicate) {
        return null;
    }

    @Override
    public Object visitInListPredicate(SqmInListPredicate predicate) {
        return null;
    }

    @Override
    public Object visitInSubQueryPredicate(SqmInSubQueryPredicate predicate) {
        return null;
    }

    @Override
    public Object visitBooleanExpressionPredicate(SqmBooleanExpressionPredicate predicate) {
        return null;
    }

    @Override
    public Object visitExistsPredicate(SqmExistsPredicate sqmExistsPredicate) {
        return null;
    }

    @Override
    public Object visitOrderByClause(SqmOrderByClause orderByClause) {
        return null;
    }

    @Override
    public Object visitSortSpecification(SqmSortSpecification sortSpecification) {
        return null;
    }

    @Override
    public Object visitOffsetExpression(SqmExpression expression) {
        return null;
    }

    @Override
    public Object visitFetchExpression(SqmExpression expression) {
        return null;
    }

    @Override
    public Object visitPluralAttributeSizeFunction(SqmCollectionSize function) {
        return null;
    }

    @Override
    public Object visitMapEntryFunction(SqmMapEntryReference<?, ?> function) {
        return null;
    }

    @Override
    public Object visitElementAggregateFunction(SqmElementAggregateFunction binding) {
        return null;
    }

    @Override
    public Object visitIndexAggregateFunction(SqmIndexAggregateFunction path) {
        return null;
    }

    @Override
    public Object visitLiteral(SqmLiteral literal) {
        return null;
    }

    @Override
    public Object visitTuple(SqmTuple sqmTuple) {
        return null;
    }

    @Override
    public Object visitCollation(SqmCollation sqmCollate) {
        return null;
    }

    @Override
    public Object visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
        return null;
    }

    @Override
    public Object visitSubQueryExpression(SqmSubQuery expression) {
        return null;
    }

    @Override
    public Object visitSimpleCaseExpression(SqmCaseSimple expression) {
        return null;
    }

    @Override
    public Object visitSearchedCaseExpression(SqmCaseSearched expression) {
        return null;
    }

    @Override
    public Object visitAny(SqmAny<?> sqmAny) {
        return null;
    }

    @Override
    public Object visitEvery(SqmEvery<?> sqmEvery) {
        return null;
    }

    @Override
    public Object visitSummarization(SqmSummarization<?> sqmSummarization) {
        return null;
    }

    @Override
    public Object visitAnyDiscriminatorTypeExpression(AnyDiscriminatorSqmPath<?> expression) {
        return null;
    }

    @Override
    public Object visitAnyDiscriminatorTypeValueExpression(SqmAnyDiscriminatorValue<?> expression) {
        return null;
    }

    @Override
    public Object visitDynamicInstantiation(SqmDynamicInstantiation sqmDynamicInstantiation) {
        this.processStanza("dynamic-instantiation (" + sqmDynamicInstantiation.getInstantiationTarget().getJavaType() + ")", () -> this.processStanza("arguments", () -> sqmDynamicInstantiation.getArguments().forEach(argument -> this.processStanza("argument (" + argument.getAlias() + ")", () -> {
            ++this.depth;
            argument.getSelectableNode().accept(this);
            --this.depth;
        }))));
        return null;
    }

    @Override
    public Object visitEnumLiteral(SqmEnumLiteral<?> sqmEnumLiteral) {
        return null;
    }

    @Override
    public Object visitFieldLiteral(SqmFieldLiteral<?> sqmFieldLiteral) {
        return null;
    }

    @Override
    public <N extends Number> Object visitHqlNumericLiteral(SqmHqlNumericLiteral<N> numericLiteral) {
        return null;
    }

    @Override
    public Object visitFullyQualifiedClass(Class namedClass) {
        return null;
    }

    @Override
    public Object visitModifiedSubQueryExpression(SqmModifiedSubQueryExpression expression) {
        return null;
    }
}

