/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;

public class ToolbarUtils {
    public static final String TURN_ON_QUICK_EDIT = "turnOnQuickEdit";

    public static boolean isEditPortletInCreatePageWizard() {
        UIPortal uiPortal = Util.getUIPortal();
        UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
        return uiMaskWS.getWindowWidth() > 0 && uiMaskWS.getWindowHeight() < 0;
    }

    public static void updatePortal(PortletRequestContext context) {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        PortalRequestContext portalRequestContext = (PortalRequestContext)context.getParentAppRequestContext();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApplication.getChildById("UIWorkingWorkspace");
        portalRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        portalRequestContext.ignoreAJAXUpdateOnPortlets(true);
    }

    public static boolean canEditCurrentPortal(String remoteUser) {
        if (remoteUser == null) {
            return false;
        }
        IdentityRegistry identityRegistry = (IdentityRegistry)Util.getUIPortalApplication().getApplicationComponent(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(remoteUser);
        if (identity == null) {
            return false;
        }
        UIPortal uiPortal = Util.getUIPortal();
        String editPermission = uiPortal.getEditPermission();
        MembershipEntry membershipEntry = MembershipEntry.parse((String)editPermission);
        return identity.isMemberOf(membershipEntry);
    }

    public static boolean turnOnQuickEditable(PortletRequestContext context, boolean showAblePref) {
        Object obj = Util.getPortalRequestContext().getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        boolean turnOnFlag = false;
        if (obj != null) {
            turnOnFlag = Boolean.parseBoolean(obj.toString());
        }
        return showAblePref && turnOnFlag;
    }

    public static boolean isLiveMode() {
        Object obj = Util.getPortalRequestContext().getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        if (obj == null) {
            return true;
        }
        return !Boolean.parseBoolean(obj.toString());
    }
}

