/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedSubgraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Type;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.SubGraph;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.JpaMetaModelPopulationSetting;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.EntityTypeException;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.DynamicModelJavaType;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class JpaMetamodelImpl
implements JpaMetamodelImplementor,
Serializable {
    private static final EntityManagerMessageLogger log = HEMLogging.messageLogger(JpaMetamodel.class);
    private final TypeConfiguration typeConfiguration;
    private final MappingMetamodel mappingMetamodel;
    private final ServiceRegistry serviceRegistry;
    private final Map<String, EntityDomainType<?>> jpaEntityTypeMap = new TreeMap();
    private final Map<Class<?>, ManagedDomainType<?>> jpaManagedTypeMap = new HashMap();
    private final Set<ManagedDomainType<?>> jpaManagedTypes = new HashSet();
    private final Set<EmbeddableDomainType<?>> jpaEmbeddables = new HashSet();
    private final Map<String, Map<Class<?>, Enum<?>>> allowedEnumLiteralTexts = new HashMap();
    private final transient Map<String, RootGraphImplementor<?>> entityGraphMap = new ConcurrentHashMap();
    private final Map<Class<?>, SqmPolymorphicRootDescriptor<?>> polymorphicEntityReferenceMap = new ConcurrentHashMap();
    private final Map<Class<?>, String> entityProxyInterfaceMap = new HashMap();
    private final Map<String, ImportInfo<?>> nameToImportMap = new ConcurrentHashMap();
    private final Map<String, Object> knownInvalidnameToImportMap = new ConcurrentHashMap<String, Object>();

    public JpaMetamodelImpl(TypeConfiguration typeConfiguration, MappingMetamodel mappingMetamodel, ServiceRegistry serviceRegistry) {
        this.typeConfiguration = typeConfiguration;
        this.mappingMetamodel = mappingMetamodel;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public JpaCompliance getJpaCompliance() {
        return this.typeConfiguration.getJpaCompliance();
    }

    @Override
    public <X> EntityDomainType<X> entity(String entityName) {
        return entityName == null ? null : this.jpaEntityTypeMap.get(entityName);
    }

    @Override
    public <X> EntityDomainType<X> getHqlEntityReference(String entityName) {
        EntityDomainType<X> entityDescriptor;
        Class<Object> loadedClass = null;
        ImportInfo importInfo = this.resolveImport(entityName);
        if (importInfo != null) {
            loadedClass = importInfo.loadedClass;
            entityName = importInfo.importedName;
        }
        if ((entityDescriptor = this.entity(entityName)) != null) {
            return entityDescriptor;
        }
        if (loadedClass == null) {
            loadedClass = this.resolveRequestedClass(entityName);
            if (importInfo != null && loadedClass != null) {
                importInfo.loadedClass = loadedClass;
            }
        }
        if (loadedClass != null) {
            return this.resolveEntityReference(loadedClass);
        }
        return null;
    }

    @Override
    public <X> EntityDomainType<X> resolveHqlEntityReference(String entityName) {
        EntityDomainType<X> hqlEntityReference = this.getHqlEntityReference(entityName);
        if (hqlEntityReference == null) {
            throw new EntityTypeException("Could not resolve entity name '" + entityName + "'", entityName);
        }
        return hqlEntityReference;
    }

    @Override
    public <X> ManagedDomainType<X> findManagedType(Class<X> cls) {
        return this.jpaManagedTypeMap.get(cls);
    }

    @Override
    public <X> EntityDomainType<X> findEntityType(Class<X> cls) {
        ManagedType type = this.jpaManagedTypeMap.get(cls);
        if (!(type instanceof EntityType)) {
            return null;
        }
        return (EntityDomainType)type;
    }

    @Override
    public <X> ManagedDomainType<X> managedType(Class<X> cls) {
        ManagedType type = this.jpaManagedTypeMap.get(cls);
        if (type == null) {
            throw new IllegalArgumentException("Not a managed type: " + cls);
        }
        return (ManagedDomainType)type;
    }

    @Override
    public <X> EntityDomainType<X> entity(Class<X> cls) {
        ManagedType type = this.jpaManagedTypeMap.get(cls);
        if (!(type instanceof EntityDomainType)) {
            throw new IllegalArgumentException("Not an entity: " + cls.getName());
        }
        return (EntityDomainType)type;
    }

    @Override
    public <X> EmbeddableDomainType<X> embeddable(Class<X> cls) {
        ManagedType type = this.jpaManagedTypeMap.get(cls);
        if (!(type instanceof EmbeddableDomainType)) {
            throw new IllegalArgumentException("Not an embeddable: " + cls.getName());
        }
        return (EmbeddableDomainType)type;
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        return new HashSet(this.jpaManagedTypes);
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        HashSet entityTypes = new HashSet(this.jpaEntityTypeMap.size());
        for (ManagedDomainType<?> value : this.jpaManagedTypes) {
            if (!(value instanceof EntityType)) continue;
            entityTypes.add((EntityType)value);
        }
        return entityTypes;
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        return new HashSet(this.jpaEmbeddables);
    }

    @Override
    public Map<String, Map<Class<?>, Enum<?>>> getAllowedEnumLiteralTexts() {
        return this.allowedEnumLiteralTexts;
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, RootGraphImplementor<T> entityGraph) {
        EntityGraph old = this.entityGraphMap.put(graphName, entityGraph.makeImmutableCopy(graphName));
        if (old != null) {
            log.debugf("EntityGraph being replaced on EntityManagerFactory for name %s", graphName);
        }
    }

    @Override
    public <T> RootGraphImplementor<T> findEntityGraphByName(String name) {
        return this.entityGraphMap.get(name);
    }

    @Override
    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        EntityType entityType = this.entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Given class is not an entity: " + entityClass.getName());
        }
        ArrayList<RootGraphImplementor<T>> results = new ArrayList<RootGraphImplementor<T>>();
        for (RootGraphImplementor<?> entityGraph : this.entityGraphMap.values()) {
            if (!entityGraph.appliesTo((EntityDomainType<?>)entityType)) continue;
            RootGraphImplementor<?> result = entityGraph;
            results.add(result);
        }
        return results;
    }

    @Override
    public String qualifyImportableName(String queryName) {
        ImportInfo importInfo = this.resolveImport(queryName);
        return importInfo == null ? null : importInfo.importedName;
    }

    private <T> ImportInfo<T> resolveImport(String name) {
        ImportInfo<?> importInfo = this.nameToImportMap.get(name);
        if (importInfo != null) {
            return importInfo;
        }
        if (this.knownInvalidnameToImportMap.containsKey(name)) {
            return null;
        }
        Class loadedClass = this.resolveRequestedClass(name);
        if (loadedClass == null) {
            if (this.knownInvalidnameToImportMap.size() < 1000) {
                this.knownInvalidnameToImportMap.put(name, name);
            }
            return null;
        }
        ImportInfo info = new ImportInfo(name, loadedClass);
        this.nameToImportMap.put(name, info);
        return info;
    }

    private void applyNamedEntityGraphs(Collection<NamedEntityGraphDefinition> namedEntityGraphs) {
        for (NamedEntityGraphDefinition definition : namedEntityGraphs) {
            log.debugf("Applying named entity graph [name=%s, entity-name=%s, jpa-entity-name=%s]", definition.getRegisteredName(), definition.getEntityName(), definition.getJpaEntityName());
            EntityDomainType entityType = this.entity(definition.getEntityName());
            if (entityType == null) {
                throw new IllegalArgumentException("Attempted to register named entity graph [" + definition.getRegisteredName() + "] for unknown entity [" + definition.getEntityName() + "]");
            }
            RootGraphImpl entityGraph = new RootGraphImpl(definition.getRegisteredName(), entityType);
            NamedEntityGraph namedEntityGraph = definition.getAnnotation();
            if (namedEntityGraph.includeAllAttributes()) {
                for (Attribute attribute : entityType.getAttributes()) {
                    entityGraph.addAttributeNodes(attribute);
                }
            }
            if (namedEntityGraph.attributeNodes() != null) {
                this.applyNamedAttributeNodes(namedEntityGraph.attributeNodes(), namedEntityGraph, entityGraph);
            }
            this.entityGraphMap.put(definition.getRegisteredName(), entityGraph);
        }
    }

    private void applyNamedAttributeNodes(NamedAttributeNode[] namedAttributeNodes, NamedEntityGraph namedEntityGraph, GraphImplementor<?> graphNode) {
        for (NamedAttributeNode namedAttributeNode : namedAttributeNodes) {
            SubGraph subgraph;
            String value = namedAttributeNode.value();
            AttributeNode attributeNode = graphNode.addAttributeNode(value);
            if (StringHelper.isNotEmpty(namedAttributeNode.subgraph())) {
                subgraph = attributeNode.makeSubGraph();
                this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.subgraph(), (SubGraphImplementor<?>)subgraph);
            }
            if (!StringHelper.isNotEmpty(namedAttributeNode.keySubgraph())) continue;
            subgraph = attributeNode.makeKeySubGraph();
            this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.keySubgraph(), (SubGraphImplementor<?>)subgraph);
        }
    }

    private void applyNamedSubgraphs(NamedEntityGraph namedEntityGraph, String subgraphName, SubGraphImplementor<?> subgraph) {
        for (NamedSubgraph namedSubgraph : namedEntityGraph.subgraphs()) {
            if (!subgraphName.equals(namedSubgraph.name())) continue;
            this.applyNamedAttributeNodes(namedSubgraph.attributeNodes(), namedEntityGraph, subgraph);
        }
    }

    private <X> Class<X> resolveRequestedClass(String entityName) {
        try {
            return this.getServiceRegistry().getService(ClassLoaderService.class).classForName(entityName);
        }
        catch (ClassLoadingException e) {
            return null;
        }
    }

    public <T> EntityDomainType<T> resolveEntityReference(Class<T> javaType) {
        EntityDomainType<?> descriptor = this.jpaEntityTypeMap.get(javaType.getName());
        if (descriptor != null) {
            return descriptor;
        }
        String proxyEntityName = this.entityProxyInterfaceMap.get(javaType);
        if (proxyEntityName != null) {
            return this.jpaEntityTypeMap.get(proxyEntityName);
        }
        EntityDomainType polymorphicDomainType = this.polymorphicEntityReferenceMap.get(javaType);
        if (polymorphicDomainType != null) {
            return polymorphicDomainType;
        }
        HashSet matchingDescriptors = new HashSet();
        for (EntityDomainType<?> entityDomainType : this.jpaEntityTypeMap.values()) {
            EntityPersister entityPersister;
            EntityPersister superMapping;
            ManagedDomainType superType;
            if (!javaType.isAssignableFrom(entityDomainType.getJavaType()) || (superType = entityDomainType.getSuperType()) != null && superType.getPersistenceType() == Type.PersistenceType.ENTITY && javaType.isAssignableFrom(superType.getJavaType()) && !(superMapping = this.getMappingMetamodel().getEntityDescriptor(((EntityDomainType)superType).getHibernateEntityName())).isExplicitPolymorphism() || (entityPersister = this.getMappingMetamodel().getEntityDescriptor(entityDomainType.getHibernateEntityName())).isExplicitPolymorphism()) continue;
            matchingDescriptors.add(entityDomainType);
        }
        if (!matchingDescriptors.isEmpty()) {
            SqmPolymorphicRootDescriptor descriptor2 = new SqmPolymorphicRootDescriptor(this.typeConfiguration.getJavaTypeRegistry().resolveDescriptor(javaType), matchingDescriptors);
            this.polymorphicEntityReferenceMap.putIfAbsent(javaType, descriptor2);
            return descriptor2;
        }
        throw new EntityTypeException("Could not resolve entity class '" + javaType.getName() + "'", javaType.getName());
    }

    @Override
    public MappingMetamodel getMappingMetamodel() {
        return this.mappingMetamodel;
    }

    public void processJpa(MetadataImplementor bootMetamodel, MappingMetamodel mappingMetamodel, Map<Class<?>, String> entityProxyInterfaceMap, JpaStaticMetaModelPopulationSetting jpaStaticMetaModelPopulationSetting, JpaMetaModelPopulationSetting jpaMetaModelPopulationSetting, Collection<NamedEntityGraphDefinition> namedEntityGraphDefinitions, RuntimeModelCreationContext runtimeModelCreationContext) {
        bootMetamodel.getImports().forEach((k, v) -> this.nameToImportMap.put((String)k, new ImportInfo((String)v, null)));
        this.entityProxyInterfaceMap.putAll(entityProxyInterfaceMap);
        MetadataContext context = new MetadataContext(this, mappingMetamodel, bootMetamodel, jpaStaticMetaModelPopulationSetting, jpaMetaModelPopulationSetting, runtimeModelCreationContext);
        for (PersistentClass persistentClass : bootMetamodel.getEntityBindings()) {
            this.locateOrBuildEntityType(persistentClass, context, this.typeConfiguration);
        }
        this.handleUnusedMappedSuperclasses(context, this.typeConfiguration);
        context.wrapUp();
        for (Map.Entry entry : context.getIdentifiableTypesByName().entrySet()) {
            if (!(entry.getValue() instanceof EntityDomainType)) continue;
            this.jpaEntityTypeMap.put((String)entry.getKey(), (EntityDomainType)entry.getValue());
        }
        this.jpaManagedTypeMap.putAll(context.getEntityTypeMap());
        this.jpaManagedTypeMap.putAll(context.getMappedSuperclassTypeMap());
        switch (jpaMetaModelPopulationSetting) {
            case IGNORE_UNSUPPORTED: {
                this.jpaManagedTypes.addAll(context.getEntityTypeMap().values());
                this.jpaManagedTypes.addAll(context.getMappedSuperclassTypeMap().values());
                break;
            }
            case ENABLED: {
                this.jpaManagedTypes.addAll(context.getIdentifiableTypesByName().values());
            }
        }
        for (EmbeddableDomainType embeddableDomainType : context.getEmbeddableTypeSet()) {
            if (embeddableDomainType.getExpressibleJavaType() instanceof EntityJavaType) continue;
            switch (jpaMetaModelPopulationSetting) {
                case IGNORE_UNSUPPORTED: {
                    if (embeddableDomainType.getJavaType() == null || embeddableDomainType.getJavaType() == Map.class) break;
                    this.jpaEmbeddables.add(embeddableDomainType);
                    this.jpaManagedTypes.add(embeddableDomainType);
                    if (embeddableDomainType.getExpressibleJavaType() instanceof EntityJavaType) break;
                    this.jpaManagedTypeMap.put(embeddableDomainType.getJavaType(), embeddableDomainType);
                    break;
                }
                case ENABLED: {
                    this.jpaEmbeddables.add(embeddableDomainType);
                    this.jpaManagedTypes.add(embeddableDomainType);
                    if (embeddableDomainType.getJavaType() == null || embeddableDomainType.getExpressibleJavaType() instanceof EntityJavaType) break;
                    this.jpaManagedTypeMap.put(embeddableDomainType.getJavaType(), embeddableDomainType);
                    break;
                }
                case DISABLED: {
                    if (embeddableDomainType.getJavaType() == null) {
                        throw new UnsupportedOperationException("ANY not supported");
                    }
                    if (embeddableDomainType.getExpressibleJavaType() instanceof EntityJavaType) break;
                    this.jpaManagedTypeMap.put(embeddableDomainType.getJavaType(), embeddableDomainType);
                }
            }
        }
        this.typeConfiguration.getJavaTypeRegistry().forEachDescriptor(descriptor -> {
            if (descriptor instanceof EnumJavaType) {
                Enum[] enumConstants;
                EnumJavaType enumJavaType = (EnumJavaType)descriptor;
                Class enumJavaClass = enumJavaType.getJavaTypeClass();
                for (Enum enumConstant : enumConstants = (Enum[])enumJavaClass.getEnumConstants()) {
                    this.allowedEnumLiteralTexts.computeIfAbsent(enumConstant.name(), s -> new HashMap()).put(enumJavaClass, enumConstant);
                    String simpleQualifiedName = enumJavaClass.getSimpleName() + "." + enumConstant.name();
                    this.allowedEnumLiteralTexts.computeIfAbsent(simpleQualifiedName, s -> new HashMap()).put(enumJavaClass, enumConstant);
                }
            }
        });
        this.applyNamedEntityGraphs(namedEntityGraphDefinitions);
    }

    private EntityDomainType<?> locateOrBuildEntityType(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        EntityDomainType<?> entityType = context.locateEntityType(persistentClass);
        if (entityType == null) {
            entityType = this.buildEntityType(persistentClass, context, typeConfiguration);
        }
        return entityType;
    }

    private EntityTypeImpl<?> buildEntityType(PersistentClass persistentClass, MetadataContext context, TypeConfiguration typeConfiguration) {
        Class<?> javaTypeClass;
        MappedSuperclassDomainType<?> superType;
        context.pushEntityWorkedOn(persistentClass);
        MappedSuperclass superMappedSuperclass = persistentClass.getSuperMappedSuperclass();
        MappedSuperclassDomainType<?> mappedSuperclassDomainType = superType = superMappedSuperclass == null ? null : this.locateOrBuildMappedSuperclassType(superMappedSuperclass, context, typeConfiguration);
        if (superType == null) {
            PersistentClass superPersistentClass = persistentClass.getSuperclass();
            superType = superPersistentClass == null ? null : this.locateOrBuildEntityType(superPersistentClass, context, typeConfiguration);
        }
        JavaType<Map<?, ?>> javaType = (javaTypeClass = persistentClass.getMappedClass()) == null || Map.class.isAssignableFrom(javaTypeClass) ? new DynamicModelJavaType() : context.getTypeConfiguration().getJavaTypeRegistry().resolveEntityTypeDescriptor(javaTypeClass);
        EntityTypeImpl entityType = new EntityTypeImpl(javaType, superType, persistentClass, (JpaMetamodelImplementor)this);
        context.registerEntityType(persistentClass, entityType);
        context.popEntityWorkedOn(persistentClass);
        return entityType;
    }

    private void handleUnusedMappedSuperclasses(MetadataContext context, TypeConfiguration typeConfiguration) {
        Set<MappedSuperclass> unusedMappedSuperclasses = context.getUnusedMappedSuperclasses();
        if (!unusedMappedSuperclasses.isEmpty()) {
            for (MappedSuperclass mappedSuperclass : unusedMappedSuperclasses) {
                log.unusedMappedSuperclass(mappedSuperclass.getMappedClass().getName());
                this.locateOrBuildMappedSuperclassType(mappedSuperclass, context, typeConfiguration);
            }
        }
    }

    private MappedSuperclassDomainType<?> locateOrBuildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<?> mappedSuperclassType = context.locateMappedSuperclassType(mappedSuperclass);
        if (mappedSuperclassType == null) {
            mappedSuperclassType = this.buildMappedSuperclassType(mappedSuperclass, context, typeConfiguration);
        }
        return mappedSuperclassType;
    }

    private MappedSuperclassTypeImpl<?> buildMappedSuperclassType(MappedSuperclass mappedSuperclass, MetadataContext context, TypeConfiguration typeConfiguration) {
        MappedSuperclassDomainType<?> superType;
        MappedSuperclass superMappedSuperclass = mappedSuperclass.getSuperMappedSuperclass();
        MappedSuperclassDomainType<?> mappedSuperclassDomainType = superType = superMappedSuperclass == null ? null : this.locateOrBuildMappedSuperclassType(superMappedSuperclass, context, typeConfiguration);
        if (superType == null) {
            PersistentClass superPersistentClass = mappedSuperclass.getSuperPersistentClass();
            superType = superPersistentClass == null ? null : this.locateOrBuildEntityType(superPersistentClass, context, typeConfiguration);
        }
        JavaType javaType = context.getTypeConfiguration().getJavaTypeRegistry().resolveManagedTypeDescriptor(mappedSuperclass.getMappedClass());
        MappedSuperclassTypeImpl mappedSuperclassType = new MappedSuperclassTypeImpl(javaType, mappedSuperclass, superType, (JpaMetamodelImplementor)this);
        context.registerMappedSuperclassType(mappedSuperclass, mappedSuperclassType);
        return mappedSuperclassType;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.typeConfiguration.getSessionFactory());
    }

    private static class SerialForm
    implements Serializable {
        private final SessionFactoryImplementor sessionFactory;

        public SerialForm(SessionFactoryImplementor sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        private Object readResolve() {
            return this.sessionFactory.getJpaMetamodel();
        }
    }

    private static class ImportInfo<T> {
        final String importedName;
        Class<T> loadedClass;

        ImportInfo(String importedName, Class<T> loadedClass) {
            this.importedName = importedName;
            this.loadedClass = loadedClass;
        }
    }
}

