/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.service.internal.SessionFactoryServiceRegistryBuilderImpl;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceContributor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;

public class SessionFactoryServiceRegistryFactoryImpl
implements SessionFactoryServiceRegistryFactory {
    private final @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor theBasicServiceRegistry;

    public SessionFactoryServiceRegistryFactoryImpl(@UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor theBasicServiceRegistry) {
        this.theBasicServiceRegistry = theBasicServiceRegistry;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionFactoryServiceRegistry buildServiceRegistry(@UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory, @UnknownKeyFor @NonNull @Initialized SessionFactoryOptions options) {
        ClassLoaderService cls = NullnessUtil.castNonNull(options.getServiceRegistry().getService(ClassLoaderService.class));
        SessionFactoryServiceRegistryBuilderImpl builder = new SessionFactoryServiceRegistryBuilderImpl(this.theBasicServiceRegistry);
        for (SessionFactoryServiceContributor contributor : cls.loadJavaServices(SessionFactoryServiceContributor.class)) {
            contributor.contribute(builder);
        }
        return builder.buildSessionFactoryServiceRegistry(sessionFactory, options);
    }
}

