/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;

public abstract class SpaceWebNotificationPlugin
extends BaseComponentPlugin {
    private IdentityManager identityManager;
    private List<String> notificationPluginIds;

    protected SpaceWebNotificationPlugin(IdentityManager identityManager, InitParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Params are mandatory");
        }
        this.identityManager = identityManager;
        this.notificationPluginIds = params.getValuesParam("notification.plugin.ids").getValues();
    }

    public boolean isManagedPlugin(PluginKey pluginKey) {
        return this.notificationPluginIds.stream().anyMatch(pluginId -> StringUtils.equals((CharSequence)pluginKey.getId(), (CharSequence)pluginId));
    }

    public SpaceWebNotificationItem getSpaceApplicationItem(NotificationInfo notification, String username) {
        SpaceWebNotificationItem notificationItem = this.getSpaceApplicationItem(notification);
        if (notificationItem != null && notificationItem.getUserId() == 0L) {
            long userIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId());
            notificationItem.setUserId(userIdentityId);
        }
        return notificationItem;
    }

    protected abstract SpaceWebNotificationItem getSpaceApplicationItem(NotificationInfo var1);

    public List<String> getNotificationPluginIds() {
        return this.notificationPluginIds;
    }
}

