/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wom.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.meeds.wom.api.model.DataPayload;
import java.time.Instant;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.hateoas.server.core.Relation;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Relation(collectionRelation="reports", itemRelation="report")
public class HubReportPayload
implements DataPayload,
Cloneable {
    private long reportId;
    private String hubAddress;
    private long deedId;
    private Instant fromDate;
    private Instant toDate;
    private Instant sentDate;
    private String periodType;
    private long usersCount;
    private long participantsCount;
    private long recipientsCount;
    private long achievementsCount;
    private long actionsCount;
    private String rewardTokenAddress;
    private long rewardTokenNetworkId;
    private double hubRewardAmount;
    private double hubTopRewardedAmount;
    private SortedSet<String> transactions;

    public void setHubAddress(String hubAddress) {
        this.hubAddress = StringUtils.lowerCase((String)hubAddress);
    }

    public void setRewardTokenAddress(String rewardTokenAddress) {
        this.rewardTokenAddress = StringUtils.lowerCase((String)rewardTokenAddress);
    }

    public void setTransactions(SortedSet<String> transactions) {
        this.transactions = HubReportPayload.lowerCase(transactions);
    }

    @Override
    public final String generateRawMessage() {
        if (Objects.equals(this.getClass(), HubReportPayload.class)) {
            return DataPayload.super.generateRawMessage();
        }
        return this.clone().generateRawMessage();
    }

    protected static SortedSet<String> lowerCase(SortedSet<String> transactions) {
        return CollectionUtils.isEmpty(transactions) ? transactions : (SortedSet)transactions.stream().map(StringUtils::lowerCase).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(TreeSet::new));
    }

    protected HubReportPayload clone() {
        return new HubReportPayload(this.reportId, this.hubAddress, this.deedId, this.fromDate, this.toDate, this.sentDate, this.periodType, this.usersCount, this.participantsCount, this.recipientsCount, this.achievementsCount, this.actionsCount, this.rewardTokenAddress, this.rewardTokenNetworkId, this.hubRewardAmount, this.hubTopRewardedAmount, this.transactions);
    }

    public String toString() {
        return "HubReportPayload(reportId=" + this.getReportId() + ", hubAddress=" + this.getHubAddress() + ", deedId=" + this.getDeedId() + ", fromDate=" + String.valueOf(this.getFromDate()) + ", toDate=" + String.valueOf(this.getToDate()) + ", sentDate=" + String.valueOf(this.getSentDate()) + ", periodType=" + this.getPeriodType() + ", usersCount=" + this.getUsersCount() + ", participantsCount=" + this.getParticipantsCount() + ", recipientsCount=" + this.getRecipientsCount() + ", achievementsCount=" + this.getAchievementsCount() + ", actionsCount=" + this.getActionsCount() + ", rewardTokenAddress=" + this.getRewardTokenAddress() + ", rewardTokenNetworkId=" + this.getRewardTokenNetworkId() + ", hubRewardAmount=" + this.getHubRewardAmount() + ", hubTopRewardedAmount=" + this.getHubTopRewardedAmount() + ", transactions=" + String.valueOf(this.getTransactions()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HubReportPayload)) {
            return false;
        }
        HubReportPayload other = (HubReportPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReportId() != other.getReportId()) {
            return false;
        }
        if (this.getDeedId() != other.getDeedId()) {
            return false;
        }
        if (this.getUsersCount() != other.getUsersCount()) {
            return false;
        }
        if (this.getParticipantsCount() != other.getParticipantsCount()) {
            return false;
        }
        if (this.getRecipientsCount() != other.getRecipientsCount()) {
            return false;
        }
        if (this.getAchievementsCount() != other.getAchievementsCount()) {
            return false;
        }
        if (this.getActionsCount() != other.getActionsCount()) {
            return false;
        }
        if (this.getRewardTokenNetworkId() != other.getRewardTokenNetworkId()) {
            return false;
        }
        if (Double.compare(this.getHubRewardAmount(), other.getHubRewardAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getHubTopRewardedAmount(), other.getHubTopRewardedAmount()) != 0) {
            return false;
        }
        String this$hubAddress = this.getHubAddress();
        String other$hubAddress = other.getHubAddress();
        if (this$hubAddress == null ? other$hubAddress != null : !this$hubAddress.equals(other$hubAddress)) {
            return false;
        }
        Instant this$fromDate = this.getFromDate();
        Instant other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        Instant this$toDate = this.getToDate();
        Instant other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        Instant this$sentDate = this.getSentDate();
        Instant other$sentDate = other.getSentDate();
        if (this$sentDate == null ? other$sentDate != null : !((Object)this$sentDate).equals(other$sentDate)) {
            return false;
        }
        String this$periodType = this.getPeriodType();
        String other$periodType = other.getPeriodType();
        if (this$periodType == null ? other$periodType != null : !this$periodType.equals(other$periodType)) {
            return false;
        }
        String this$rewardTokenAddress = this.getRewardTokenAddress();
        String other$rewardTokenAddress = other.getRewardTokenAddress();
        if (this$rewardTokenAddress == null ? other$rewardTokenAddress != null : !this$rewardTokenAddress.equals(other$rewardTokenAddress)) {
            return false;
        }
        SortedSet<String> this$transactions = this.getTransactions();
        SortedSet<String> other$transactions = other.getTransactions();
        return !(this$transactions == null ? other$transactions != null : !this$transactions.equals(other$transactions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HubReportPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $reportId = this.getReportId();
        result = result * 59 + (int)($reportId >>> 32 ^ $reportId);
        long $deedId = this.getDeedId();
        result = result * 59 + (int)($deedId >>> 32 ^ $deedId);
        long $usersCount = this.getUsersCount();
        result = result * 59 + (int)($usersCount >>> 32 ^ $usersCount);
        long $participantsCount = this.getParticipantsCount();
        result = result * 59 + (int)($participantsCount >>> 32 ^ $participantsCount);
        long $recipientsCount = this.getRecipientsCount();
        result = result * 59 + (int)($recipientsCount >>> 32 ^ $recipientsCount);
        long $achievementsCount = this.getAchievementsCount();
        result = result * 59 + (int)($achievementsCount >>> 32 ^ $achievementsCount);
        long $actionsCount = this.getActionsCount();
        result = result * 59 + (int)($actionsCount >>> 32 ^ $actionsCount);
        long $rewardTokenNetworkId = this.getRewardTokenNetworkId();
        result = result * 59 + (int)($rewardTokenNetworkId >>> 32 ^ $rewardTokenNetworkId);
        long $hubRewardAmount = Double.doubleToLongBits(this.getHubRewardAmount());
        result = result * 59 + (int)($hubRewardAmount >>> 32 ^ $hubRewardAmount);
        long $hubTopRewardedAmount = Double.doubleToLongBits(this.getHubTopRewardedAmount());
        result = result * 59 + (int)($hubTopRewardedAmount >>> 32 ^ $hubTopRewardedAmount);
        String $hubAddress = this.getHubAddress();
        result = result * 59 + ($hubAddress == null ? 43 : $hubAddress.hashCode());
        Instant $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        Instant $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        Instant $sentDate = this.getSentDate();
        result = result * 59 + ($sentDate == null ? 43 : ((Object)$sentDate).hashCode());
        String $periodType = this.getPeriodType();
        result = result * 59 + ($periodType == null ? 43 : $periodType.hashCode());
        String $rewardTokenAddress = this.getRewardTokenAddress();
        result = result * 59 + ($rewardTokenAddress == null ? 43 : $rewardTokenAddress.hashCode());
        SortedSet<String> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : $transactions.hashCode());
        return result;
    }

    public HubReportPayload() {
    }

    public HubReportPayload(long reportId, String hubAddress, long deedId, Instant fromDate, Instant toDate, Instant sentDate, String periodType, long usersCount, long participantsCount, long recipientsCount, long achievementsCount, long actionsCount, String rewardTokenAddress, long rewardTokenNetworkId, double hubRewardAmount, double hubTopRewardedAmount, SortedSet<String> transactions) {
        this.reportId = reportId;
        this.hubAddress = hubAddress;
        this.deedId = deedId;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.sentDate = sentDate;
        this.periodType = periodType;
        this.usersCount = usersCount;
        this.participantsCount = participantsCount;
        this.recipientsCount = recipientsCount;
        this.achievementsCount = achievementsCount;
        this.actionsCount = actionsCount;
        this.rewardTokenAddress = rewardTokenAddress;
        this.rewardTokenNetworkId = rewardTokenNetworkId;
        this.hubRewardAmount = hubRewardAmount;
        this.hubTopRewardedAmount = hubTopRewardedAmount;
        this.transactions = transactions;
    }

    public long getReportId() {
        return this.reportId;
    }

    public void setReportId(long reportId) {
        this.reportId = reportId;
    }

    public String getHubAddress() {
        return this.hubAddress;
    }

    public long getDeedId() {
        return this.deedId;
    }

    public void setDeedId(long deedId) {
        this.deedId = deedId;
    }

    public Instant getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Instant fromDate) {
        this.fromDate = fromDate;
    }

    public Instant getToDate() {
        return this.toDate;
    }

    public void setToDate(Instant toDate) {
        this.toDate = toDate;
    }

    public Instant getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Instant sentDate) {
        this.sentDate = sentDate;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public long getUsersCount() {
        return this.usersCount;
    }

    public void setUsersCount(long usersCount) {
        this.usersCount = usersCount;
    }

    public long getParticipantsCount() {
        return this.participantsCount;
    }

    public void setParticipantsCount(long participantsCount) {
        this.participantsCount = participantsCount;
    }

    public long getRecipientsCount() {
        return this.recipientsCount;
    }

    public void setRecipientsCount(long recipientsCount) {
        this.recipientsCount = recipientsCount;
    }

    public long getAchievementsCount() {
        return this.achievementsCount;
    }

    public void setAchievementsCount(long achievementsCount) {
        this.achievementsCount = achievementsCount;
    }

    public long getActionsCount() {
        return this.actionsCount;
    }

    public void setActionsCount(long actionsCount) {
        this.actionsCount = actionsCount;
    }

    public String getRewardTokenAddress() {
        return this.rewardTokenAddress;
    }

    public long getRewardTokenNetworkId() {
        return this.rewardTokenNetworkId;
    }

    public void setRewardTokenNetworkId(long rewardTokenNetworkId) {
        this.rewardTokenNetworkId = rewardTokenNetworkId;
    }

    public double getHubRewardAmount() {
        return this.hubRewardAmount;
    }

    public void setHubRewardAmount(double hubRewardAmount) {
        this.hubRewardAmount = hubRewardAmount;
    }

    public double getHubTopRewardedAmount() {
        return this.hubTopRewardedAmount;
    }

    public void setHubTopRewardedAmount(double hubTopRewardedAmount) {
        this.hubTopRewardedAmount = hubTopRewardedAmount;
    }

    public SortedSet<String> getTransactions() {
        return this.transactions;
    }
}

