/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.service;

import io.meeds.notes.service.NotePageViewService;
import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.service.CMSService;
import io.meeds.tenant.hub.model.HubTenant;
import io.meeds.tenant.hub.rest.client.WomClientService;
import io.meeds.tenant.hub.storage.HubIdentityStorage;
import io.meeds.tenant.hub.storage.HubWalletStorage;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.WomConnectionRequest;
import io.meeds.wom.api.model.WomConnectionResponse;
import io.meeds.wom.api.model.WomDisconnectionRequest;
import java.io.ByteArrayInputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.Logo;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.wiki.model.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HubService {
    public static final int MAX_START_TENTATIVES = 5;
    public static final String HUB_CONNECTED_EVENT = "deed.tenant.hub.connected";
    public static final String HUB_DISCONNECTED_EVENT = "deed.tenant.hub.disconnected";
    public static final String HUB_UPDATE_ON_WOM_EVENT = "deed.tenant.hub.updatedOnWoM";
    public static final String MANAGER_DEFAULT_ROLES_PARAM = "managerDefaultRoles";
    public static final String PUBLIC_SITE_NAME = "public";
    public static final String PUBLIC_ACCESS_PERMISSION = "Everyone";
    public static final String PUBLIC_HUB_SUMMARY_SETTING_NAME = "publicHubSummary";
    private static final Log LOG = ExoLogger.getLogger(HubService.class);
    @Autowired
    private HubIdentityStorage hubIdentityStorage;
    @Autowired
    private HubWalletStorage hubWalletStorage;
    @Autowired
    private BrandingService brandingService;
    @Autowired
    private WomClientService womServiceClient;
    @Autowired
    private CMSService cmsService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private NotePageViewService notePageViewService;
    @Autowired
    private ListenerService listenerService;

    public String getHubAddress() {
        return this.hubIdentityStorage.getHubAddress();
    }

    public boolean isConnected() {
        HubTenant hub = this.getHub();
        return hub != null && hub.isConnected() && hub.getDeedId() > 0L && this.isAfterNow(hub.getUntilDate());
    }

    public HubTenant getHub() {
        return this.getHub(false);
    }

    public HubTenant getHub(boolean forceRefresh) {
        return this.hubIdentityStorage.getHub(forceRefresh);
    }

    public long getDeedId() {
        return this.isConnected() ? this.getHub().getDeedId() : -1L;
    }

    public short getDeedCity() {
        return this.isConnected() ? this.getHub().getCity() : (short)-1;
    }

    public short getDeedType() {
        return this.isConnected() ? this.getHub().getType() : (short)-1;
    }

    public String getDeedManager() {
        return this.isConnected() ? this.getHub().getDeedManagerAddress() : null;
    }

    public Instant getHubJoinDate() {
        return this.isConnected() ? this.getHub().getJoinDate() : null;
    }

    public boolean isDeedManager(String address) {
        return StringUtils.isNotBlank((CharSequence)address) && this.isConnected() && StringUtils.equalsIgnoreCase((CharSequence)this.getDeedManager(), (CharSequence)address);
    }

    public boolean isDeedManager(String address, long nftId) throws WomException {
        if (StringUtils.isNotBlank((CharSequence)address)) {
            return this.womServiceClient.isDeedManager(address, nftId);
        }
        return false;
    }

    public String generateWomToken() throws WomException {
        return this.womServiceClient.generateToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WomConnectionResponse connectToWoM(WomConnectionRequest connectionRequest) throws WomException {
        try {
            String address = this.hubWalletStorage.getOrCreateHubAddress();
            connectionRequest.setAddress(address);
            connectionRequest.setHubSignedMessage(this.hubWalletStorage.signHubMessage(connectionRequest.getRawMessage()));
            this.setHubCardProperties((Hub)connectionRequest);
            WomConnectionResponse connectionResponse = this.womServiceClient.connectToWom(connectionRequest);
            this.hubIdentityStorage.saveHubConnectionResponse(connectionResponse);
            try {
                this.saveHubAvatar();
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while saving Hub Avatar. This isn't be blocker, thus continue processing WoM Connection", (Throwable)e);
            }
            this.hubIdentityStorage.getHub(true);
            WomConnectionResponse womConnectionResponse = connectionResponse;
            this.hubIdentityStorage.refreshHubIdentity();
            return womConnectionResponse;
        }
        catch (Throwable throwable) {
            this.hubIdentityStorage.refreshHubIdentity();
            throw throwable;
        }
    }

    public void disconnectFromWom(WomDisconnectionRequest disconnectionRequest) throws WomException {
        try {
            if (!this.isConnected()) {
                throw new WomException("wom.alreadyDisconnected");
            }
            HubTenant hub = this.getHub();
            disconnectionRequest.setHubAddress(hub.getAddress());
            disconnectionRequest.setHubSignedMessage(this.hubWalletStorage.signHubMessage(disconnectionRequest.getRawMessage()));
            this.womServiceClient.disconnectFromWom(disconnectionRequest);
        }
        finally {
            this.hubIdentityStorage.refreshHubIdentity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHubCard() throws WomException {
        if (!this.isConnected()) {
            return;
        }
        String token = this.womServiceClient.generateToken();
        String hubSignedMessage = this.hubWalletStorage.signHubMessage(token);
        try {
            HubTenant hub = this.getHub();
            HubTenant original = hub.clone();
            this.setHubCardProperties(hub);
            boolean updated = false;
            if (!original.equals((Object)hub)) {
                LOG.info((Object)"Updating Hub Card on WoM Server");
                this.womServiceClient.saveHub(hub, hubSignedMessage, token);
                updated = true;
            }
            long logoUpdateDate = this.getLogoUpdateDate();
            if (hub.getAvatarUpdateTime() == 0L || hub.getAvatarUpdateTime() < logoUpdateDate) {
                LOG.info((Object)"Updating Hub Card Avatar on WoM Server");
                this.saveHubAvatar();
                this.hubIdentityStorage.saveHubAvatarUpdateTime(logoUpdateDate == 0L ? System.currentTimeMillis() : logoUpdateDate);
                updated = true;
            }
            if (updated) {
                this.listenerService.broadcast(HUB_DISCONNECTED_EVENT, (Object)original, (Object)hub);
            }
        }
        finally {
            this.hubIdentityStorage.refreshHubIdentity();
        }
    }

    public void saveHubAvatar() throws WomException {
        String hubAddress = this.getHubAddress();
        if (StringUtils.isBlank((CharSequence)hubAddress)) {
            throw new WomException("wom.notConnected");
        }
        Logo logo = this.brandingService.getLogo();
        if (logo == null || logo.getData() == null || logo.getData().length == 0) {
            return;
        }
        String token = this.womServiceClient.generateToken();
        String signedMessage = this.hubWalletStorage.signHubMessage(token);
        this.womServiceClient.saveHubAvatar(hubAddress, signedMessage, token, new ByteArrayInputStream(logo.getData()));
    }

    private void setHubCardProperties(Hub hub) {
        String enLanguage = Locale.ENGLISH.toLanguageTag();
        hub.setName(Collections.singletonMap(enLanguage, this.brandingService.getCompanyName()));
        hub.setDescription(Collections.singletonMap(enLanguage, this.getPublicDescription()));
        hub.setColor((String)this.brandingService.getThemeStyle().get("primaryColor"));
        hub.setUrl(CommonsUtils.getCurrentDomain());
    }

    private String getPublicDescription() {
        CMSSetting setting;
        Page note = null;
        if (this.isPublisSitePublished() && (setting = this.cmsService.getSetting("notePage", PUBLIC_HUB_SUMMARY_SETTING_NAME)) != null) {
            String enLanguage = Locale.ENGLISH.toLanguageTag();
            String defaultLanguage = this.localeConfigService.getDefaultLocaleConfig().getLanguage();
            note = this.notePageViewService.getNotePage(setting.getName(), defaultLanguage);
            if ((note == null || StringUtils.isBlank((CharSequence)note.getContent())) && !StringUtils.equals((CharSequence)defaultLanguage, (CharSequence)enLanguage)) {
                note = this.notePageViewService.getNotePage(setting.getName(), enLanguage);
            }
        }
        return note == null || StringUtils.isBlank((CharSequence)note.getContent()) ? "" : note.getContent();
    }

    private boolean isPublisSitePublished() {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(PUBLIC_SITE_NAME);
        return portalConfig != null && portalConfig.getAccessPermissions() != null && Arrays.asList(portalConfig.getAccessPermissions()).contains(PUBLIC_ACCESS_PERMISSION);
    }

    private long getLogoUpdateDate() {
        Logo logo = this.brandingService.getLogo();
        return logo == null ? 0L : logo.getUpdatedDate();
    }

    private boolean isAfterNow(Instant untilDate) {
        return untilDate == null || untilDate.isAfter(Instant.now());
    }
}

