/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.plugin;

import io.meeds.social.translation.plugin.TranslationPlugin;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;

public class NewsListViewTranslationPlugin
extends TranslationPlugin {
    public static final String NEWS_LIST_VIEW_OBJECT_TYPE = "newsListView";
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private final IdentityRegistry identityRegistry;
    private final OrganizationService organizationService;

    public NewsListViewTranslationPlugin(IdentityRegistry identityRegistry, OrganizationService organizationService) {
        this.identityRegistry = identityRegistry;
        this.organizationService = organizationService;
    }

    public String getObjectType() {
        return NEWS_LIST_VIEW_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(long objectId, String username) {
        return true;
    }

    public boolean hasEditPermission(long objectId, String username) {
        try {
            return this.getIdentity(username) != null && Objects.requireNonNull(this.getIdentity(username)).isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getAudienceId(long objectId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(long objectId) throws ObjectNotFoundException {
        return 0L;
    }

    private Identity getIdentity(String username) throws Exception {
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        Identity aclIdentity = this.identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            List<MembershipEntry> entries = this.organizationService.getMembershipHandler().findMembershipsByUser(username).stream().map(membership -> new MembershipEntry(membership.getGroupId(), membership.getMembershipType())).toList();
            aclIdentity = new Identity(username, entries);
            this.identityRegistry.register(aclIdentity);
        }
        return aclIdentity;
    }
}

