/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.HalfSerializer;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableRepeatWhen<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Observable<Object>, ? extends ObservableSource<?>> handler;

    public ObservableRepeatWhen(ObservableSource<T> source, Function<? super Observable<Object>, ? extends ObservableSource<?>> handler) {
        super(source);
        this.handler = handler;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        ObservableSource<?> other;
        Subject<Object> signaller = PublishSubject.create().toSerialized();
        try {
            other = ObjectHelper.requireNonNull(this.handler.apply(signaller), "The handler returned a null ObservableSource");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        RepeatWhenObserver<T> parent = new RepeatWhenObserver<T>(observer, signaller, this.source);
        observer.onSubscribe(parent);
        other.subscribe(parent.inner);
        parent.subscribeNext();
    }

    static final class RepeatWhenObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 802743776666017014L;
        final Observer<? super T> downstream;
        final AtomicInteger wip;
        final AtomicThrowable error;
        final Subject<Object> signaller;
        final InnerRepeatObserver inner;
        final AtomicReference<Disposable> upstream;
        final ObservableSource<T> source;
        volatile boolean active;

        RepeatWhenObserver(Observer<? super T> actual, Subject<Object> signaller, ObservableSource<T> source) {
            this.downstream = actual;
            this.signaller = signaller;
            this.source = source;
            this.wip = new AtomicInteger();
            this.error = new AtomicThrowable();
            this.inner = new InnerRepeatObserver();
            this.upstream = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.replace(this.upstream, d);
        }

        @Override
        public void onNext(T t) {
            HalfSerializer.onNext(this.downstream, t, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable e) {
            DisposableHelper.dispose(this.inner);
            HalfSerializer.onError(this.downstream, e, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            this.active = false;
            this.signaller.onNext(0);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.upstream.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose(this.inner);
        }

        void innerNext() {
            this.subscribeNext();
        }

        void innerError(Throwable ex) {
            DisposableHelper.dispose(this.upstream);
            HalfSerializer.onError(this.downstream, ex, (AtomicInteger)this, this.error);
        }

        void innerComplete() {
            DisposableHelper.dispose(this.upstream);
            HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isDisposed()) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.source.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        final class InnerRepeatObserver
        extends AtomicReference<Disposable>
        implements Observer<Object> {
            private static final long serialVersionUID = 3254781284376480842L;

            InnerRepeatObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onNext(Object t) {
                RepeatWhenObserver.this.innerNext();
            }

            @Override
            public void onError(Throwable e) {
                RepeatWhenObserver.this.innerError(e);
            }

            @Override
            public void onComplete() {
                RepeatWhenObserver.this.innerComplete();
            }
        }
    }
}

