/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.github.plugin;

import io.meeds.gamification.github.model.Event;
import io.meeds.gamification.github.plugin.GithubTriggerPlugin;
import io.meeds.gamification.github.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PullRequestTriggerPlugin
extends GithubTriggerPlugin {
    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        String userId = Utils.extractSubItem(payload, "sender", "login");
        Object objectId = Utils.extractSubItem(payload, "pull_request", "html_url");
        if (Objects.equals(Utils.extractSubItem(payload, "action"), "opened")) {
            return Collections.singletonList(new Event("creatPullRequest", null, userId, (String)objectId, "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (Objects.equals(Utils.extractSubItem(payload, "action"), "closed") && !Boolean.parseBoolean(Utils.extractSubItem(payload, "pull_request", "merged"))) {
            return Collections.singletonList(new Event("closePullRequest", null, userId, (String)objectId, "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (Objects.equals(Utils.extractSubItem(payload, "action"), "review_requested")) {
            String requestedReviewer = Utils.extractSubItem(payload, "requested_reviewer", "login");
            objectId = (String)objectId + "?requestedReviewer=" + requestedReviewer;
            return Collections.singletonList(new Event("requestReviewForPullRequest", null, userId, (String)objectId, "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        if (Objects.equals(Utils.extractSubItem(payload, "action"), "review_request_removed")) {
            String requestedReviewer = Utils.extractSubItem(payload, "requested_reviewer", "login");
            objectId = (String)objectId + "?requestedReviewer=" + requestedReviewer;
            return Collections.singletonList(new Event("reviewRequestRemoved", null, userId, (String)objectId, "githubPR", Utils.extractSubItem(payload, "organization", "id"), Utils.extractSubItem(payload, "repository", "id")));
        }
        return Collections.emptyList();
    }
}

