/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.rest.method.TypeProducer;

public abstract class BaseCollectionProducer
implements TypeProducer {
    private Class<?> collectionClass;

    protected BaseCollectionProducer(Class<?> collectionClass) {
        this.collectionClass = collectionClass;
    }

    protected abstract Object createValue(String var1) throws Exception;

    @Override
    public Object createValue(String param, MultivaluedMap<String, String> values, String defaultValue) throws Exception {
        List list = (List)values.get((Object)param);
        if (list != null) {
            Collection<Object> coll = this.getCollection();
            for (String v : list) {
                coll.add(this.createValue(v));
            }
            return coll;
        }
        if (defaultValue != null) {
            Collection<Object> coll = this.getCollection();
            coll.add(this.createValue(defaultValue));
            return coll;
        }
        return null;
    }

    private Collection<Object> getCollection() {
        if (this.collectionClass == List.class) {
            return new ArrayList<Object>();
        }
        if (this.collectionClass == Set.class) {
            return new HashSet<Object>();
        }
        if (this.collectionClass == SortedSet.class) {
            return new TreeSet<Object>();
        }
        throw new IllegalArgumentException();
    }
}

