/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import jakarta.persistence.metamodel.SingularAttribute;
import java.util.Objects;
import org.hibernate.Incubating;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;

@Incubating
public class Order<X> {
    private final SortDirection order;
    private final SingularAttribute<X, ?> attribute;
    private final Class<X> entityClass;
    private final String attributeName;
    private final NullPrecedence nullPrecedence;
    private final int element;

    private Order(SortDirection order, NullPrecedence nullPrecedence, SingularAttribute<X, ?> attribute) {
        this.order = order;
        this.attribute = attribute;
        this.attributeName = attribute.getName();
        this.entityClass = attribute.getDeclaringType().getJavaType();
        this.nullPrecedence = nullPrecedence;
        this.element = 1;
    }

    private Order(SortDirection order, NullPrecedence nullPrecedence, Class<X> entityClass, String attributeName) {
        this.order = order;
        this.entityClass = entityClass;
        this.attributeName = attributeName;
        this.attribute = null;
        this.nullPrecedence = nullPrecedence;
        this.element = 1;
    }

    private Order(SortDirection order, NullPrecedence nullPrecedence, int element) {
        this.order = order;
        this.entityClass = null;
        this.attributeName = null;
        this.attribute = null;
        this.nullPrecedence = nullPrecedence;
        this.element = element;
    }

    public static <T> Order<T> asc(SingularAttribute<T, ?> attribute) {
        return new Order<T>(SortDirection.ASCENDING, NullPrecedence.NONE, attribute);
    }

    public static <T> Order<T> desc(SingularAttribute<T, ?> attribute) {
        return new Order<T>(SortDirection.DESCENDING, NullPrecedence.NONE, attribute);
    }

    public static <T> Order<T> by(SingularAttribute<T, ?> attribute, SortDirection direction) {
        return new Order<T>(direction, NullPrecedence.NONE, attribute);
    }

    public static <T> Order<T> by(SingularAttribute<T, ?> attribute, SortDirection direction, NullPrecedence nullPrecedence) {
        return new Order<T>(direction, nullPrecedence, attribute);
    }

    public static <T> Order<T> asc(Class<T> entityClass, String attributeName) {
        return new Order<T>(SortDirection.ASCENDING, NullPrecedence.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> desc(Class<T> entityClass, String attributeName) {
        return new Order<T>(SortDirection.DESCENDING, NullPrecedence.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> by(Class<T> entityClass, String attributeName, SortDirection direction) {
        return new Order<T>(direction, NullPrecedence.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> by(Class<T> entityClass, String attributeName, SortDirection direction, NullPrecedence nullPrecedence) {
        return new Order<T>(direction, nullPrecedence, entityClass, attributeName);
    }

    public static Order<Object[]> asc(int element) {
        return new Order<Object[]>(SortDirection.ASCENDING, NullPrecedence.NONE, element);
    }

    public static Order<Object[]> desc(int element) {
        return new Order<Object[]>(SortDirection.DESCENDING, NullPrecedence.NONE, element);
    }

    public static Order<Object[]> by(int element, SortDirection direction) {
        return new Order<Object[]>(direction, NullPrecedence.NONE, element);
    }

    public static Order<Object[]> by(int element, SortDirection direction, NullPrecedence nullPrecedence) {
        return new Order<Object[]>(direction, nullPrecedence, element);
    }

    public SortDirection getDirection() {
        return this.order;
    }

    public NullPrecedence getNullPrecedence() {
        return this.nullPrecedence;
    }

    public SingularAttribute<X, ?> getAttribute() {
        return this.attribute;
    }

    public Class<X> getEntityClass() {
        return this.entityClass;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getElement() {
        return this.element;
    }

    public String toString() {
        return this.attributeName + " " + this.order;
    }

    public boolean equals(Object o) {
        if (o instanceof Order) {
            Order that = (Order)o;
            return that.order == this.order && that.nullPrecedence == this.nullPrecedence && that.element == this.element && Objects.equals(that.attributeName, this.attributeName) && Objects.equals(that.entityClass, this.entityClass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.order, this.element, this.attributeName, this.entityClass});
    }
}

