/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.social;

import io.meeds.analytics.listener.social.BaseAttachmentAnalyticsListener$AjcClosure1;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public abstract class BaseAttachmentAnalyticsListener
extends Listener<String, ObjectAttachmentId> {
    public static final String STATISTICS_ATTACH_OPERATION = "attachImages";
    public static final String STATISTICS_DETACH_OPERATION = "removeImageAttachments";
    public static final String ATTACHMENT_CREATED_EVENT = "attachment.created";
    public static final String ATTACHMENT_DELETED_EVENT = "attachment.deleted";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @ContainerTransactional
    public void onEvent(Event<String, ObjectAttachmentId> event) throws Exception {
        Event<String, ObjectAttachmentId> event2 = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), event2);
        Object[] objectArray = new Object[]{this, event2, joinPoint};
        BaseAttachmentAnalyticsListener$AjcClosure1 baseAttachmentAnalyticsListener$AjcClosure1 = new BaseAttachmentAnalyticsListener$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(baseAttachmentAnalyticsListener$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private StatisticData buildStatisticData(String operation, ObjectAttachmentId objectAttachment, long spaceId, long userId) {
        Space space = this.getSpaceService().getSpaceById(String.valueOf(spaceId));
        StatisticData statisticData = new StatisticData();
        statisticData.setModule(this.getModule(objectAttachment));
        statisticData.setSubModule(this.getSubModule(objectAttachment));
        statisticData.setOperation(operation);
        statisticData.setTimestamp(new Date().getTime());
        statisticData.setUserId(userId);
        AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        return statisticData;
    }

    protected void extendStatisticData(StatisticData statisticData, ObjectAttachmentId objectAttachment) {
    }

    protected abstract AttachmentService getAttachmentService();

    protected abstract SpaceService getSpaceService();

    protected abstract List<String> getSupportedObjectType();

    protected abstract String getModule(ObjectAttachmentId var1);

    protected abstract String getSubModule(ObjectAttachmentId var1);

    static {
        BaseAttachmentAnalyticsListener.ajc$preClinit();
    }

    static /* synthetic */ void onEvent_aroundBody0(BaseAttachmentAnalyticsListener ajc$this, Event event, JoinPoint joinPoint) {
        String username = (String)event.getSource();
        ObjectAttachmentId objectAttachment = (ObjectAttachmentId)event.getData();
        if (objectAttachment == null || !ajc$this.getSupportedObjectType().contains(objectAttachment.getObjectType())) {
            return;
        }
        Map attachmentPlugins = ajc$this.getAttachmentService().getAttachmentPlugins();
        AttachmentPlugin attachmentPlugin = (AttachmentPlugin)attachmentPlugins.get(objectAttachment.getObjectType());
        long spaceId = attachmentPlugin.getSpaceId(objectAttachment.getObjectId());
        long userId = AnalyticsUtils.getUserIdentityId((String)username);
        StatisticData statisticData = switch (event.getEventName()) {
            case ATTACHMENT_CREATED_EVENT -> ajc$this.buildStatisticData(STATISTICS_ATTACH_OPERATION, objectAttachment, spaceId, userId);
            case ATTACHMENT_DELETED_EVENT -> ajc$this.buildStatisticData(STATISTICS_DETACH_OPERATION, objectAttachment, spaceId, userId);
            default -> throw new IllegalArgumentException("Unexpected listener event name: " + event.getEventName());
        };
        ajc$this.extendStatisticData(statisticData, objectAttachment);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BaseAttachmentAnalyticsListener.java", BaseAttachmentAnalyticsListener.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onEvent", "io.meeds.analytics.listener.social.BaseAttachmentAnalyticsListener", "org.exoplatform.services.listener.Event", "event", "java.lang.Exception", "void"), 55);
    }
}

