/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.impl;

import java.util.Date;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.impl.NewUserConfig;

public class NewUserEventListener
extends UserEventListener {
    private NewUserConfig config_;

    public NewUserEventListener(InitParams params) throws Exception {
        this.config_ = (NewUserConfig)params.getObjectParamValues(NewUserConfig.class).get(0);
    }

    @Override
    public void preSave(User user, boolean isNew) throws Exception {
        if (isNew) {
            Date date = new Date();
            user.setLastLoginTime(date);
            user.setCreatedDate(date);
        }
    }

    @Override
    public void postSave(User user, boolean isNew) throws Exception {
        ExoContainer pcontainer = ExoContainerContext.getCurrentContainer();
        OrganizationService service = (OrganizationService)pcontainer.getComponentInstanceOfType(OrganizationService.class);
        UserProfile up = service.getUserProfileHandler().createUserProfileInstance();
        up.setUserName(user.getUserName());
        service.getUserProfileHandler().saveUserProfile(up, false);
        if (this.config_ == null) {
            return;
        }
        if (isNew && !this.config_.isIgnoreUser(user.getUserName())) {
            this.createDefaultUserMemberships(user, service);
        }
    }

    @Override
    public void preDelete(User user) throws Exception {
    }

    @Override
    public void postDelete(User user) throws Exception {
    }

    private void createDefaultUserMemberships(User user, OrganizationService service) throws Exception {
        List<?> groups = this.config_.getGroup();
        if (groups.size() == 0) {
            return;
        }
        for (int i = 0; i < groups.size(); ++i) {
            NewUserConfig.JoinGroup jgroup = (NewUserConfig.JoinGroup)groups.get(i);
            Group group = service.getGroupHandler().findGroupById(jgroup.getGroupId());
            MembershipType mtype = service.getMembershipTypeHandler().findMembershipType(jgroup.getMembership());
            service.getMembershipHandler().linkMembership(user, group, mtype, true);
        }
    }
}

