/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.utils;

import io.meeds.social.cms.service.CMSService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.diff.DiffResult;
import org.exoplatform.commons.diff.DiffService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.WikiPageHistory;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final String SLASH = "SLASH";
    public static final String DOT = "DOT";
    public static final String SPACE = "space";
    public static final String PAGE = "page";
    public static final String NOTE_LINK = "class=\"noteLink\" href=\"//-";
    public static final String ANONYM_IDENTITY = "__anonim";
    private static final Log log_ = ExoLogger.getLogger(Utils.class);
    public static final String COMPARE_REVISION = "CompareRevision";
    public static final String VER_NAME = "verName";
    private static final String MIMETYPE_TEXTHTML = "text/html";
    private static final Map<String, Map<String, WikiPageHistory>> editPageLogs = new HashMap<String, Map<String, WikiPageHistory>>();
    public static final String WIKI_RESOUCE_BUNDLE_NAME = "locale.wiki.service.WikiService";
    private static final String ILLEGAL_SEARCH_CHARACTERS = "\\!^()+{}[]:-\"";
    private static final String ILLEGAL_NAME_CHARACTERS = "*|\":[]/',^<>";
    public static final String SPLIT_TEXT_OF_DRAFT_FOR_NEW_PAGE = "_A_A_";
    public static final String NOTES_METADATA_OBJECT_TYPE = "notes";
    public static final String WIKI_APP_ID = "ks-wiki:spaces";
    public static final String PAGE_ID_KEY = "page_id";
    public static final String PAGE_TYPE_KEY = "page_type";
    public static final String PAGE_OWNER_KEY = "page_owner";

    public static String normalizeUploadedFilename(String name) {
        name = name.replace("%22", "\"");
        name = name.replace("\\\"", "\"");
        name = Utils.escapeIllegalCharacterInName(name);
        return name;
    }

    public static String escapeIllegalCharacterInQuery(String query) {
        String ret = query;
        if (ret != null) {
            for (char c : ILLEGAL_SEARCH_CHARACTERS.toCharArray()) {
                ret = ret.replace("" + c, "\\" + c);
            }
            ret = ret.replace("'", "''");
        }
        return ret;
    }

    public static String escapeIllegalCharacterInName(String name) {
        if (name == null) {
            return null;
        }
        if (".".equals(name)) {
            return "_";
        }
        int first = name.indexOf(46);
        int last = name.lastIndexOf(46);
        if (first != -1 && first == last && (first == 0 || last == name.length() - 1)) {
            name = name.replace('.', '_');
        }
        for (char c : ILLEGAL_NAME_CHARACTERS.toCharArray()) {
            name = name.replace(c, '_');
        }
        return name;
    }

    public static String getPortalName() {
        return PortalContainer.getCurrentPortalContainerName();
    }

    public static String getWikiResourceBundle(String key, ClassLoader cl) {
        Locale locale = WebuiRequestContext.getCurrentInstance().getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(WIKI_RESOUCE_BUNDLE_NAME, locale, cl);
        return resourceBundle.getString(key);
    }

    public static void logEditPageTime(WikiPageParams pageParams, String username, long updateTime, String draftName, boolean isNewPage) {
        WikiPageHistory logByUsername;
        String pageId = pageParams.getPageName();
        Map<String, WikiPageHistory> logByPage = editPageLogs.get(pageId);
        if (logByPage == null) {
            logByPage = new HashMap<String, WikiPageHistory>();
            editPageLogs.put(pageId, logByPage);
        }
        if ((logByUsername = logByPage.get(username)) == null) {
            logByUsername = new WikiPageHistory(pageParams, username, draftName, isNewPage);
            logByPage.put(username, logByUsername);
        }
        logByUsername.setEditTime(updateTime);
    }

    public static void removeLogEditPage(WikiPageParams pageParams, String user) {
        String pageId = pageParams.getPageName();
        Map<String, WikiPageHistory> logByPage = editPageLogs.get(pageId);
        if (logByPage != null) {
            logByPage.remove(user);
        }
    }

    public static String getIdentityUser(String userId) {
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateIdentity("organization", userId, false);
        return userIdentity.getProfile().getFullName();
    }

    public static String getPermanlink(WikiPageParams params, boolean hasDowmainUrl) throws Exception {
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        String wikiWebappUri = wikiService.getWikiWebappUri();
        StringBuilder sb = new StringBuilder(wikiWebappUri);
        sb.append("/");
        if (!params.getType().equalsIgnoreCase(WikiType.PORTAL.toString())) {
            sb.append(params.getType().toLowerCase());
            sb.append("/");
            sb.append(Utils.validateWikiOwner(params.getType(), params.getOwner()));
            sb.append("/");
        }
        if (params.getPageName() != null) {
            sb.append(params.getPageName());
        }
        if (hasDowmainUrl) {
            return Utils.getDomainUrl() + Utils.fillPortalName(sb.toString());
        }
        return Utils.fillPortalName(sb.toString());
    }

    private static String getDomainUrl() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        StringBuilder domainUrl = new StringBuilder();
        domainUrl.append(portalRequestContext.getRequest().getScheme());
        domainUrl.append("://");
        domainUrl.append(portalRequestContext.getRequest().getServerName());
        int port = portalRequestContext.getRequest().getServerPort();
        if (port != 80) {
            domainUrl.append(":");
            domainUrl.append(port);
        }
        return domainUrl.toString();
    }

    private static String fillPortalName(String url) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), url);
        return nodeURL.setResource(resource).toString();
    }

    public static Map<String, WikiPageHistory> getLogOfPage(String pageId) {
        Map<String, WikiPageHistory> logByPage = editPageLogs.get(pageId);
        if (logByPage == null) {
            logByPage = new HashMap<String, WikiPageHistory>();
        }
        return logByPage;
    }

    public static String validateWikiOwner(String wikiType, String wikiOwner) {
        if (wikiType != null && wikiType.equals(PortalConfig.GROUP_TYPE) && StringUtils.isNotEmpty((CharSequence)wikiOwner)) {
            if (wikiOwner.startsWith("/")) {
                wikiOwner = wikiOwner.substring(1, wikiOwner.length());
            }
            if (wikiOwner.endsWith("/")) {
                wikiOwner = wikiOwner.substring(0, wikiOwner.length() - 1);
            }
        }
        return wikiOwner;
    }

    public static String getDefaultRestBaseURI() {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(PortalContainer.getCurrentPortalContainerName());
        sb.append("/");
        sb.append(PortalContainer.getCurrentRestContextName());
        return sb.toString();
    }

    public static String getDocumentURL(WikiContext wikiContext) {
        if (wikiContext.getPortalURL() == null && wikiContext.getPortletURI() == null) {
            return wikiContext.getPageName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(wikiContext.getPortalURL());
        sb.append(wikiContext.getPortletURI());
        sb.append("/");
        if (!PortalConfig.PORTAL_TYPE.equalsIgnoreCase(wikiContext.getType())) {
            sb.append(wikiContext.getType().toLowerCase());
            sb.append("/");
            sb.append(Utils.validateWikiOwner(wikiContext.getType(), wikiContext.getOwner()));
            sb.append("/");
        }
        sb.append(wikiContext.getPageName());
        return sb.toString();
    }

    public static String getCurrentUser() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static boolean isDescendantPage(Page page, Page parentPage) throws WikiException {
        NoteService noteService = (NoteService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NoteService.class);
        if (page.getWikiType().equals(parentPage.getWikiType()) && page.getWikiOwner().equals(parentPage.getWikiOwner()) && page.getName().equals(parentPage.getName())) {
            return true;
        }
        Page parentOfPage = noteService.getParentNoteOf(page);
        if (parentOfPage == null) {
            return false;
        }
        if (parentOfPage.getWikiType().equals(parentPage.getWikiType()) && parentOfPage.getWikiOwner().equals(parentPage.getWikiOwner()) && parentOfPage.getName().equals(parentPage.getName())) {
            return true;
        }
        return Utils.isDescendantPage(parentOfPage, parentPage);
    }

    public static Object getObjectFromParams(WikiPageParams param) throws WikiException {
        NoteService noteService = (NoteService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NoteService.class);
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        String wikiType = param.getType();
        String wikiOwner = param.getOwner();
        String wikiPageId = param.getPageName();
        if (wikiOwner != null && wikiPageId != null) {
            if (!wikiPageId.equals("Home")) {
                return noteService.getNoteByRootPermission(wikiType, wikiOwner, wikiPageId);
            }
            Wiki wiki = wikiService.getWikiByTypeAndOwner(wikiType, wikiOwner);
            if (wiki != null) {
                Page wikiHome = wiki.getWikiHome();
                return wikiHome;
            }
            return null;
        }
        if (wikiOwner != null) {
            Wiki wiki = wikiService.getWikiByTypeAndOwner(wikiType.toUpperCase(), wikiOwner);
            return wiki;
        }
        if (wikiType != null) {
            return wikiType;
        }
        return null;
    }

    public static Deque<WikiPageParams> getStackParams(Page page) throws WikiException {
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        NoteService noteService = (NoteService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NoteService.class);
        ArrayDeque<WikiPageParams> stack = new ArrayDeque<WikiPageParams>();
        Wiki wiki = wikiService.getWikiByTypeAndOwner(page.getWikiType(), page.getWikiOwner());
        if (wiki != null) {
            while (page != null) {
                stack.push(new WikiPageParams(wiki.getType(), wiki.getOwner(), page.getName()));
                page = noteService.getParentNoteOf(page);
            }
        }
        return stack;
    }

    public static WikiPageParams getWikiPageParams(Page page) {
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        try {
            Wiki wiki = wikiService.getWikiByTypeAndOwner(page.getWikiType(), page.getWikiOwner());
            String wikiType = wiki.getType();
            WikiPageParams params = new WikiPageParams(wikiType, wiki.getOwner(), page.getName());
            return params;
        }
        catch (Exception e) {
            log_.error((Object)("Cannot build wiki page params from wiki page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static String getWikiOnChangeContent(Page page) throws WikiException, DifferentiationFailedException {
        DiffResult diffResult;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NoteService wikiService = (NoteService)container.getComponentInstanceOfType(NoteService.class);
        DiffService diffService = (DiffService)container.getComponentInstanceOfType(DiffService.class);
        String currentVersionContent = page.getContent() != null ? new String(page.getContent()) : "";
        List<PageHistory> versions = wikiService.getVersionsHistoryOfNote(page, "");
        String previousVersionContent = "";
        if (versions != null && !versions.isEmpty()) {
            PageHistory previousVersion = versions.get(0);
            previousVersionContent = previousVersion.getContent();
        }
        if ((diffResult = diffService.getDifferencesAsHTML(previousVersionContent, currentVersionContent, false)).getChanges() == 0) {
            diffResult.setDiffHTML("No changes, new revision is created.");
        }
        StringBuilder sbt = new StringBuilder();
        sbt.append("<html>").append("  <body>").append(Utils.insertStyle(diffResult.getDiffHTML())).append("  </body>").append("</html>");
        return sbt.toString();
    }

    private static boolean isEnabledUser(String userName) throws WikiException {
        OrganizationService orgService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        try {
            return orgService.getUserHandler().findUserByName(userName) != null;
        }
        catch (Exception e) {
            throw new WikiException("Cannot check if user " + userName + " is enabled", e);
        }
    }

    public static String getEmailUser(String userName) throws WikiException {
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        try {
            User user = organizationService.getUserHandler().findUserByName(userName);
            String email = user.getEmail();
            return email;
        }
        catch (Exception e) {
            throw new WikiException("Cannot get email of user " + userName, e);
        }
    }

    public static HashMap<String, IDType> getACLForAdmins() {
        HashMap<String, IDType> permissionMap = new HashMap<String, IDType>();
        UserACL userACL = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
        permissionMap.put(userACL.getSuperUser(), IDType.USER);
        for (String group : userACL.getPortalCreatorGroups()) {
            if (StringUtils.isEmpty((CharSequence)group)) continue;
            permissionMap.put(group, IDType.MEMBERSHIP);
        }
        return permissionMap;
    }

    private static String insertStyle(String rawHTML) {
        String result = rawHTML;
        result = result.replaceAll("class=\"diffaddword\"", "style=\"background: #b5ffbf;\"");
        result = result.replaceAll("<span class=\"diffremoveword\">", "<span style=\" background: #ffd8da;text-decoration: line-through;\">");
        result = result.replaceAll("<pre class=\"diffremoveword\">", "<pre style=\" background: #ffd8da;\">");
        return result;
    }

    public static String getURL(String url, String verName) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(url).append("?").append("action").append("=").append(COMPARE_REVISION).append("&").append(VER_NAME).append("=").append(verName);
        return strBuffer.toString();
    }

    public static long countSearchResult(WikiSearchData data) throws Exception {
        data.setOffset(0L);
        data.setLimit(Integer.MAX_VALUE);
        NoteService noteService = (NoteService)PortalContainer.getComponent(NoteService.class);
        PageList<SearchResult> results = noteService.search(data);
        return results.getAll().size();
    }

    public static String getAttachmentCssClass(Attachment attachment, String append) throws Exception {
        Class<?> dmsMimeTypeResolverClass = Class.forName("org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver");
        Object dmsMimeTypeResolverObject = dmsMimeTypeResolverClass.getDeclaredMethod("getInstance", null).invoke(null, null);
        Object mimeType = dmsMimeTypeResolverClass.getMethod("getMimeType", String.class).invoke(dmsMimeTypeResolverObject, new String(attachment.getFullTitle().toLowerCase()));
        StringBuilder cssClass = new StringBuilder();
        cssClass.append(append);
        cssClass.append("FileDefault");
        cssClass.append(" ");
        cssClass.append(append);
        cssClass.append("nt_file");
        cssClass.append(" ");
        cssClass.append(append);
        cssClass.append(((String)mimeType).replaceAll("/|\\.", ""));
        return cssClass.toString();
    }

    public static String getRestContextName() {
        return PortalContainer.getCurrentRestContextName();
    }

    public static String getPageUrl(Page page) {
        String appName = page.getAppName();
        appName = StringUtils.isEmpty((CharSequence)appName) && StringUtils.startsWith((CharSequence)page.getWikiOwner(), (CharSequence)"/spaces") ? Utils.getWikiAppNameInSpace(page.getWikiOwner()) : NOTES_METADATA_OBJECT_TYPE;
        String spaceUri = Utils.getSpacesURI(page);
        StringBuilder spaceUrl = new StringBuilder("/portal");
        spaceUrl.append(spaceUri);
        spaceUrl.append("/");
        spaceUrl.append(appName);
        spaceUrl.append("/");
        if (!StringUtils.isEmpty((CharSequence)page.getId())) {
            spaceUrl.append(page.getId());
        }
        return spaceUrl.toString();
    }

    public static String getSpacesURI(Page page) {
        try {
            QualifiedName REQUEST_HANDLER = QualifiedName.create((String)"gtn", (String)"handler");
            QualifiedName REQUEST_SITE_TYPE = QualifiedName.create((String)"gtn", (String)"sitetype");
            QualifiedName REQUEST_SITE_NAME = QualifiedName.create((String)"gtn", (String)"sitename");
            QualifiedName PATH = QualifiedName.create((String)"gtn", (String)"path");
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            WebAppController webAppController = (WebAppController)CommonsUtils.getService(WebAppController.class);
            Router router = webAppController.getRouter();
            Space space = spaceService.getSpaceByGroupId(page.getWikiOwner());
            if (space == null) {
                return "";
            }
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put(REQUEST_HANDLER, "portal");
            qualifiedName.put(REQUEST_SITE_TYPE, "group");
            StringBuilder urlBuilder = new StringBuilder();
            qualifiedName.put(REQUEST_SITE_NAME, space.getGroupId());
            qualifiedName.put(PATH, space.getPrettyName());
            router.render((Map)qualifiedName, new URIWriter((Appendable)urlBuilder));
            return urlBuilder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getWikiAppNameInSpace(String spaceGroupId) {
        try {
            List spaceTemplateApplications;
            SpaceTemplateService spaceTemplateService;
            SpaceTemplate spaceTemplate;
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            if (StringUtils.isBlank((CharSequence)spaceGroupId)) {
                return null;
            }
            Space space = spaceService.getSpaceByGroupId(spaceGroupId);
            if (space != null && (spaceTemplate = (spaceTemplateService = (SpaceTemplateService)CommonsUtils.getService(SpaceTemplateService.class)).getSpaceTemplateByName(space.getTemplate())) != null && CollectionUtils.isNotEmpty((Collection)(spaceTemplateApplications = spaceTemplate.getSpaceApplicationList()))) {
                for (SpaceApplication spaceApplication : spaceTemplateApplications) {
                    if (!"WikiPortlet".equals(spaceApplication.getPortletName())) continue;
                    return spaceApplication.getUri();
                }
            }
        }
        catch (Exception e) {
            log_.warn((Object)"Cannot get Wiki App anme", (Throwable)e);
        }
        return NOTES_METADATA_OBJECT_TYPE;
    }

    public static List<String> unzip(String zipFilePath, String folderPath) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        File destDir = new File(folderPath);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = folderPath + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    Utils.extractFile(zipIn, filePath);
                    files.add(filePath);
                } else {
                    File dir = new File(filePath);
                    dir.mkdirs();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        return files;
    }

    public static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    public static String html2text(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return html;
        }
        Document doc = Jsoup.parse((String)html);
        return doc.text();
    }

    public static <S, D> void broadcast(ListenerService listenerService, String eventName, S source, D data) {
        try {
            listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting event: {}. Wheres, the operation will continue to proceed", new Object[]{eventName, e});
        }
    }

    public static boolean canManageNotes(String authenticatedUser, Space space, Page page) throws WikiException {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        CMSService cmsService = (CMSService)CommonsUtils.getService(CMSService.class);
        if (space != null) {
            return spaceService.isSuperManager(authenticatedUser) || spaceService.isManager(space, authenticatedUser) || spaceService.isRedactor(space, authenticatedUser) || spaceService.isMember(space, authenticatedUser) && ArrayUtils.isEmpty((Object[])space.getRedactors());
        }
        if (StringUtils.equals((CharSequence)page.getOwner(), (CharSequence)IdentityConstants.SYSTEM)) {
            return cmsService.hasEditPermission(Utils.getIdentity(authenticatedUser), "notePage", page.getName());
        }
        return StringUtils.equals((CharSequence)page.getOwner(), (CharSequence)authenticatedUser);
    }

    public static Identity getIdentity(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        IdentityRegistry identityRegistry = (IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class);
        Identity aclIdentity = identityRegistry.getIdentity(username);
        if (aclIdentity == null) {
            try {
                OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
                List<MembershipEntry> entries = organizationService.getMembershipHandler().findMembershipsByUser(username).stream().map(membership -> new MembershipEntry(membership.getGroupId(), membership.getMembershipType())).toList();
                aclIdentity = new Identity(username, entries);
                identityRegistry.register(aclIdentity);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to retrieve user " + username + " memberships", e);
            }
        }
        return aclIdentity;
    }
}

