/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import org.springframework.data.elasticsearch.ElasticsearchErrorCause;
import org.springframework.lang.Nullable;

public class MultiGetItem<T> {
    @Nullable
    private final T item;
    @Nullable
    private final Failure failure;

    private MultiGetItem(@Nullable T item, @Nullable Failure failure) {
        this.item = item;
        this.failure = failure;
    }

    public static <T> MultiGetItem<T> of(@Nullable T item, @Nullable Failure failure) {
        return new MultiGetItem<T>(item, failure);
    }

    public boolean hasItem() {
        return this.item != null;
    }

    @Nullable
    public T getItem() {
        return this.item;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    @Nullable
    public Failure getFailure() {
        return this.failure;
    }

    public static class Failure {
        @Nullable
        private final String index;
        @Nullable
        private final String type;
        @Nullable
        private final String id;
        @Nullable
        private final Exception exception;
        @Nullable
        private final ElasticsearchErrorCause elasticsearchErrorCause;

        private Failure(@Nullable String index, @Nullable String type, @Nullable String id, @Nullable Exception exception, @Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.exception = exception;
            this.elasticsearchErrorCause = elasticsearchErrorCause;
        }

        public static Failure of(String index, @Nullable String type, String id, @Nullable Exception exception, @Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
            return new Failure(index, type, id, exception, elasticsearchErrorCause);
        }

        @Nullable
        public String getIndex() {
            return this.index;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public Exception getException() {
            return this.exception;
        }

        @Nullable
        public ElasticsearchErrorCause getElasticsearchErrorCause() {
            return this.elasticsearchErrorCause;
        }
    }
}

