/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.social;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsSpaceListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(AnalyticsSpaceListener.class);
    @Autowired
    private SpaceService spaceService;

    @PostConstruct
    public void init() {
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)this);
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceAccessEdited");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceBannerEdited");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceCreated");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceRemoved");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceRenamed");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceDescriptionEdited");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceRegistrationEdited");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addSpaceStatisticEvent(event, "spaceAvatarEdited");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addApplicationStatisticEvent(event, "applicationActivated");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addApplicationStatisticEvent(event, "applicationAdded");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addApplicationStatisticEvent(event, "applicationDeactivated");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addApplicationStatisticEvent(event, "applicationRemoved");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addUserStatisticEvent(event, "grantedLead");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void joined(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addUserStatisticEvent(event, "joined");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void left(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addUserStatisticEvent(event, "left");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addUserStatisticEvent(event, "revokedLead");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addUserStatisticEvent(event, "addInvitedUser");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
        try {
            StatisticData statisticData = this.addUserStatisticEvent(event, "addPendingUser");
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
        catch (Exception e) {
            this.handleErrorProcessingOperation(event, e);
        }
    }

    private StatisticData addSpaceStatisticEvent(SpaceLifeCycleEvent event, String operation) {
        return this.buildStatisticData(operation, event.getSpace());
    }

    private StatisticData addApplicationStatisticEvent(SpaceLifeCycleEvent event, String operation) {
        Space space = event.getSpace();
        String applicationId = (String)event.getSource();
        StatisticData statisticData = this.buildStatisticData(operation, space);
        statisticData.addParameter("applicationId", (Object)applicationId);
        return statisticData;
    }

    private StatisticData addUserStatisticEvent(SpaceLifeCycleEvent event, String operation) {
        Space space = event.getSpace();
        return this.buildStatisticData(operation, space);
    }

    private StatisticData buildStatisticData(String operation, Space space) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("space");
        statisticData.setOperation(operation);
        statisticData.setUserId(AnalyticsUtils.getCurrentUserIdentityId());
        AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        return statisticData;
    }

    private void handleErrorProcessingOperation(SpaceLifeCycleEvent event, Exception exception) {
        LOG.warn("Error adding Statistic data for space {} with event {}", new Object[]{event.getSpace().getId(), event.getType(), exception});
    }
}

