/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.activity.processor;

import io.meeds.news.model.News;
import io.meeds.news.service.NewsService;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityNewsProcessor
extends BaseActivityProcessorPlugin {
    private static final Log LOG = ExoLogger.getLogger(ActivityNewsProcessor.class);
    private static final String ACTIVITY_PROCESSOR_NAME = "ActivityNewsProcessor";
    private static final int processorPriority = 30;
    @Autowired
    private NewsService newsService;
    @Autowired
    private ActivityManager activityManager;

    public ActivityNewsProcessor() {
        super(ActivityNewsProcessor.getInitParams());
    }

    @PostConstruct
    public void init() {
        this.activityManager.addProcessorPlugin((BaseActivityProcessorPlugin)this);
    }

    public String getName() {
        return ACTIVITY_PROCESSOR_NAME;
    }

    public void processActivity(ExoSocialActivity activity) {
        News news;
        if (activity.isComment() || activity.getType() == null || !activity.getTemplateParams().containsKey("newsId")) {
            return;
        }
        if (activity.getLinkedProcessedEntities() == null) {
            activity.setLinkedProcessedEntities(new HashMap());
        }
        if ((news = (News)activity.getLinkedProcessedEntities().get("news")) == null) {
            try {
                if (!NumberUtils.isParsable((String)((String)activity.getTemplateParams().get("newsId")))) {
                    return;
                }
                news = this.newsService.getNewsArticleById((String)activity.getTemplateParams().get("newsId"));
                RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess(activity, true);
                news.setCommentsCount(listAccess.getSize());
                news.setLikesCount(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
                activity.setMetadataObjectId(news.getId());
                activity.setMetadataObjectType("news");
            }
            catch (Exception e) {
                LOG.warn("Error retrieving news with id {}", new Object[]{activity.getTemplateParams().get("newsId"), e});
            }
            activity.getLinkedProcessedEntities().put("news", news);
        }
    }

    private static InitParams getInitParams() {
        InitParams initParams = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("priority");
        param.setValue(String.valueOf(30));
        initParams.addParameter((Parameter)param);
        return initParams;
    }
}

