/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.config.StaleModelException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationBackgroundStyle;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.CloneApplicationState;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.PersistentApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.jdbc.entity.ContainerEntity;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.dao.ContainerDAO;
import org.exoplatform.portal.mop.dao.PermissionDAO;
import org.exoplatform.portal.mop.dao.WindowDAO;
import org.exoplatform.portal.mop.storage.utils.MOPUtils;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.BodyData;
import org.exoplatform.portal.pom.data.BodyType;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class LayoutStorage {
    private static final String TYPE_PROP = MappedAttributes.TYPE.getName();
    private static final String ID_PROP = MappedAttributes.ID.getName();
    private static final String CHILDREN_PROP = "children";
    private static final Log LOG = ExoLogger.getExoLogger(LayoutStorage.class);
    private WindowDAO windowDAO;
    private ContainerDAO containerDAO;
    private PermissionDAO permissionDAO;

    public LayoutStorage(WindowDAO windowDAO, ContainerDAO containerDAO, PermissionDAO permissionDAO) {
        this.windowDAO = windowDAO;
        this.containerDAO = containerDAO;
        this.permissionDAO = permissionDAO;
    }

    public <S> S load(ApplicationState<S> state, ApplicationType<S> type) {
        if (state instanceof TransientApplicationState) {
            TransientApplicationState transientState = (TransientApplicationState)state;
            Object prefs = transientState.getContentState();
            if (prefs == null && type.getContentType().getStateClass().equals(Portlet.class)) {
                return (S)new Portlet();
            }
            return (S)prefs;
        }
        Long id = state instanceof CloneApplicationState ? Long.valueOf(Safe.parseLong((String)((CloneApplicationState)state).getStorageId())) : Long.valueOf(Safe.parseLong((String)((PersistentApplicationState)state).getStorageId()));
        WindowEntity window = this.findWindow(id);
        if (window != null) {
            byte[] customization = window.getCustomization();
            if (customization != null) {
                return (S)MOPUtils.unserialize(customization);
            }
            if (type.getContentType().getStateClass().equals(Portlet.class)) {
                return (S)new Portlet();
            }
            return null;
        }
        return null;
    }

    public <S> ApplicationState<S> save(ApplicationState<S> state, S preferences) {
        if (state instanceof TransientApplicationState) {
            throw new AssertionError((Object)"Does not make sense");
        }
        Long id = state instanceof CloneApplicationState ? Long.valueOf(Safe.parseLong((String)((CloneApplicationState)state).getStorageId())) : Long.valueOf(Safe.parseLong((String)((PersistentApplicationState)state).getStorageId()));
        WindowEntity window = this.findWindow(id);
        if (window != null) {
            if (preferences != null) {
                window.setCustomization(MOPUtils.serialize((Serializable)preferences));
            } else {
                window.setCustomization(null);
            }
            this.updateWindow(window);
        }
        return state;
    }

    public <S> String getId(ApplicationState<S> state) {
        Long id;
        if (state instanceof TransientApplicationState) {
            TransientApplicationState tstate = (TransientApplicationState)state;
            return tstate.getContentId();
        }
        if (state instanceof PersistentApplicationState) {
            PersistentApplicationState pstate = (PersistentApplicationState)state;
            id = Safe.parseLong((String)pstate.getStorageId());
        } else if (state instanceof CloneApplicationState) {
            CloneApplicationState cstate = (CloneApplicationState)state;
            id = Safe.parseLong((String)cstate.getStorageId());
        } else {
            throw new IllegalStateException("Unrecognized Application state class type : " + String.valueOf(state));
        }
        WindowEntity window = this.findWindow(id);
        if (window != null) {
            return window.getContentId();
        }
        return null;
    }

    public <S> ApplicationData<S> getApplicationData(String applicationStorageId) {
        WindowEntity window = (WindowEntity)this.windowDAO.find(Long.valueOf(Safe.parseLong((String)applicationStorageId)));
        if (window != null) {
            return this.buildWindow(window);
        }
        return null;
    }

    public <S> Application<S> getApplicationModel(String applicationStorageId) {
        ApplicationData<S> applicationData = this.getApplicationData(applicationStorageId);
        return new Application(applicationData);
    }

    public List<ComponentEntity> saveChildren(JSONArray pageBody, List<ComponentData> children) {
        this.cleanDeletedComponents(pageBody, children);
        return this.saveChildren(children);
    }

    public List<ComponentData> buildChildren(JSONArray jsonBody) {
        Map<Long, ContainerEntity> containers = this.getContainerEntities(jsonBody);
        Map<Long, WindowEntity> windows = this.getWindowEntities(jsonBody);
        return this.buildChildren(jsonBody, containers, windows);
    }

    public void deleteChildren(JSONArray children) {
        for (Object child : children) {
            JSONObject c = (JSONObject)child;
            Long id = Safe.parseLong((String)c.get((Object)ID_PROP).toString());
            ComponentEntity.TYPE t = ComponentEntity.TYPE.valueOf(c.get((Object)TYPE_PROP).toString());
            if (ComponentEntity.TYPE.CONTAINER.equals((Object)t)) {
                ContainerEntity container;
                JSONArray descendants = (JSONArray)c.get((Object)CHILDREN_PROP);
                if (descendants != null) {
                    this.deleteChildren(descendants);
                }
                if ((container = (ContainerEntity)this.containerDAO.find(id)) == null) continue;
                JSONArray dashboardChilds = MOPUtils.parseJsonArray(container.getContainerBody());
                this.deleteChildren(dashboardChilds);
                this.permissionDAO.deletePermissions(ContainerEntity.class.getName(), container.getId());
                this.containerDAO.delete(container);
                continue;
            }
            if (ComponentEntity.TYPE.WINDOW.equals((Object)t)) {
                WindowEntity window = this.findWindow(id);
                if (window == null) continue;
                this.permissionDAO.deletePermissions(WindowEntity.class.getName(), window.getId());
                this.deleteWindow(window);
                continue;
            }
            throw new IllegalArgumentException("Can't delete child with type: " + String.valueOf((Object)t));
        }
    }

    public List<String> getPermissions(String objectType, Long objectId, PermissionEntity.TYPE permisssionType) {
        return this.buildPermission(this.permissionDAO.getPermissions(objectType, objectId, permisssionType));
    }

    public List<PermissionEntity> savePermissions(String objectType, long objectId, PermissionEntity.TYPE type, List<String> permissions) {
        return this.permissionDAO.savePermissions(objectType, objectId, type, permissions);
    }

    public List<ComponentEntity> clone(String objectType, String pageBody) {
        LinkedList<ComponentEntity> results = new LinkedList<ComponentEntity>();
        JSONArray children = this.parse(pageBody);
        block4: for (Object child : children) {
            JSONObject c = (JSONObject)child;
            Long id = Safe.parseLong((String)c.get((Object)ID_PROP).toString());
            ComponentEntity.TYPE type = ComponentEntity.TYPE.valueOf(c.get((Object)TYPE_PROP).toString());
            switch (type) {
                case CONTAINER: {
                    ContainerEntity srcC = (ContainerEntity)this.containerDAO.find(id);
                    ContainerEntity dstC = this.clone(srcC);
                    JSONArray descendants = this.parse(srcC.getContainerBody());
                    if (CollectionUtils.isNotEmpty((Collection)descendants)) {
                        dstC.setChildren(this.clone(objectType, srcC.getContainerBody()));
                    } else {
                        dstC.setChildren(this.clone(objectType, ((JSONArray)c.get((Object)CHILDREN_PROP)).toJSONString()));
                    }
                    dstC.setContainerBody(((JSONArray)dstC.toJSON().get((Object)CHILDREN_PROP)).toJSONString());
                    this.containerDAO.create(dstC);
                    this.clonePermissions(objectType, dstC.getId(), srcC.getId());
                    results.add(dstC);
                    continue block4;
                }
                case WINDOW: {
                    WindowEntity srcW = this.findWindow(id);
                    WindowEntity dstW = this.clone(srcW);
                    dstW = this.createWindow(dstW);
                    this.clonePermissions(objectType, dstW.getId(), srcW.getId());
                    results.add(dstW);
                    continue block4;
                }
            }
            throw new IllegalStateException("Can't handle type: " + String.valueOf((Object)type));
        }
        return results;
    }

    public void clonePermissions(String objectType, long dstId, long srcId) {
        this.clonePermissions(objectType, dstId, srcId, PermissionEntity.TYPE.ACCESS);
        this.clonePermissions(objectType, dstId, srcId, PermissionEntity.TYPE.EDIT);
        this.clonePermissions(objectType, dstId, srcId, PermissionEntity.TYPE.MOVE_APP);
        this.clonePermissions(objectType, dstId, srcId, PermissionEntity.TYPE.MOVE_CONTAINER);
    }

    public void clonePermissions(String objectType, long dstId, long srcId, PermissionEntity.TYPE type) {
        List<String> permissions = this.getPermissions(objectType, srcId, type);
        if (!permissions.isEmpty()) {
            this.savePermissions(objectType, dstId, type, permissions);
        }
    }

    public void deletePermissions(String objectType, Long objectId) {
        this.permissionDAO.deletePermissions(objectType, objectId);
    }

    protected WindowEntity createWindow(WindowEntity dstW) {
        return (WindowEntity)this.windowDAO.create(dstW);
    }

    protected WindowEntity updateWindow(WindowEntity window) {
        return (WindowEntity)this.windowDAO.update(window);
    }

    protected WindowEntity findWindow(Long id) {
        return (WindowEntity)this.windowDAO.find(id);
    }

    protected void deleteWindow(WindowEntity window) {
        this.windowDAO.delete(window);
    }

    protected void deleteWindowById(Long id) {
        this.windowDAO.deleteById(id);
    }

    private WindowEntity clone(WindowEntity src) {
        WindowEntity dst = new WindowEntity();
        dst.setAppType(src.getAppType());
        dst.setContentId(src.getContentId());
        dst.setCustomization(src.getCustomization());
        dst.setDescription(src.getDescription());
        dst.setHeight(src.getHeight());
        dst.setIcon(src.getIcon());
        dst.setProperties(src.getProperties());
        dst.setShowApplicationMode(src.isShowApplicationMode());
        dst.setShowApplicationState(src.isShowApplicationState());
        dst.setShowInfoBar(src.isShowInfoBar());
        dst.setTheme(src.getTheme());
        dst.setTitle(src.getTitle());
        dst.setWidth(src.getWidth());
        return dst;
    }

    private JSONArray parse(String body) {
        JSONParser parser = new JSONParser();
        try {
            JSONArray children = (JSONArray)parser.parse(body);
            return children;
        }
        catch (ParseException e) {
            throw new IllegalStateException("Can't parse body: " + body);
        }
    }

    private ContainerEntity clone(ContainerEntity src) {
        ContainerEntity dst = new ContainerEntity();
        dst.setDescription(src.getDescription());
        dst.setFactoryId(src.getFactoryId());
        dst.setHeight(src.getHeight());
        dst.setIcon(src.getIcon());
        dst.setName(src.getName());
        dst.setProperties(src.getProperties());
        dst.setTemplate(src.getTemplate());
        dst.setTitle(src.getTitle());
        dst.setWidth(src.getWidth());
        dst.setContainerBody(src.getContainerBody());
        return dst;
    }

    private void cleanDeletedComponents(JSONArray body, List<ComponentData> children) {
        HashSet<Long> windowIds = new HashSet<Long>();
        this.filterBodyContainerIds(body, ComponentEntity.TYPE.WINDOW, windowIds);
        for (Long id : windowIds) {
            if (this.findById(id, ComponentEntity.TYPE.WINDOW, children) != null) continue;
            this.deleteWindowById(id);
        }
        HashSet<Long> containerIds = new HashSet<Long>();
        this.filterBodyContainerIds(body, ComponentEntity.TYPE.CONTAINER, containerIds);
        for (Long id : containerIds) {
            if (this.findById(id, ComponentEntity.TYPE.CONTAINER, children) != null) continue;
            this.containerDAO.deleteById(id);
        }
    }

    private ContainerEntity buildContainerEntity(ContainerEntity dst, ContainerData src) {
        ApplicationBackgroundStyle appCssStyle;
        ModelStyle cssStyle;
        if (dst == null) {
            dst = new ContainerEntity();
        }
        dst.setWebuiId(src.getId());
        dst.setDescription(src.getDescription());
        dst.setFactoryId(src.getFactoryId());
        dst.setHeight(src.getHeight());
        dst.setIcon(src.getIcon());
        dst.setName(src.getName());
        dst.setTemplate(src.getTemplate());
        dst.setTitle(src.getTitle());
        dst.setWidth(src.getWidth());
        JSONObject properties = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)src.getProfiles())) {
            properties.put((Object)MappedAttributes.PROFILES.getName(), (Object)src.getProfiles());
        }
        if (StringUtils.isNotBlank((CharSequence)src.getCssClass())) {
            properties.put((Object)MappedAttributes.CSS_CLASS.getName(), (Object)src.getCssClass());
        }
        if ((cssStyle = src.getCssStyle()) != null) {
            this.mapStyleToProperties(cssStyle, properties);
        }
        if ((appCssStyle = src.getAppBackgroundStyle()) != null) {
            this.mapAppStyleToProperties(appCssStyle, properties);
        }
        dst.setProperties(properties.toJSONString());
        return dst;
    }

    private WindowEntity buildWindowEntity(WindowEntity dst, ApplicationData srcChild) {
        if (dst == null) {
            ApplicationState state;
            dst = new WindowEntity();
            ApplicationType type = srcChild.getType();
            if (type == null) {
                LOG.warn("Application type of instance {} is not recognized, ignore it", new Object[]{dst.getContentId()});
                return null;
            }
            if (ApplicationType.PORTLET.getName().equals(type.getName())) {
                dst.setAppType(WindowEntity.AppType.PORTLET);
            }
            if ((state = srcChild.getState()) instanceof TransientApplicationState) {
                TransientApplicationState s = (TransientApplicationState)state;
                dst.setContentId(s.getContentId());
                if (s.getContentState() != null) {
                    dst.setCustomization(MOPUtils.serialize((Serializable)s.getContentState()));
                }
            } else {
                throw new IllegalStateException("Can't create new window");
            }
        }
        dst.setDescription(srcChild.getDescription());
        dst.setHeight(srcChild.getHeight());
        dst.setIcon(srcChild.getIcon());
        dst.setShowApplicationMode(srcChild.isShowApplicationMode());
        dst.setShowApplicationState(srcChild.isShowApplicationState());
        dst.setShowInfoBar(srcChild.isShowInfoBar());
        dst.setTheme(srcChild.getTheme());
        dst.setTitle(srcChild.getTitle());
        dst.setWidth(srcChild.getWidth());
        boolean hasCssClass = StringUtils.isNotBlank((CharSequence)srcChild.getCssClass());
        if (hasCssClass || srcChild.getCssStyle() != null) {
            ModelStyle cssStyle;
            JSONObject properties;
            JSONObject jSONObject = properties = srcChild.getProperties() == null ? new JSONObject() : new JSONObject(srcChild.getProperties());
            if (hasCssClass) {
                properties.put((Object)MappedAttributes.CSS_CLASS.getName(), (Object)srcChild.getCssClass());
            }
            if ((cssStyle = srcChild.getCssStyle()) != null) {
                this.mapStyleToProperties(cssStyle, properties);
            }
            dst.setProperties(properties.toJSONString());
        } else {
            dst.setProperties(MOPUtils.toJSONString(srcChild.getProperties()));
        }
        return dst;
    }

    private ComponentData findById(Long id, ComponentEntity.TYPE type, List<ComponentData> children) {
        if (children != null) {
            for (ComponentData child : children) {
                ContainerData childContainer;
                ComponentData result;
                if (id.equals(Safe.parseLong((String)child.getStorageId())) && (type == ComponentEntity.TYPE.WINDOW && child instanceof ApplicationData || type == ComponentEntity.TYPE.CONTAINER && child instanceof ContainerData)) {
                    return child;
                }
                if (!(child instanceof ContainerData) || (result = this.findById(id, type, (childContainer = (ContainerData)child).getChildren())) == null) continue;
                return result;
            }
        }
        return null;
    }

    private List<String> buildPermission(List<PermissionEntity> permissions) {
        ArrayList<String> results = new ArrayList<String>();
        if (permissions != null) {
            for (PermissionEntity per : permissions) {
                results.add(per.getPermission());
            }
        }
        return results;
    }

    private ApplicationData buildWindow(WindowEntity windowEntity) {
        ApplicationType<Portlet> appType = MOPUtils.convertAppType(windowEntity.getAppType());
        if (appType == null) {
            return null;
        }
        PersistentApplicationState state = new PersistentApplicationState(String.valueOf(windowEntity.getId()));
        HashMap properties = new HashMap();
        JSONObject jProp = MOPUtils.parseJsonObject(windowEntity.getProperties());
        jProp.forEach((key, value) -> {
            if (key != null && value != null) {
                properties.put(key.toString(), value.toString());
            }
        });
        List<PermissionEntity> access = this.permissionDAO.getPermissions(WindowEntity.class.getName(), windowEntity.getId(), PermissionEntity.TYPE.ACCESS);
        JSONObject attrs = windowEntity.getProperties() == null ? null : MOPUtils.parseJsonObject(windowEntity.getProperties());
        ModelStyle cssStyle = null;
        String cssClass = null;
        if (attrs != null) {
            cssStyle = this.mapPropertiesToStyle(attrs);
            if (attrs.containsKey((Object)MappedAttributes.CSS_CLASS.getName())) {
                cssClass = (String)attrs.get((Object)MappedAttributes.CSS_CLASS.getName());
            }
        }
        return new ApplicationData(String.valueOf(windowEntity.getId()), null, appType, (ApplicationState)state, String.valueOf(windowEntity.getId()), windowEntity.getTitle(), windowEntity.getIcon(), windowEntity.getDescription(), windowEntity.isShowInfoBar(), windowEntity.isShowApplicationState(), windowEntity.isShowApplicationMode(), windowEntity.getTheme(), windowEntity.getWidth(), windowEntity.getHeight(), cssClass, cssStyle, properties, this.buildPermission(access));
    }

    private ContainerData buildContainer(ContainerEntity entity, JSONObject jsonComponent, JSONObject attrs, Map<Long, ContainerEntity> containers, Map<Long, WindowEntity> windows) {
        List<ComponentData> children = this.buildChildren((JSONArray)jsonComponent.get((Object)CHILDREN_PROP), containers, windows);
        List<PermissionEntity> access = this.permissionDAO.getPermissions(ContainerEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.ACCESS);
        List<PermissionEntity> moveApps = this.permissionDAO.getPermissions(ContainerEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.MOVE_APP);
        List<PermissionEntity> moveConts = this.permissionDAO.getPermissions(ContainerEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.MOVE_CONTAINER);
        String cssClass = null;
        String profiles = null;
        ModelStyle cssStyle = null;
        ApplicationBackgroundStyle appBackgroundStyle = null;
        if (attrs != null) {
            cssStyle = this.mapPropertiesToStyle(attrs);
            appBackgroundStyle = this.mapPropertiesToAppStyle(attrs);
            if (attrs.containsKey((Object)MappedAttributes.CSS_CLASS.getName())) {
                cssClass = (String)attrs.get((Object)MappedAttributes.CSS_CLASS.getName());
            }
            if (attrs.containsKey((Object)MappedAttributes.PROFILES.getName())) {
                profiles = (String)attrs.get((Object)MappedAttributes.PROFILES.getName());
            }
        }
        return new ContainerData(String.valueOf(entity.getId()), entity.getWebuiId(), entity.getName(), entity.getIcon(), entity.getTemplate(), entity.getFactoryId(), entity.getTitle(), entity.getDescription(), entity.getWidth(), entity.getHeight(), cssClass, profiles, cssStyle, appBackgroundStyle, this.buildPermission(access), this.buildPermission(moveApps), this.buildPermission(moveConts), children);
    }

    private List<ComponentData> buildChildren(JSONArray jsonBody, Map<Long, ContainerEntity> containers, Map<Long, WindowEntity> windows) {
        LinkedList<ComponentData> results = new LinkedList<ComponentData>();
        if (jsonBody != null) {
            for (Object component : jsonBody) {
                ContainerEntity srcContainer;
                JSONObject jsonComponent = (JSONObject)component;
                Long id = Safe.parseLong((String)jsonComponent.get((Object)ID_PROP).toString());
                ComponentEntity.TYPE type = ComponentEntity.TYPE.valueOf(jsonComponent.get((Object)TYPE_PROP).toString());
                if (type == ComponentEntity.TYPE.WINDOW) {
                    results.add((ComponentData)this.buildWindow(windows.get(id)));
                    continue;
                }
                if (type != ComponentEntity.TYPE.CONTAINER || (srcContainer = (ContainerEntity)this.containerDAO.find(id)) == null) continue;
                JSONObject attrs = MOPUtils.parseJsonObject(srcContainer.getProperties());
                String ctype = (String)attrs.get((Object)MappedAttributes.TYPE.getName());
                if (BodyType.PAGE.name().equals(ctype)) {
                    ModelStyle cssStyle = this.mapPropertiesToStyle(attrs);
                    BodyData body = new BodyData(String.valueOf(id), BodyType.PAGE, cssStyle);
                    results.add((ComponentData)body);
                    continue;
                }
                results.add((ComponentData)this.buildContainer(containers.get(id), jsonComponent, attrs, containers, windows));
            }
        }
        return results;
    }

    private List<ComponentEntity> saveChildren(List<ComponentData> children) {
        LinkedList<ComponentEntity> results = new LinkedList<ComponentEntity>();
        for (ComponentData srcChild : children) {
            Long srcChildId = Safe.parseLong((String)srcChild.getStorageId());
            ComponentEntity dstChild = null;
            if (srcChildId != null && srcChildId > 0L) {
                if (srcChild instanceof ContainerData) {
                    ContainerData containerData = (ContainerData)srcChild;
                    dstChild = (ComponentEntity)this.containerDAO.find(srcChildId);
                    if (dstChild != null) {
                        this.buildContainerEntity((ContainerEntity)dstChild, containerData);
                        this.containerDAO.update((ContainerEntity)dstChild);
                    }
                } else if (srcChild instanceof ApplicationData) {
                    ApplicationData appData = (ApplicationData)srcChild;
                    dstChild = this.findWindow(srcChildId);
                    if (dstChild != null) {
                        if ((dstChild = this.buildWindowEntity((WindowEntity)dstChild, appData)) == null) continue;
                        dstChild = this.updateWindow((WindowEntity)dstChild);
                    }
                } else if (srcChild instanceof BodyData) {
                    dstChild = (ComponentEntity)this.containerDAO.find(srcChildId);
                } else {
                    throw new StaleModelException("this layout component type is not supported: " + String.valueOf(srcChild));
                }
            }
            if (dstChild == null || dstChild.getId() == null) {
                if (srcChild instanceof ContainerData) {
                    ContainerData srcChildContainer = (ContainerData)srcChild;
                    dstChild = this.buildContainerEntity(null, srcChildContainer);
                    dstChild = (ComponentEntity)this.containerDAO.create((ContainerEntity)dstChild);
                } else if (srcChild instanceof ApplicationData) {
                    ApplicationData srcChildApplication = (ApplicationData)srcChild;
                    dstChild = this.buildWindowEntity(null, srcChildApplication);
                    if (dstChild == null) continue;
                    dstChild = this.createWindow((WindowEntity)dstChild);
                } else if (srcChild instanceof BodyData) {
                    BodyData srcChildBody = (BodyData)srcChild;
                    dstChild = this.buildContainerEntity(srcChildBody);
                    dstChild = (ComponentEntity)this.containerDAO.create((ContainerEntity)dstChild);
                } else {
                    throw new StaleModelException("Was not expecting child " + String.valueOf(srcChild));
                }
                if (dstChild.getId() == null) {
                    throw new IllegalStateException("Id of saved child wasn't found: " + String.valueOf((Object)dstChild.getType()) + " / " + String.valueOf(dstChild));
                }
            }
            this.savePermissions(dstChild.getId(), srcChild);
            if (srcChild instanceof ContainerData) {
                ContainerData srcChildContainer = (ContainerData)srcChild;
                List<ComponentEntity> descendants = this.saveChildren(srcChildContainer.getChildren());
                ((ContainerEntity)dstChild).setChildren(descendants);
            }
            results.add(dstChild);
        }
        return results;
    }

    private Map<Long, ContainerEntity> getContainerEntities(JSONArray jsonBody) {
        HashSet<Long> ids = new HashSet<Long>();
        this.filterBodyContainerIds(jsonBody, ComponentEntity.TYPE.CONTAINER, ids);
        List<ContainerEntity> entities = this.containerDAO.findByIds(new LinkedList<Long>(ids));
        HashMap<Long, ContainerEntity> results = new HashMap<Long, ContainerEntity>();
        for (ContainerEntity entity : entities) {
            results.put(entity.getId(), entity);
        }
        ids.removeAll(results.keySet());
        if (!ids.isEmpty()) {
            LOG.warn("Can't find Container with ids: {}", new Object[]{StringUtils.join(ids, (String)",")});
        }
        return results;
    }

    private ComponentEntity buildContainerEntity(BodyData bodyData) {
        ContainerEntity dst = new ContainerEntity();
        JSONObject properties = new JSONObject();
        properties.put((Object)MappedAttributes.TYPE.getName(), (Object)bodyData.getType().name());
        dst.setProperties(properties.toJSONString());
        return dst;
    }

    private Map<Long, WindowEntity> getWindowEntities(JSONArray jsonBody) {
        HashSet<Long> ids = new HashSet<Long>();
        this.filterBodyContainerIds(jsonBody, ComponentEntity.TYPE.WINDOW, ids);
        List<WindowEntity> entities = ids.stream().map(this::findWindow).filter(Objects::nonNull).toList();
        HashMap<Long, WindowEntity> results = new HashMap<Long, WindowEntity>();
        for (WindowEntity entity : entities) {
            results.put(entity.getId(), entity);
        }
        ids.removeAll(results.keySet());
        if (!ids.isEmpty()) {
            LOG.error("Can't find Window with ids: {}", new Object[]{StringUtils.join(ids, (String)",")});
        }
        return results;
    }

    private Set<Long> filterBodyContainerIds(JSONArray jsonBody, ComponentEntity.TYPE type, Set<Long> ids) {
        if (jsonBody != null) {
            for (Object obj : jsonBody) {
                JSONObject component = (JSONObject)obj;
                ComponentEntity.TYPE componentType = ComponentEntity.TYPE.valueOf(component.get((Object)TYPE_PROP).toString());
                if (componentType.equals((Object)type)) {
                    ids.add(Safe.parseLong((String)component.get((Object)ID_PROP).toString()));
                }
                if (!ComponentEntity.TYPE.CONTAINER.equals((Object)componentType)) continue;
                this.filterBodyContainerIds((JSONArray)component.get((Object)CHILDREN_PROP), type, ids);
            }
        }
        return ids;
    }

    private void savePermissions(Long id, ComponentData srcChild) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        List access = null;
        String typeName = srcChild.getClass().getName();
        if (srcChild instanceof ContainerData) {
            ContainerData srcChildContainer = (ContainerData)srcChild;
            typeName = ContainerEntity.class.getName();
            access = srcChildContainer.getAccessPermissions();
            this.savePermissions(typeName, id, PermissionEntity.TYPE.MOVE_APP, srcChildContainer.getMoveAppsPermissions());
            this.savePermissions(typeName, id, PermissionEntity.TYPE.MOVE_CONTAINER, srcChildContainer.getMoveContainersPermissions());
        } else if (srcChild instanceof ApplicationData) {
            ApplicationData srcChildApplication = (ApplicationData)srcChild;
            typeName = WindowEntity.class.getName();
            access = srcChildApplication.getAccessPermissions();
        }
        this.savePermissions(typeName, id, PermissionEntity.TYPE.ACCESS, access);
    }

    private ModelStyle mapPropertiesToStyle(JSONObject attrs) {
        ModelStyle cssStyle = new ModelStyle();
        if (attrs.containsKey((Object)MappedAttributes.BORDER_COLOR.getName())) {
            cssStyle.setBorderColor((String)attrs.get((Object)MappedAttributes.BORDER_COLOR.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.BACKGROUND_COLOR.getName())) {
            cssStyle.setBackgroundColor((String)attrs.get((Object)MappedAttributes.BACKGROUND_COLOR.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.BACKGROUND_IMAGE.getName())) {
            cssStyle.setBackgroundImage((String)attrs.get((Object)MappedAttributes.BACKGROUND_IMAGE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.BACKGROUND_EFFECT.getName())) {
            cssStyle.setBackgroundEffect((String)attrs.get((Object)MappedAttributes.BACKGROUND_EFFECT.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.BACKGROUND_POSITION.getName())) {
            cssStyle.setBackgroundPosition((String)attrs.get((Object)MappedAttributes.BACKGROUND_POSITION.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.BACKGROUND_SIZE.getName())) {
            cssStyle.setBackgroundSize((String)attrs.get((Object)MappedAttributes.BACKGROUND_SIZE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.BACKGROUND_REPEAT.getName())) {
            cssStyle.setBackgroundRepeat((String)attrs.get((Object)MappedAttributes.BACKGROUND_REPEAT.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.BORDER_SIZE.getName())) {
            cssStyle.setBorderSize((String)attrs.get((Object)MappedAttributes.BORDER_SIZE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.BOX_SHADOW.getName())) {
            cssStyle.setBoxShadow((String)attrs.get((Object)MappedAttributes.BOX_SHADOW.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.MARGIN_TOP.getName())) {
            cssStyle.setMarginTop(Integer.valueOf(Integer.parseInt((String)attrs.get((Object)MappedAttributes.MARGIN_TOP.getName()))));
        }
        if (attrs.containsKey((Object)MappedAttributes.MARGIN_BOTTOM.getName())) {
            cssStyle.setMarginBottom(Integer.valueOf(Integer.parseInt((String)attrs.get((Object)MappedAttributes.MARGIN_BOTTOM.getName()))));
        }
        if (attrs.containsKey((Object)MappedAttributes.MARGIN_RIGHT.getName())) {
            cssStyle.setMarginRight(Integer.valueOf(Integer.parseInt((String)attrs.get((Object)MappedAttributes.MARGIN_RIGHT.getName()))));
        }
        if (attrs.containsKey((Object)MappedAttributes.MARGIN_LEFT.getName())) {
            cssStyle.setMarginLeft(Integer.valueOf(Integer.parseInt((String)attrs.get((Object)MappedAttributes.MARGIN_LEFT.getName()))));
        }
        if (attrs.containsKey((Object)MappedAttributes.RADIUS_TOP_RIGHT_SHADOW.getName())) {
            cssStyle.setRadiusTopRight(Integer.valueOf(Integer.parseInt((String)attrs.get((Object)MappedAttributes.RADIUS_TOP_RIGHT_SHADOW.getName()))));
        }
        if (attrs.containsKey((Object)MappedAttributes.RADIUS_TOP_LEFT_SHADOW.getName())) {
            cssStyle.setRadiusTopLeft(Integer.valueOf(Integer.parseInt((String)attrs.get((Object)MappedAttributes.RADIUS_TOP_LEFT_SHADOW.getName()))));
        }
        if (attrs.containsKey((Object)MappedAttributes.RADIUS_BOTTOM_RIGHT_SHADOW.getName())) {
            cssStyle.setRadiusBottomRight(Integer.valueOf(Integer.parseInt((String)attrs.get((Object)MappedAttributes.RADIUS_BOTTOM_RIGHT_SHADOW.getName()))));
        }
        if (attrs.containsKey((Object)MappedAttributes.RADIUS_BOTTOM_LEFT_SHADOW.getName())) {
            cssStyle.setRadiusBottomLeft(Integer.valueOf(Integer.parseInt((String)attrs.get((Object)MappedAttributes.RADIUS_BOTTOM_LEFT_SHADOW.getName()))));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_TITLE_COLOR.getName())) {
            cssStyle.setTextTitleColor((String)attrs.get((Object)MappedAttributes.TEXT_TITLE_COLOR.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_TITLE_FONT_SIZE.getName())) {
            cssStyle.setTextTitleFontSize((String)attrs.get((Object)MappedAttributes.TEXT_TITLE_FONT_SIZE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_TITLE_FONT_WEIGHT.getName())) {
            cssStyle.setTextTitleFontWeight((String)attrs.get((Object)MappedAttributes.TEXT_TITLE_FONT_WEIGHT.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_TITLE_FONT_STYLE.getName())) {
            cssStyle.setTextTitleFontStyle((String)attrs.get((Object)MappedAttributes.TEXT_TITLE_FONT_STYLE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_HEADER_COLOR.getName())) {
            cssStyle.setTextHeaderColor((String)attrs.get((Object)MappedAttributes.TEXT_HEADER_COLOR.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_HEADER_FONT_SIZE.getName())) {
            cssStyle.setTextHeaderFontSize((String)attrs.get((Object)MappedAttributes.TEXT_HEADER_FONT_SIZE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_HEADER_FONT_WEIGHT.getName())) {
            cssStyle.setTextHeaderFontWeight((String)attrs.get((Object)MappedAttributes.TEXT_HEADER_FONT_WEIGHT.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_HEADER_FONT_STYLE.getName())) {
            cssStyle.setTextHeaderFontStyle((String)attrs.get((Object)MappedAttributes.TEXT_HEADER_FONT_STYLE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_COLOR.getName())) {
            cssStyle.setTextColor((String)attrs.get((Object)MappedAttributes.TEXT_COLOR.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_FONT_SIZE.getName())) {
            cssStyle.setTextFontSize((String)attrs.get((Object)MappedAttributes.TEXT_FONT_SIZE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_FONT_WEIGHT.getName())) {
            cssStyle.setTextFontWeight((String)attrs.get((Object)MappedAttributes.TEXT_FONT_WEIGHT.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_FONT_STYLE.getName())) {
            cssStyle.setTextFontStyle((String)attrs.get((Object)MappedAttributes.TEXT_FONT_STYLE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_SUBTITLE_COLOR.getName())) {
            cssStyle.setTextSubtitleColor((String)attrs.get((Object)MappedAttributes.TEXT_SUBTITLE_COLOR.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_SUBTITLE_FONT_SIZE.getName())) {
            cssStyle.setTextSubtitleFontSize((String)attrs.get((Object)MappedAttributes.TEXT_SUBTITLE_FONT_SIZE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_SUBTITLE_FONT_WEIGHT.getName())) {
            cssStyle.setTextSubtitleFontWeight((String)attrs.get((Object)MappedAttributes.TEXT_SUBTITLE_FONT_WEIGHT.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.TEXT_SUBTITLE_FONT_STYLE.getName())) {
            cssStyle.setTextSubtitleFontStyle((String)attrs.get((Object)MappedAttributes.TEXT_SUBTITLE_FONT_STYLE.getName()));
        }
        return cssStyle;
    }

    private ApplicationBackgroundStyle mapPropertiesToAppStyle(JSONObject attrs) {
        ApplicationBackgroundStyle cssStyle = new ApplicationBackgroundStyle();
        if (attrs.containsKey((Object)MappedAttributes.APP_BACKGROUND_COLOR.getName())) {
            cssStyle.setBackgroundColor((String)attrs.get((Object)MappedAttributes.APP_BACKGROUND_COLOR.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.APP_BACKGROUND_IMAGE.getName())) {
            cssStyle.setBackgroundImage((String)attrs.get((Object)MappedAttributes.APP_BACKGROUND_IMAGE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.APP_BACKGROUND_EFFECT.getName())) {
            cssStyle.setBackgroundEffect((String)attrs.get((Object)MappedAttributes.APP_BACKGROUND_EFFECT.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.APP_BACKGROUND_POSITION.getName())) {
            cssStyle.setBackgroundPosition((String)attrs.get((Object)MappedAttributes.APP_BACKGROUND_POSITION.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.APP_BACKGROUND_SIZE.getName())) {
            cssStyle.setBackgroundSize((String)attrs.get((Object)MappedAttributes.APP_BACKGROUND_SIZE.getName()));
        }
        if (attrs.containsKey((Object)MappedAttributes.APP_BACKGROUND_REPEAT.getName())) {
            cssStyle.setBackgroundRepeat((String)attrs.get((Object)MappedAttributes.APP_BACKGROUND_REPEAT.getName()));
        }
        return cssStyle;
    }

    private void mapStyleToProperties(ModelStyle cssStyle, JSONObject properties) {
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBorderColor())) {
            properties.put((Object)MappedAttributes.BORDER_COLOR.getName(), (Object)cssStyle.getBorderColor());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundColor())) {
            properties.put((Object)MappedAttributes.BACKGROUND_COLOR.getName(), (Object)cssStyle.getBackgroundColor());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundImage())) {
            properties.put((Object)MappedAttributes.BACKGROUND_IMAGE.getName(), (Object)cssStyle.getBackgroundImage());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundEffect())) {
            properties.put((Object)MappedAttributes.BACKGROUND_EFFECT.getName(), (Object)cssStyle.getBackgroundEffect());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundPosition())) {
            properties.put((Object)MappedAttributes.BACKGROUND_POSITION.getName(), (Object)cssStyle.getBackgroundPosition());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundSize())) {
            properties.put((Object)MappedAttributes.BACKGROUND_SIZE.getName(), (Object)cssStyle.getBackgroundSize());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundRepeat())) {
            properties.put((Object)MappedAttributes.BACKGROUND_REPEAT.getName(), (Object)cssStyle.getBackgroundRepeat());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBorderSize())) {
            properties.put((Object)MappedAttributes.BORDER_SIZE.getName(), (Object)cssStyle.getBorderSize());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBoxShadow())) {
            properties.put((Object)MappedAttributes.BOX_SHADOW.getName(), (Object)cssStyle.getBoxShadow());
        }
        if (cssStyle.getMarginTop() != null) {
            properties.put((Object)MappedAttributes.MARGIN_TOP.getName(), (Object)cssStyle.getMarginTop().toString());
        }
        if (cssStyle.getMarginBottom() != null) {
            properties.put((Object)MappedAttributes.MARGIN_BOTTOM.getName(), (Object)cssStyle.getMarginBottom().toString());
        }
        if (cssStyle.getMarginRight() != null) {
            properties.put((Object)MappedAttributes.MARGIN_RIGHT.getName(), (Object)cssStyle.getMarginRight().toString());
        }
        if (cssStyle.getMarginLeft() != null) {
            properties.put((Object)MappedAttributes.MARGIN_LEFT.getName(), (Object)cssStyle.getMarginLeft().toString());
        }
        if (cssStyle.getRadiusTopRight() != null) {
            properties.put((Object)MappedAttributes.RADIUS_TOP_RIGHT_SHADOW.getName(), (Object)cssStyle.getRadiusTopRight().toString());
        }
        if (cssStyle.getRadiusTopLeft() != null) {
            properties.put((Object)MappedAttributes.RADIUS_TOP_LEFT_SHADOW.getName(), (Object)cssStyle.getRadiusTopLeft().toString());
        }
        if (cssStyle.getRadiusBottomRight() != null) {
            properties.put((Object)MappedAttributes.RADIUS_BOTTOM_RIGHT_SHADOW.getName(), (Object)cssStyle.getRadiusBottomRight().toString());
        }
        if (cssStyle.getRadiusBottomLeft() != null) {
            properties.put((Object)MappedAttributes.RADIUS_BOTTOM_LEFT_SHADOW.getName(), (Object)cssStyle.getRadiusBottomLeft().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextTitleColor())) {
            properties.put((Object)MappedAttributes.TEXT_TITLE_COLOR.getName(), (Object)cssStyle.getTextTitleColor());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextTitleFontSize())) {
            properties.put((Object)MappedAttributes.TEXT_TITLE_FONT_SIZE.getName(), (Object)cssStyle.getTextTitleFontSize());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextTitleFontWeight())) {
            properties.put((Object)MappedAttributes.TEXT_TITLE_FONT_WEIGHT.getName(), (Object)cssStyle.getTextTitleFontWeight());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextTitleFontStyle())) {
            properties.put((Object)MappedAttributes.TEXT_TITLE_FONT_STYLE.getName(), (Object)cssStyle.getTextTitleFontStyle());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextHeaderColor())) {
            properties.put((Object)MappedAttributes.TEXT_HEADER_COLOR.getName(), (Object)cssStyle.getTextHeaderColor());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextHeaderFontSize())) {
            properties.put((Object)MappedAttributes.TEXT_HEADER_FONT_SIZE.getName(), (Object)cssStyle.getTextHeaderFontSize());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextHeaderFontWeight())) {
            properties.put((Object)MappedAttributes.TEXT_HEADER_FONT_WEIGHT.getName(), (Object)cssStyle.getTextHeaderFontWeight());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextHeaderFontStyle())) {
            properties.put((Object)MappedAttributes.TEXT_HEADER_FONT_STYLE.getName(), (Object)cssStyle.getTextHeaderFontStyle());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextColor())) {
            properties.put((Object)MappedAttributes.TEXT_COLOR.getName(), (Object)cssStyle.getTextColor());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextFontSize())) {
            properties.put((Object)MappedAttributes.TEXT_FONT_SIZE.getName(), (Object)cssStyle.getTextFontSize());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextFontWeight())) {
            properties.put((Object)MappedAttributes.TEXT_FONT_WEIGHT.getName(), (Object)cssStyle.getTextFontWeight());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextFontStyle())) {
            properties.put((Object)MappedAttributes.TEXT_FONT_STYLE.getName(), (Object)cssStyle.getTextFontStyle());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextSubtitleColor())) {
            properties.put((Object)MappedAttributes.TEXT_SUBTITLE_COLOR.getName(), (Object)cssStyle.getTextSubtitleColor());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextSubtitleFontSize())) {
            properties.put((Object)MappedAttributes.TEXT_SUBTITLE_FONT_SIZE.getName(), (Object)cssStyle.getTextSubtitleFontSize());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextSubtitleFontWeight())) {
            properties.put((Object)MappedAttributes.TEXT_SUBTITLE_FONT_WEIGHT.getName(), (Object)cssStyle.getTextSubtitleFontWeight());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getTextSubtitleFontStyle())) {
            properties.put((Object)MappedAttributes.TEXT_SUBTITLE_FONT_STYLE.getName(), (Object)cssStyle.getTextSubtitleFontStyle());
        }
    }

    private void mapAppStyleToProperties(ApplicationBackgroundStyle cssStyle, JSONObject properties) {
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundColor())) {
            properties.put((Object)MappedAttributes.APP_BACKGROUND_COLOR.getName(), (Object)cssStyle.getBackgroundColor());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundImage())) {
            properties.put((Object)MappedAttributes.APP_BACKGROUND_IMAGE.getName(), (Object)cssStyle.getBackgroundImage());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundEffect())) {
            properties.put((Object)MappedAttributes.APP_BACKGROUND_EFFECT.getName(), (Object)cssStyle.getBackgroundEffect());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundPosition())) {
            properties.put((Object)MappedAttributes.APP_BACKGROUND_POSITION.getName(), (Object)cssStyle.getBackgroundPosition());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundSize())) {
            properties.put((Object)MappedAttributes.APP_BACKGROUND_SIZE.getName(), (Object)cssStyle.getBackgroundSize());
        }
        if (StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundRepeat())) {
            properties.put((Object)MappedAttributes.APP_BACKGROUND_REPEAT.getName(), (Object)cssStyle.getBackgroundRepeat());
        }
    }
}

