/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.cached;

import io.meeds.gamification.dao.RealizationDAO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RealizationStorage;
import io.meeds.gamification.storage.RuleStorage;
import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class RealizationCachedStorage
extends RealizationStorage {
    private static final String REALIZATION_CACHE_NAME = "gamification.realization";
    private FutureExoCache<Long, Long, Object> realizationFutureCache;

    public RealizationCachedStorage(ProgramStorage programStorage, RuleStorage ruleStorage, RealizationDAO gamificationHistoryDAO, CacheService cacheService) {
        super(programStorage, ruleStorage, gamificationHistoryDAO);
        ExoCache realizationCache = cacheService.getCacheInstance(REALIZATION_CACHE_NAME);
        Loader<Long, Long, Object> realizationLoader = new Loader<Long, Long, Object>(){

            public Long retrieve(Object context, Long identityId) throws Exception {
                return RealizationCachedStorage.super.getScoreByIdentityId(identityId.toString());
            }
        };
        this.realizationFutureCache = new FutureExoCache((Loader)realizationLoader, realizationCache);
    }

    @Override
    public long getScoreByIdentityId(String earnerIdentityId) {
        return (Long)this.realizationFutureCache.get(null, (Object)Long.parseLong(earnerIdentityId));
    }

    @Override
    public RealizationDTO updateRealization(RealizationDTO realization) {
        if ((realization = super.updateRealization(realization)) != null) {
            this.realizationFutureCache.remove((Serializable)Long.valueOf(Long.parseLong(realization.getEarnerId())));
        }
        return realization;
    }

    @Override
    public RealizationDTO createRealization(RealizationDTO realization) {
        if ((realization = super.createRealization(realization)) != null) {
            this.realizationFutureCache.remove((Serializable)Long.valueOf(Long.parseLong(realization.getEarnerId())));
        }
        return realization;
    }
}

