/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd;

import java.util.Collection;
import java.util.Set;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerChannelImpl;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class ContinuationService {
    private final EXoContinuationBayeux bayeux;

    public ContinuationService(EXoContinuationBayeux bayeux) {
        this.bayeux = bayeux;
    }

    public void sendMessage(String eXoId, String channel, Object data) {
        this.sendMessage(eXoId, channel, data, null);
    }

    public void sendMessage(String eXoId, String channel, Object data, String id) {
        this.bayeux.sendMessage(eXoId, channel, data, id);
    }

    public ServerSession getClientByExoId(String exoId) {
        return this.bayeux.getClientByEXoId(exoId);
    }

    public ServerSession getClient(String id) {
        return this.bayeux.getSession(id);
    }

    public Collection<ServerSession> getClients() {
        return this.bayeux.getSessions();
    }

    public boolean hasChannel(String channel) {
        return this.bayeux.getChannel(channel) != null;
    }

    public long getTimeout() {
        return this.bayeux.getTimeout();
    }

    @Deprecated
    public boolean isSubscribe(String eXoId, String channel) {
        ServerChannelImpl channelImpl = (ServerChannelImpl)this.bayeux.getChannel(channel);
        Set collection = channelImpl.getSubscribers();
        for (ServerSession client : collection) {
            if (!this.bayeux.isSubscribed(eXoId, client.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isPresent(String eXoID) {
        return this.bayeux.isPresent(eXoID);
    }

    public void sendBroadcastMessage(String channel, Object data) {
        this.sendBroadcastMessage(channel, data, null);
    }

    public void sendBroadcastMessage(String channel, Object data, String msgId) {
        this.bayeux.sendBroadcastMessage(channel, data, msgId);
    }

    public String getUserToken(String eXoId) {
        return this.bayeux.getUserToken(eXoId);
    }
}

