/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.model.ApplicationBackgroundStyle;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.ModelData;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class Container
extends ModelObject
implements Cloneable,
IUnmarshallable,
IMarshallable {
    public static final String EVERYONE = "Everyone";
    public static final List<String> DEFAULT_ACCESS_PERMISSIONS = Collections.singletonList("Everyone");
    public static final List<String> DEFAULT_MOVE_APPLICATIONS_PERMISSIONS = Collections.singletonList("Everyone");
    public static final List<String> DEFAULT_MOVE_CONTAINERS_PERMISSIONS = Collections.singletonList("Everyone");
    protected String id;
    protected String name;
    protected String icon;
    protected String template;
    protected String factoryId;
    protected String title;
    protected String description;
    protected String profiles;
    protected String[] accessPermissions;
    protected String[] moveAppsPermissions;
    protected String[] moveContainersPermissions;
    protected ArrayList<ModelObject> children;
    protected ApplicationBackgroundStyle appBackgroundStyle;
    public static final String JiBX_bindingList = "|org.exoplatform.portal.config.model.JiBX_bindingFactory|";

    public Container() {
        this.setDefaultPermissions();
        this.children = new ArrayList();
    }

    public Container(String storageId) {
        super(storageId);
        this.setDefaultPermissions();
        this.children = new ArrayList();
    }

    public Container(ContainerData data) {
        super(data.getStorageId());
        this.id = data.getId();
        this.name = data.getName();
        this.icon = data.getIcon();
        this.template = data.getTemplate();
        this.factoryId = data.getFactoryId();
        this.title = data.getTitle();
        this.description = data.getDescription();
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.cssClass = data.getCssClass();
        this.cssStyle = data.getCssStyle();
        this.appBackgroundStyle = data.getAppBackgroundStyle();
        this.profiles = data.getProfiles();
        this.accessPermissions = data.getAccessPermissions().toArray(new String[data.getAccessPermissions().size()]);
        List<String> permisssions = data.getMoveAppsPermissions();
        this.moveAppsPermissions = permisssions != null ? permisssions.toArray(new String[permisssions.size()]) : null;
        permisssions = data.getMoveContainersPermissions();
        this.moveContainersPermissions = permisssions != null ? permisssions.toArray(new String[permisssions.size()]) : null;
        this.children = new ArrayList();
        for (ComponentData child : data.getChildren()) {
            ModelObject m = ModelObject.build(child);
            if (m == null) continue;
            this.children.add(ModelObject.build(child));
        }
    }

    private void setDefaultPermissions() {
        List<String> permissions = DEFAULT_MOVE_APPLICATIONS_PERMISSIONS;
        this.moveAppsPermissions = permissions.toArray(new String[permissions.size()]);
        permissions = DEFAULT_MOVE_CONTAINERS_PERMISSIONS;
        this.moveContainersPermissions = permissions.toArray(new String[permissions.size()]);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public ArrayList<ModelObject> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<ModelObject> children) {
        this.children = children;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public void setFactoryId(String factoryId) {
        this.factoryId = factoryId;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(String[] accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public String[] getMoveAppsPermissions() {
        return this.moveAppsPermissions;
    }

    public void setMoveAppsPermissions(String[] moveAppsPermissions) {
        this.moveAppsPermissions = moveAppsPermissions;
    }

    public String[] getMoveContainersPermissions() {
        return this.moveContainersPermissions;
    }

    public void setMoveContainersPermissions(String[] moveContainersPermissions) {
        this.moveContainersPermissions = moveContainersPermissions;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    @Override
    public ContainerData build() {
        return new ContainerData(this.getStorageId(), this.getId(), this.getName(), this.getIcon(), this.getTemplate(), this.getFactoryId(), this.getTitle(), this.getDescription(), this.getWidth(), this.getHeight(), this.getCssClass(), this.getProfiles(), this.getCssStyle(), this.getAppBackgroundStyle(), Utils.safeImmutableList(this.accessPermissions), Utils.safeImmutableList(this.moveAppsPermissions), Utils.safeImmutableList(this.moveContainersPermissions), this.buildChildren());
    }

    @Override
    public void checkStorage() throws ObjectNotFoundException {
        super.checkStorage();
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            for (ModelObject child : this.getChildren()) {
                child.checkStorage();
            }
        }
    }

    @Override
    public void resetStorage() throws ObjectNotFoundException {
        super.resetStorage();
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            for (ModelObject child : this.getChildren()) {
                child.resetStorage();
            }
        }
    }

    public Container clone() {
        return new Container(this.build());
    }

    protected List<ComponentData> buildChildren() {
        if (StringUtils.isNotBlank((CharSequence)this.getProfiles())) {
            Set activeProfiles = Tools.parseCommaList((String)this.getProfiles());
            if (ExoContainer.getProfiles().stream().noneMatch(activeProfiles::contains)) {
                return Collections.emptyList();
            }
        }
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            ArrayList<ComponentData> dataChildren = new ArrayList<ComponentData>();
            for (int i = 0; i < this.children.size(); ++i) {
                Container container;
                String nodeProfiles;
                ModelObject node = this.children.get(i);
                if (node instanceof Container && StringUtils.isNotBlank((CharSequence)(nodeProfiles = (container = (Container)node).getProfiles()))) {
                    Set activeProfiles = Tools.parseCommaList((String)nodeProfiles);
                    if (ExoContainer.getProfiles().stream().noneMatch(activeProfiles::contains)) continue;
                }
                ModelData data = node.build();
                ComponentData componentData = (ComponentData)data;
                dataChildren.add(componentData);
            }
            return Collections.unmodifiableList(dataChildren);
        }
        return Collections.emptyList();
    }

    public ApplicationBackgroundStyle getAppBackgroundStyle() {
        return this.appBackgroundStyle;
    }

    public void setAppBackgroundStyle(ApplicationBackgroundStyle appBackgroundStyle) {
        this.appBackgroundStyle = appBackgroundStyle;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.Container").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.portal.config.model.Container";
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.portal.config.model.Container").marshal((Object)this, arg1);
    }
}

