/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.github.gamification.storage;

import io.meeds.github.gamification.exception.GithubConnectionException;
import io.meeds.github.gamification.model.RemoteOrganization;
import io.meeds.github.gamification.model.RemoteRepository;
import io.meeds.github.gamification.model.TokenStatus;
import io.meeds.github.gamification.model.WebHook;
import io.meeds.github.gamification.storage.GithubConsumerStorage$AjcClosure1;
import io.meeds.github.gamification.storage.GithubConsumerStorage$AjcClosure3;
import io.meeds.github.gamification.storage.GithubConsumerStorage$AjcClosure5;
import io.meeds.github.gamification.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.json.JSONObject;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.aspectj.AnnotationCacheAspect;
import org.springframework.stereotype.Repository;

@Repository
public class GithubConsumerStorage {
    private HttpClient client;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public WebHook createWebhook(String organizationName, String[] triggers, String accessToken) throws IllegalAccessException {
        String secret = Utils.generateRandomSecret(8);
        JSONObject config = new JSONObject();
        JSONObject hook = new JSONObject();
        String url = "https://api.github.com/orgs/" + organizationName + "/hooks";
        config.put("url", (Object)(CommonsUtils.getCurrentDomain() + "/gamification-github/rest/webhooks"));
        config.put("content_type", (Object)"json");
        config.put("insecure_ssl", (Object)"0");
        config.put("secret", (Object)secret);
        hook.put("name", (Object)"web");
        hook.put("active", true);
        hook.put("config", (Object)config);
        hook.put("events", (Object)triggers);
        URI uri = URI.create(url);
        try {
            String response = this.processPost(uri, hook.toString(), accessToken);
            if (response != null) {
                Map<String, Object> resultMap = Utils.fromJsonStringToMap(response);
                long hookId = Long.parseLong(resultMap.get("id").toString());
                List events = (List)resultMap.get("events");
                WebHook webHook = new WebHook();
                webHook.setWebhookId(hookId);
                webHook.setOrganizationName(organizationName);
                webHook.setTriggers(events);
                webHook.setToken(accessToken);
                webHook.setSecret(secret);
                return webHook;
            }
            throw new IllegalAccessException("github.unauthorizedOperation");
        }
        catch (GithubConnectionException e) {
            throw new IllegalStateException("Unable to open GitHub connection", e);
        }
    }

    public String deleteWebhookHook(WebHook webHook) {
        URI uri = URI.create("https://api.github.com/orgs/" + webHook.getOrganizationId() + "/hooks/" + webHook.getWebhookId());
        try {
            return this.processDelete(uri, webHook.getToken());
        }
        catch (GithubConnectionException e) {
            throw new IllegalStateException("Unable to delete GitHub hook");
        }
    }

    @Cacheable(value={"gamification.github.organizationRepos"})
    public List<RemoteRepository> retrieveOrganizationRepos(String organization, String accessToken, int page, int perPage, String keyword) {
        String string = organization;
        String string2 = accessToken;
        int n = page;
        int n2 = perPage;
        String string3 = keyword;
        Object[] objectArray = new Object[]{string, string2, Conversions.intObject((int)n), Conversions.intObject((int)n2), string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, Conversions.intObject((int)n), Conversions.intObject((int)n2), string3, joinPoint};
        return (List)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new GithubConsumerStorage$AjcClosure1(objectArray2), joinPoint);
    }

    public RemoteOrganization retrieveRemoteOrganization(String organizationName, String accessToken) throws ObjectNotFoundException {
        String response;
        URI uri = URI.create("https://api.github.com/orgs/" + organizationName);
        try {
            response = this.processGet(uri, accessToken);
        }
        catch (GithubConnectionException e) {
            throw new IllegalStateException("Unable to retrieve GitHub organization info.", e);
        }
        if (response == null) {
            throw new ObjectNotFoundException("github.organizationNotFound");
        }
        Map<String, Object> resultMap = Utils.fromJsonStringToMap(response);
        RemoteOrganization gitHubOrganization = new RemoteOrganization();
        gitHubOrganization.setId(Long.parseLong(resultMap.get("id").toString()));
        gitHubOrganization.setName(resultMap.get("login").toString());
        gitHubOrganization.setTitle(resultMap.get("name") != null ? resultMap.get("name").toString() : resultMap.get("login").toString());
        gitHubOrganization.setDescription(resultMap.get("description") != null ? resultMap.get("description").toString() : "");
        gitHubOrganization.setAvatarUrl(resultMap.get("avatar_url").toString());
        return gitHubOrganization;
    }

    @Cacheable(value={"gamification.github.remoteOrganization"})
    public RemoteOrganization retrieveRemoteOrganization(long organizationId, String accessToken) {
        long l = organizationId;
        String string = accessToken;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)string);
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), string, joinPoint};
        return (RemoteOrganization)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new GithubConsumerStorage$AjcClosure3(objectArray), joinPoint);
    }

    @Cacheable(value={"gamification.github.tokenStatus"})
    public TokenStatus checkGitHubTokenStatus(String token) {
        String string = token;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (TokenStatus)AnnotationCacheAspect.aspectOf().ajc$around$org_springframework_cache_aspectj_AbstractCacheAspect$1$2bc714b5((Object)this, (AroundClosure)new GithubConsumerStorage$AjcClosure5(objectArray), joinPoint);
    }

    public String forceUpdateWebhook(WebHook webHook) {
        long organizationId = webHook.getOrganizationId();
        URI uri = URI.create("https://api.github.com/orgs/" + organizationId + "/hooks/" + webHook.getWebhookId());
        try {
            return this.processGet(uri, webHook.getToken());
        }
        catch (GithubConnectionException e) {
            throw new IllegalStateException("Unable to retrieve GitHub webhook info.", e);
        }
    }

    private String processGet(URI uri, String accessToken) throws GithubConnectionException {
        HttpClient httpClient = this.getHttpClient();
        HttpGet request = new HttpGet(uri);
        try {
            request.setHeader("Authorization", "token " + accessToken);
            return this.processRequest(httpClient, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new GithubConnectionException("github.connectionError", e);
        }
    }

    private String processPost(URI uri, String jsonString, String accessToken) throws GithubConnectionException {
        HttpClient httpClient = this.getHttpClient();
        HttpPost request = new HttpPost(uri);
        StringEntity entity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
        try {
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Authorization", "token " + accessToken);
            request.setEntity((HttpEntity)entity);
            return this.processRequest(httpClient, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new GithubConnectionException("github.connectionError", e);
        }
    }

    private String processDelete(URI uri, String accessToken) throws GithubConnectionException {
        HttpClient httpClient = this.getHttpClient();
        HttpDelete request = new HttpDelete(uri);
        try {
            request.setHeader("Authorization", "token " + accessToken);
            return this.processRequest(httpClient, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new GithubConnectionException("github.connectionError", e);
        }
    }

    private String processRequest(HttpClient httpClient, HttpRequestBase request) throws IOException, GithubConnectionException {
        boolean isSuccess;
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        boolean bl = isSuccess = response != null && response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300;
        if (isSuccess) {
            return this.processSuccessResponse(response);
        }
        if (response != null && response.getStatusLine().getStatusCode() == 404) {
            return null;
        }
        this.processErrorResponse(response);
        return null;
    }

    private String processSuccessResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 204) {
            return String.valueOf(204);
        }
        if ((response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 200) && response.getEntity() != null && response.getEntity().getContentLength() != 0L) {
            try (InputStream is = response.getEntity().getContent();){
                String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        return null;
    }

    private void processErrorResponse(HttpResponse response) throws GithubConnectionException, IOException {
        if (response == null) {
            throw new GithubConnectionException("Error when connecting github");
        }
        if (response.getEntity() != null) {
            InputStream is = response.getEntity().getContent();
            try {
                String errorMessage = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"")) {
                    throw new GithubConnectionException(errorMessage);
                }
                throw new GithubConnectionException("github.connectionError" + errorMessage);
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        throw new GithubConnectionException("github.connectionError" + response.getStatusLine().getStatusCode());
    }

    private HttpClient getHttpClient() {
        if (this.client == null) {
            HttpClientConnectionManager clientConnectionManager = this.getClientConnectionManager();
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(clientConnectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
            this.client = httpClientBuilder.build();
        }
        return this.client;
    }

    private HttpClientConnectionManager getClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(10);
        return connectionManager;
    }

    static {
        GithubConsumerStorage.ajc$preClinit();
    }

    static /* synthetic */ List retrieveOrganizationRepos_aroundBody0(GithubConsumerStorage ajc$this, String organization, String accessToken, int page, int perPage, String keyword, JoinPoint joinPoint) {
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        String url = "https://api.github.com/orgs/" + organization + "/repos?per_page=" + perPage + "&page=" + page;
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            url = "https://api.github.com/search/repositories?q=" + keyword + "+org:" + organization + "&per_page=" + perPage + "&page=" + page;
        }
        URI uri = URI.create(url);
        try {
            String response = ajc$this.processGet(uri, accessToken);
            if (response != null) {
                List repoList;
                if (StringUtils.isNotBlank((CharSequence)keyword)) {
                    Map<String, Object> responseMap = Utils.fromJsonStringToMap(response);
                    repoList = (List)responseMap.get("items");
                } else {
                    Map<String, Object>[] repositoryMaps = Utils.fromJsonStringToMapCollection(response);
                    repoList = Arrays.asList(repositoryMaps);
                }
                for (Map repo : repoList) {
                    RemoteRepository remoteRepository = new RemoteRepository();
                    long repoId = Long.parseLong(repo.get("id").toString());
                    String name = (String)repo.get("name");
                    String description = (String)repo.get("description");
                    remoteRepository.setId(repoId);
                    remoteRepository.setName(name);
                    remoteRepository.setDescription(description);
                    remoteRepositories.add(remoteRepository);
                }
                return remoteRepositories;
            }
        }
        catch (GithubConnectionException e) {
            throw new IllegalStateException("Unable to retrieve GitHub organization repos.");
        }
        return remoteRepositories;
    }

    static /* synthetic */ RemoteOrganization retrieveRemoteOrganization_aroundBody2(GithubConsumerStorage ajc$this, long organizationId, String accessToken, JoinPoint joinPoint) {
        String response;
        URI uri = URI.create("https://api.github.com/orgs/" + organizationId);
        try {
            response = ajc$this.processGet(uri, accessToken);
        }
        catch (GithubConnectionException e) {
            throw new IllegalStateException("Unable to retrieve GitHub organization info.", e);
        }
        Map<String, Object> resultMap = Utils.fromJsonStringToMap(response);
        RemoteOrganization gitHubOrganization = new RemoteOrganization();
        gitHubOrganization.setId(Long.parseLong(resultMap.get("id").toString()));
        gitHubOrganization.setName(resultMap.get("login").toString());
        gitHubOrganization.setTitle(resultMap.get("name") != null ? resultMap.get("name").toString() : resultMap.get("login").toString());
        gitHubOrganization.setDescription(resultMap.get("description") != null ? resultMap.get("description").toString() : "");
        gitHubOrganization.setAvatarUrl(resultMap.get("avatar_url").toString());
        return gitHubOrganization;
    }

    static /* synthetic */ TokenStatus checkGitHubTokenStatus_aroundBody4(GithubConsumerStorage ajc$this, String token, JoinPoint joinPoint) {
        URI uri = URI.create("https://api.github.com/rate_limit");
        HttpClient httpClient = ajc$this.getHttpClient();
        HttpGet request = new HttpGet(uri);
        request.setHeader("Authorization", "token " + token);
        try {
            boolean isSuccess;
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            boolean bl = isSuccess = httpResponse != null && httpResponse.getStatusLine().getStatusCode() >= 200 && httpResponse.getStatusLine().getStatusCode() < 300;
            if (isSuccess) {
                String response = ajc$this.processSuccessResponse(httpResponse);
                Map<String, Object> resultMap = Utils.fromJsonStringToMap(response);
                String remaining = Utils.extractSubItem(resultMap, "resources", "core", "remaining");
                String reset = Utils.extractSubItem(resultMap, "resources", "core", "reset");
                TokenStatus tokenStatus = new TokenStatus();
                tokenStatus.setValid(true);
                if (StringUtils.isNotBlank((CharSequence)remaining)) {
                    tokenStatus.setRemaining(Long.parseLong(remaining));
                }
                if (StringUtils.isNotBlank((CharSequence)reset)) {
                    tokenStatus.setReset(Long.parseLong(reset));
                }
                return tokenStatus;
            }
            if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 401) {
                return new TokenStatus(false, null, null);
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to retrieve personal access token status", e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GithubConsumerStorage.java", GithubConsumerStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "retrieveOrganizationRepos", "io.meeds.github.gamification.storage.GithubConsumerStorage", "java.lang.String:java.lang.String:int:int:java.lang.String", "organization:accessToken:page:perPage:keyword", "", "java.util.List"), 98);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "retrieveRemoteOrganization", "io.meeds.github.gamification.storage.GithubConsumerStorage", "long:java.lang.String", "organizationId:accessToken", "", "io.meeds.github.gamification.model.RemoteOrganization"), 158);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkGitHubTokenStatus", "io.meeds.github.gamification.storage.GithubConsumerStorage", "java.lang.String", "token", "", "io.meeds.github.gamification.model.TokenStatus"), 177);
    }
}

