/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.Ordered;

public class KotlinBeanInfoFactory
implements BeanInfoFactory,
Ordered {
    public BeanInfo getBeanInfo(final Class<?> beanClass) throws IntrospectionException {
        if (beanClass.isInterface() || beanClass.isEnum()) {
            return null;
        }
        if (!KotlinDetector.isKotlinReflectPresent() || !KotlinDetector.isKotlinType(beanClass)) {
            return null;
        }
        KClass kotlinClass = JvmClassMappingKt.getKotlinClass(beanClass);
        final LinkedHashSet<PropertyDescriptor> pds = new LinkedHashSet<PropertyDescriptor>();
        for (KCallable member : kotlinClass.getMembers()) {
            Method setter;
            if (!(member instanceof KProperty)) continue;
            KProperty property = (KProperty)member;
            Method getter = ReflectJvmMapping.getJavaGetter((KProperty)property);
            if (property instanceof KMutableProperty) {
                KMutableProperty kmp = (KMutableProperty)property;
                v0 = ReflectJvmMapping.getJavaSetter((KMutableProperty)kmp);
            } else {
                v0 = setter = null;
            }
            if (getter != null && setter != null && setter.getParameterCount() == 1 && !getter.getReturnType().equals(setter.getParameters()[0].getType())) continue;
            pds.add(new PropertyDescriptor(property.getName(), getter, setter));
        }
        Class<?> javaClass = beanClass;
        while (KotlinDetector.isKotlinType(javaClass = javaClass.getSuperclass())) {
        }
        if (javaClass != Object.class) {
            PropertyDescriptor[] javaPropertyDescriptors = BeanUtils.getPropertyDescriptors(javaClass);
            pds.addAll(Arrays.asList(javaPropertyDescriptors));
        }
        return new SimpleBeanInfo(){

            @Override
            public BeanDescriptor getBeanDescriptor() {
                return new BeanDescriptor(beanClass);
            }

            @Override
            public PropertyDescriptor[] getPropertyDescriptors() {
                return pds.toArray(new PropertyDescriptor[0]);
            }
        };
    }

    public int getOrder() {
        return 0x7FFFFFF5;
    }
}

