/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.meeds.layout.model.PortletInstancePreference;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationBackgroundStyle;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.CloneApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PersistentApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.spi.portlet.Portlet;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class LayoutModel {
    protected String id;
    protected String storageId;
    protected String storageName;
    protected String name;
    protected String icon;
    protected String template;
    protected String factoryId;
    protected String title;
    protected String description;
    protected String width;
    protected String height;
    protected String cssClass;
    protected String borderColor;
    private String borderSize;
    private String boxShadow;
    private Integer marginTop;
    private Integer marginBottom;
    private Integer marginRight;
    private Integer marginLeft;
    private Integer radiusTopRight;
    private Integer radiusTopLeft;
    private Integer radiusBottomRight;
    private Integer radiusBottomLeft;
    private String backgroundColor;
    private String backgroundImage;
    private String backgroundEffect;
    private String backgroundPosition;
    private String backgroundSize;
    private String backgroundRepeat;
    private String appBackgroundColor;
    private String appBackgroundImage;
    private String appBackgroundEffect;
    private String appBackgroundPosition;
    private String appBackgroundSize;
    private String appBackgroundRepeat;
    private String textTitleColor;
    private String textTitleFontSize;
    private String textTitleFontWeight;
    private String textTitleFontStyle;
    private String textHeaderColor;
    private String textHeaderFontSize;
    private String textHeaderFontWeight;
    private String textHeaderFontStyle;
    private String textColor;
    private String textFontSize;
    private String textFontWeight;
    private String textFontStyle;
    private String textSubtitleColor;
    private String textSubtitleFontSize;
    private String textSubtitleFontWeight;
    private String textSubtitleFontStyle;
    private String[] accessPermissions;
    private String profiles;
    private String[] moveAppsPermissions;
    private String[] moveContainersPermissions;
    private List<PortletInstancePreference> preferences;
    private List<LayoutModel> children;
    private String contentId;
    private boolean showInfoBar;
    private boolean showApplicationState = true;
    private boolean showApplicationMode = true;
    private String editPermission;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private PageKey pageKey;
    private String ownerType;
    private String ownerId;
    private boolean showMaxWindow;
    private boolean hideSharedLayout;
    private String type;
    private String link;

    public LayoutModel(ModelObject model) {
        this.init(model);
    }

    private void init(ModelObject model) {
        ModelStyle cssStyle = model.getCssStyle();
        if (cssStyle != null) {
            this.borderColor = cssStyle.getBorderColor();
            this.borderSize = cssStyle.getBorderSize();
            this.boxShadow = cssStyle.getBoxShadow();
            this.marginTop = cssStyle.getMarginTop();
            this.marginBottom = cssStyle.getMarginBottom();
            this.marginRight = cssStyle.getMarginRight();
            this.marginLeft = cssStyle.getMarginLeft();
            this.radiusTopLeft = cssStyle.getRadiusTopLeft();
            this.radiusBottomRight = cssStyle.getRadiusBottomRight();
            this.radiusBottomLeft = cssStyle.getRadiusBottomLeft();
            this.radiusTopRight = cssStyle.getRadiusTopRight();
            this.radiusTopLeft = cssStyle.getRadiusTopLeft();
            this.radiusBottomRight = cssStyle.getRadiusBottomRight();
            this.radiusBottomLeft = cssStyle.getRadiusBottomLeft();
            this.backgroundColor = cssStyle.getBackgroundColor();
            this.backgroundImage = cssStyle.getBackgroundImage();
            this.backgroundEffect = cssStyle.getBackgroundEffect();
            this.backgroundPosition = cssStyle.getBackgroundPosition();
            this.backgroundSize = cssStyle.getBackgroundSize();
            this.backgroundRepeat = cssStyle.getBackgroundRepeat();
            this.textTitleColor = cssStyle.getTextTitleColor();
            this.textTitleFontSize = cssStyle.getTextTitleFontSize();
            this.textTitleFontWeight = cssStyle.getTextTitleFontWeight();
            this.textTitleFontStyle = cssStyle.getTextTitleFontStyle();
            this.textHeaderColor = cssStyle.getTextHeaderColor();
            this.textHeaderFontSize = cssStyle.getTextHeaderFontSize();
            this.textHeaderFontWeight = cssStyle.getTextHeaderFontWeight();
            this.textHeaderFontStyle = cssStyle.getTextHeaderFontStyle();
            this.textColor = cssStyle.getTextColor();
            this.textFontSize = cssStyle.getTextFontSize();
            this.textFontWeight = cssStyle.getTextFontWeight();
            this.textFontStyle = cssStyle.getTextFontStyle();
            this.textSubtitleColor = cssStyle.getTextSubtitleColor();
            this.textSubtitleFontSize = cssStyle.getTextSubtitleFontSize();
            this.textSubtitleFontWeight = cssStyle.getTextSubtitleFontWeight();
            this.textSubtitleFontStyle = cssStyle.getTextSubtitleFontStyle();
        }
        if (model instanceof Container) {
            Container container = (Container)model;
            this.id = container.getId();
            this.storageId = container.getStorageId();
            this.storageName = container.getStorageName();
            this.name = container.getName();
            this.icon = container.getIcon();
            this.template = container.getTemplate();
            this.factoryId = container.getFactoryId();
            this.title = container.getTitle();
            this.description = container.getDescription();
            this.width = container.getWidth();
            this.height = container.getHeight();
            this.cssClass = container.getCssClass();
            this.profiles = container.getProfiles();
            this.accessPermissions = container.getAccessPermissions();
            this.moveAppsPermissions = container.getMoveAppsPermissions();
            this.moveContainersPermissions = container.getMoveContainersPermissions();
            this.children = container.getChildren().stream().map(LayoutModel::new).toList();
            ApplicationBackgroundStyle appCssStyle = container.getAppBackgroundStyle();
            if (appCssStyle != null) {
                this.appBackgroundColor = appCssStyle.getBackgroundColor();
                this.appBackgroundImage = appCssStyle.getBackgroundImage();
                this.appBackgroundEffect = appCssStyle.getBackgroundEffect();
                this.appBackgroundPosition = appCssStyle.getBackgroundPosition();
                this.appBackgroundSize = appCssStyle.getBackgroundSize();
                this.appBackgroundRepeat = appCssStyle.getBackgroundRepeat();
            }
            if (model instanceof Page) {
                Page page = (Page)model;
                this.editPermission = page.getEditPermission();
                this.pageKey = page.getPageKey();
                this.ownerType = page.getOwnerType();
                this.ownerId = page.getOwnerId();
                this.showMaxWindow = page.isShowMaxWindow();
                this.hideSharedLayout = page.isHideSharedLayout();
                this.type = page.getType();
                this.link = page.getLink();
            }
        } else if (model instanceof Application) {
            ApplicationState state;
            Application application = (Application)model;
            this.id = application.getId();
            this.storageId = application.getStorageId();
            this.storageName = application.getStorageName();
            this.icon = application.getIcon();
            this.title = application.getTitle();
            this.description = application.getDescription();
            this.width = application.getWidth();
            this.height = application.getHeight();
            this.cssClass = application.getCssClass();
            this.showInfoBar = application.getShowInfoBar();
            this.showApplicationState = application.getShowApplicationState();
            this.showApplicationMode = application.getShowApplicationMode();
            this.accessPermissions = application.getAccessPermissions();
            ApplicationState applicationState = state = application.getState();
            Objects.requireNonNull(applicationState);
            ApplicationState applicationState2 = applicationState;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PersistentApplicationState.class, CloneApplicationState.class, TransientApplicationState.class}, (Object)applicationState2, n)) {
                case 0: {
                    PersistentApplicationState persistentState = (PersistentApplicationState)applicationState2;
                    this.storageId = persistentState.getStorageId();
                    break;
                }
                case 1: {
                    CloneApplicationState persistentState = (CloneApplicationState)applicationState2;
                    this.storageId = persistentState.getStorageId();
                    break;
                }
                case 2: {
                    TransientApplicationState transientState = (TransientApplicationState)applicationState2;
                    this.contentId = transientState.getContentId();
                    Portlet portlet = (Portlet)transientState.getContentState();
                    this.preferences = portlet == null ? Collections.emptyList() : StreamSupport.stream(portlet.spliterator(), false).map(p -> new PortletInstancePreference(p.getName(), p.getValue())).toList();
                    break;
                }
                default: {
                    throw new IllegalStateException("PortletInstance should either has a persistent or transient state");
                }
            }
        }
    }

    public Page toPage() {
        Page page = new Page(this.storageId);
        ArrayList pageContainers = this.children == null ? new ArrayList() : this.children.stream().map(LayoutModel::toModelObject).collect(Collectors.toCollection(ArrayList::new));
        page.setChildren(pageContainers);
        return page;
    }

    public static ModelObject toModelObject(LayoutModel layoutModel) {
        PersistentApplicationState state;
        ModelStyle cssStyle = LayoutModel.mapToStyle(layoutModel);
        if (StringUtils.isNotBlank((CharSequence)layoutModel.template)) {
            Container container = new Container(layoutModel.getStorageId());
            container.setId(layoutModel.getId());
            container.setStorageName(layoutModel.getStorageName());
            container.setName(layoutModel.getName());
            container.setIcon(layoutModel.getIcon());
            container.setTemplate(layoutModel.getTemplate());
            container.setFactoryId(layoutModel.getFactoryId());
            container.setTitle(layoutModel.getTitle());
            container.setDescription(layoutModel.getDescription());
            container.setWidth(layoutModel.getWidth());
            container.setHeight(layoutModel.getHeight());
            container.setCssClass(layoutModel.getCssClass());
            container.setProfiles(layoutModel.getProfiles());
            container.setAccessPermissions(layoutModel.getAccessPermissions());
            container.setMoveAppsPermissions(layoutModel.getMoveAppsPermissions());
            container.setMoveContainersPermissions(layoutModel.getMoveContainersPermissions());
            container.setCssStyle(cssStyle);
            container.setAppBackgroundStyle(LayoutModel.mapToAppStyle(layoutModel));
            if (layoutModel.getChildren() != null) {
                container.setChildren(layoutModel.getChildren().stream().map(LayoutModel::toModelObject).collect(Collectors.toCollection(ArrayList::new)));
            }
            return container;
        }
        Application application = new Application(ApplicationType.PORTLET, layoutModel.getStorageId());
        application.setId(layoutModel.getId());
        application.setStorageName(layoutModel.getStorageName());
        application.setIcon(layoutModel.getIcon());
        application.setTitle(layoutModel.getTitle());
        application.setDescription(layoutModel.getDescription());
        application.setWidth(layoutModel.getWidth());
        application.setHeight(layoutModel.getHeight());
        application.setCssClass(layoutModel.getCssClass());
        application.setShowInfoBar(layoutModel.isShowInfoBar());
        application.setShowApplicationState(layoutModel.isShowApplicationState());
        application.setShowApplicationMode(layoutModel.isShowApplicationMode());
        application.setAccessPermissions(layoutModel.getAccessPermissions());
        application.setCssStyle(cssStyle);
        if (StringUtils.isNotBlank((CharSequence)layoutModel.getStorageId())) {
            state = new PersistentApplicationState(layoutModel.getStorageId());
        } else if (StringUtils.isNotBlank((CharSequence)layoutModel.getContentId())) {
            TransientApplicationState transientState = new TransientApplicationState(layoutModel.getContentId());
            transientState.setOwnerId(layoutModel.getOwnerId());
            transientState.setOwnerType(layoutModel.getOwnerType());
            if (CollectionUtils.isNotEmpty(layoutModel.getPreferences())) {
                Portlet portlet = new Portlet();
                layoutModel.getPreferences().forEach(p -> portlet.setValue(p.getName(), p.getValue()));
                transientState.setContentState((Object)portlet);
            }
            state = transientState;
        } else {
            throw new IllegalStateException("PortletInstance should either has a storageId or a contentId");
        }
        application.setState((ApplicationState)state);
        return application;
    }

    private static ModelStyle mapToStyle(LayoutModel layoutModel) {
        boolean hasStyle;
        ModelStyle cssStyle = null;
        boolean bl = hasStyle = StringUtils.isNotBlank((CharSequence)layoutModel.getBorderColor()) || layoutModel.getRadiusTopRight() != null || layoutModel.getRadiusTopLeft() != null || layoutModel.getRadiusBottomLeft() != null || layoutModel.getRadiusBottomRight() != null || layoutModel.getMarginTop() != null || layoutModel.getMarginBottom() != null || layoutModel.getMarginLeft() != null || layoutModel.getMarginRight() != null || StringUtils.isNotBlank((CharSequence)layoutModel.getBorderSize()) || StringUtils.isNotBlank((CharSequence)layoutModel.getBoxShadow()) || StringUtils.isNotBlank((CharSequence)layoutModel.getBackgroundColor()) || StringUtils.isNotBlank((CharSequence)layoutModel.getBackgroundImage()) || StringUtils.isNotBlank((CharSequence)layoutModel.getTextTitleColor()) || StringUtils.isNotBlank((CharSequence)layoutModel.getTextColor()) || StringUtils.isNotBlank((CharSequence)layoutModel.getTextHeaderColor()) || StringUtils.isNotBlank((CharSequence)layoutModel.getTextSubtitleColor());
        if (hasStyle) {
            cssStyle = new ModelStyle();
            cssStyle.setBorderColor(layoutModel.getBorderColor());
            cssStyle.setBorderSize(layoutModel.getBorderSize());
            cssStyle.setBoxShadow(layoutModel.getBoxShadow());
            cssStyle.setMarginTop(layoutModel.getMarginTop());
            cssStyle.setMarginBottom(layoutModel.getMarginBottom());
            cssStyle.setMarginRight(layoutModel.getMarginRight());
            cssStyle.setMarginLeft(layoutModel.getMarginLeft());
            cssStyle.setRadiusTopRight(layoutModel.getRadiusTopRight());
            cssStyle.setRadiusTopLeft(layoutModel.getRadiusTopLeft());
            cssStyle.setRadiusBottomRight(layoutModel.getRadiusBottomRight());
            cssStyle.setRadiusBottomLeft(layoutModel.getRadiusBottomLeft());
            cssStyle.setBackgroundColor(layoutModel.getBackgroundColor());
            cssStyle.setBackgroundImage(layoutModel.getBackgroundImage());
            cssStyle.setBackgroundEffect(layoutModel.getBackgroundEffect());
            cssStyle.setBackgroundPosition(layoutModel.getBackgroundPosition());
            cssStyle.setBackgroundSize(layoutModel.getBackgroundSize());
            cssStyle.setBackgroundRepeat(layoutModel.getBackgroundRepeat());
            cssStyle.setTextTitleColor(layoutModel.getTextTitleColor());
            cssStyle.setTextTitleFontSize(layoutModel.getTextTitleFontSize());
            cssStyle.setTextTitleFontWeight(layoutModel.getTextTitleFontWeight());
            cssStyle.setTextTitleFontStyle(layoutModel.getTextTitleFontStyle());
            cssStyle.setTextHeaderColor(layoutModel.getTextHeaderColor());
            cssStyle.setTextHeaderFontSize(layoutModel.getTextHeaderFontSize());
            cssStyle.setTextHeaderFontWeight(layoutModel.getTextHeaderFontWeight());
            cssStyle.setTextHeaderFontStyle(layoutModel.getTextHeaderFontStyle());
            cssStyle.setTextColor(layoutModel.getTextColor());
            cssStyle.setTextFontSize(layoutModel.getTextFontSize());
            cssStyle.setTextFontWeight(layoutModel.getTextFontWeight());
            cssStyle.setTextFontStyle(layoutModel.getTextFontStyle());
            cssStyle.setTextSubtitleColor(layoutModel.getTextSubtitleColor());
            cssStyle.setTextSubtitleFontSize(layoutModel.getTextSubtitleFontSize());
            cssStyle.setTextSubtitleFontWeight(layoutModel.getTextSubtitleFontWeight());
            cssStyle.setTextSubtitleFontStyle(layoutModel.getTextSubtitleFontStyle());
        }
        return cssStyle;
    }

    private static ApplicationBackgroundStyle mapToAppStyle(LayoutModel layoutModel) {
        ApplicationBackgroundStyle cssStyle = null;
        if (StringUtils.isNotBlank((CharSequence)layoutModel.getAppBackgroundColor()) || StringUtils.isNotBlank((CharSequence)layoutModel.getAppBackgroundImage())) {
            cssStyle = new ApplicationBackgroundStyle();
            cssStyle.setBackgroundColor(layoutModel.getAppBackgroundColor());
            cssStyle.setBackgroundImage(layoutModel.getAppBackgroundImage());
            cssStyle.setBackgroundEffect(layoutModel.getAppBackgroundEffect());
            cssStyle.setBackgroundPosition(layoutModel.getAppBackgroundPosition());
            cssStyle.setBackgroundSize(layoutModel.getAppBackgroundSize());
            cssStyle.setBackgroundRepeat(layoutModel.getAppBackgroundRepeat());
        }
        return cssStyle;
    }

    public String getId() {
        return this.id;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public String getBorderSize() {
        return this.borderSize;
    }

    public String getBoxShadow() {
        return this.boxShadow;
    }

    public Integer getMarginTop() {
        return this.marginTop;
    }

    public Integer getMarginBottom() {
        return this.marginBottom;
    }

    public Integer getMarginRight() {
        return this.marginRight;
    }

    public Integer getMarginLeft() {
        return this.marginLeft;
    }

    public Integer getRadiusTopRight() {
        return this.radiusTopRight;
    }

    public Integer getRadiusTopLeft() {
        return this.radiusTopLeft;
    }

    public Integer getRadiusBottomRight() {
        return this.radiusBottomRight;
    }

    public Integer getRadiusBottomLeft() {
        return this.radiusBottomLeft;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getBackgroundEffect() {
        return this.backgroundEffect;
    }

    public String getBackgroundPosition() {
        return this.backgroundPosition;
    }

    public String getBackgroundSize() {
        return this.backgroundSize;
    }

    public String getBackgroundRepeat() {
        return this.backgroundRepeat;
    }

    public String getAppBackgroundColor() {
        return this.appBackgroundColor;
    }

    public String getAppBackgroundImage() {
        return this.appBackgroundImage;
    }

    public String getAppBackgroundEffect() {
        return this.appBackgroundEffect;
    }

    public String getAppBackgroundPosition() {
        return this.appBackgroundPosition;
    }

    public String getAppBackgroundSize() {
        return this.appBackgroundSize;
    }

    public String getAppBackgroundRepeat() {
        return this.appBackgroundRepeat;
    }

    public String getTextTitleColor() {
        return this.textTitleColor;
    }

    public String getTextTitleFontSize() {
        return this.textTitleFontSize;
    }

    public String getTextTitleFontWeight() {
        return this.textTitleFontWeight;
    }

    public String getTextTitleFontStyle() {
        return this.textTitleFontStyle;
    }

    public String getTextHeaderColor() {
        return this.textHeaderColor;
    }

    public String getTextHeaderFontSize() {
        return this.textHeaderFontSize;
    }

    public String getTextHeaderFontWeight() {
        return this.textHeaderFontWeight;
    }

    public String getTextHeaderFontStyle() {
        return this.textHeaderFontStyle;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public String getTextFontSize() {
        return this.textFontSize;
    }

    public String getTextFontWeight() {
        return this.textFontWeight;
    }

    public String getTextFontStyle() {
        return this.textFontStyle;
    }

    public String getTextSubtitleColor() {
        return this.textSubtitleColor;
    }

    public String getTextSubtitleFontSize() {
        return this.textSubtitleFontSize;
    }

    public String getTextSubtitleFontWeight() {
        return this.textSubtitleFontWeight;
    }

    public String getTextSubtitleFontStyle() {
        return this.textSubtitleFontStyle;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public String[] getMoveAppsPermissions() {
        return this.moveAppsPermissions;
    }

    public String[] getMoveContainersPermissions() {
        return this.moveContainersPermissions;
    }

    public List<PortletInstancePreference> getPreferences() {
        return this.preferences;
    }

    public List<LayoutModel> getChildren() {
        return this.children;
    }

    public String getContentId() {
        return this.contentId;
    }

    public boolean isShowInfoBar() {
        return this.showInfoBar;
    }

    public boolean isShowApplicationState() {
        return this.showApplicationState;
    }

    public boolean isShowApplicationMode() {
        return this.showApplicationMode;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public PageKey getPageKey() {
        return this.pageKey;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public boolean isShowMaxWindow() {
        return this.showMaxWindow;
    }

    public boolean isHideSharedLayout() {
        return this.hideSharedLayout;
    }

    public String getType() {
        return this.type;
    }

    public String getLink() {
        return this.link;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setFactoryId(String factoryId) {
        this.factoryId = factoryId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public void setBorderSize(String borderSize) {
        this.borderSize = borderSize;
    }

    public void setBoxShadow(String boxShadow) {
        this.boxShadow = boxShadow;
    }

    public void setMarginTop(Integer marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginBottom(Integer marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginRight(Integer marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginLeft(Integer marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setRadiusTopRight(Integer radiusTopRight) {
        this.radiusTopRight = radiusTopRight;
    }

    public void setRadiusTopLeft(Integer radiusTopLeft) {
        this.radiusTopLeft = radiusTopLeft;
    }

    public void setRadiusBottomRight(Integer radiusBottomRight) {
        this.radiusBottomRight = radiusBottomRight;
    }

    public void setRadiusBottomLeft(Integer radiusBottomLeft) {
        this.radiusBottomLeft = radiusBottomLeft;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setBackgroundEffect(String backgroundEffect) {
        this.backgroundEffect = backgroundEffect;
    }

    public void setBackgroundPosition(String backgroundPosition) {
        this.backgroundPosition = backgroundPosition;
    }

    public void setBackgroundSize(String backgroundSize) {
        this.backgroundSize = backgroundSize;
    }

    public void setBackgroundRepeat(String backgroundRepeat) {
        this.backgroundRepeat = backgroundRepeat;
    }

    public void setAppBackgroundColor(String appBackgroundColor) {
        this.appBackgroundColor = appBackgroundColor;
    }

    public void setAppBackgroundImage(String appBackgroundImage) {
        this.appBackgroundImage = appBackgroundImage;
    }

    public void setAppBackgroundEffect(String appBackgroundEffect) {
        this.appBackgroundEffect = appBackgroundEffect;
    }

    public void setAppBackgroundPosition(String appBackgroundPosition) {
        this.appBackgroundPosition = appBackgroundPosition;
    }

    public void setAppBackgroundSize(String appBackgroundSize) {
        this.appBackgroundSize = appBackgroundSize;
    }

    public void setAppBackgroundRepeat(String appBackgroundRepeat) {
        this.appBackgroundRepeat = appBackgroundRepeat;
    }

    public void setTextTitleColor(String textTitleColor) {
        this.textTitleColor = textTitleColor;
    }

    public void setTextTitleFontSize(String textTitleFontSize) {
        this.textTitleFontSize = textTitleFontSize;
    }

    public void setTextTitleFontWeight(String textTitleFontWeight) {
        this.textTitleFontWeight = textTitleFontWeight;
    }

    public void setTextTitleFontStyle(String textTitleFontStyle) {
        this.textTitleFontStyle = textTitleFontStyle;
    }

    public void setTextHeaderColor(String textHeaderColor) {
        this.textHeaderColor = textHeaderColor;
    }

    public void setTextHeaderFontSize(String textHeaderFontSize) {
        this.textHeaderFontSize = textHeaderFontSize;
    }

    public void setTextHeaderFontWeight(String textHeaderFontWeight) {
        this.textHeaderFontWeight = textHeaderFontWeight;
    }

    public void setTextHeaderFontStyle(String textHeaderFontStyle) {
        this.textHeaderFontStyle = textHeaderFontStyle;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public void setTextFontSize(String textFontSize) {
        this.textFontSize = textFontSize;
    }

    public void setTextFontWeight(String textFontWeight) {
        this.textFontWeight = textFontWeight;
    }

    public void setTextFontStyle(String textFontStyle) {
        this.textFontStyle = textFontStyle;
    }

    public void setTextSubtitleColor(String textSubtitleColor) {
        this.textSubtitleColor = textSubtitleColor;
    }

    public void setTextSubtitleFontSize(String textSubtitleFontSize) {
        this.textSubtitleFontSize = textSubtitleFontSize;
    }

    public void setTextSubtitleFontWeight(String textSubtitleFontWeight) {
        this.textSubtitleFontWeight = textSubtitleFontWeight;
    }

    public void setTextSubtitleFontStyle(String textSubtitleFontStyle) {
        this.textSubtitleFontStyle = textSubtitleFontStyle;
    }

    public void setAccessPermissions(String[] accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    public void setMoveAppsPermissions(String[] moveAppsPermissions) {
        this.moveAppsPermissions = moveAppsPermissions;
    }

    public void setMoveContainersPermissions(String[] moveContainersPermissions) {
        this.moveContainersPermissions = moveContainersPermissions;
    }

    public void setPreferences(List<PortletInstancePreference> preferences) {
        this.preferences = preferences;
    }

    public void setChildren(List<LayoutModel> children) {
        this.children = children;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setShowInfoBar(boolean showInfoBar) {
        this.showInfoBar = showInfoBar;
    }

    public void setShowApplicationState(boolean showApplicationState) {
        this.showApplicationState = showApplicationState;
    }

    public void setShowApplicationMode(boolean showApplicationMode) {
        this.showApplicationMode = showApplicationMode;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public void setPageKey(PageKey pageKey) {
        this.pageKey = pageKey;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setShowMaxWindow(boolean showMaxWindow) {
        this.showMaxWindow = showMaxWindow;
    }

    public void setHideSharedLayout(boolean hideSharedLayout) {
        this.hideSharedLayout = hideSharedLayout;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayoutModel)) {
            return false;
        }
        LayoutModel other = (LayoutModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShowInfoBar() != other.isShowInfoBar()) {
            return false;
        }
        if (this.isShowApplicationState() != other.isShowApplicationState()) {
            return false;
        }
        if (this.isShowApplicationMode() != other.isShowApplicationMode()) {
            return false;
        }
        if (this.isShowMaxWindow() != other.isShowMaxWindow()) {
            return false;
        }
        if (this.isHideSharedLayout() != other.isHideSharedLayout()) {
            return false;
        }
        Integer this$marginTop = this.getMarginTop();
        Integer other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Integer this$marginBottom = this.getMarginBottom();
        Integer other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Integer this$marginRight = this.getMarginRight();
        Integer other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Integer this$marginLeft = this.getMarginLeft();
        Integer other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Integer this$radiusTopRight = this.getRadiusTopRight();
        Integer other$radiusTopRight = other.getRadiusTopRight();
        if (this$radiusTopRight == null ? other$radiusTopRight != null : !((Object)this$radiusTopRight).equals(other$radiusTopRight)) {
            return false;
        }
        Integer this$radiusTopLeft = this.getRadiusTopLeft();
        Integer other$radiusTopLeft = other.getRadiusTopLeft();
        if (this$radiusTopLeft == null ? other$radiusTopLeft != null : !((Object)this$radiusTopLeft).equals(other$radiusTopLeft)) {
            return false;
        }
        Integer this$radiusBottomRight = this.getRadiusBottomRight();
        Integer other$radiusBottomRight = other.getRadiusBottomRight();
        if (this$radiusBottomRight == null ? other$radiusBottomRight != null : !((Object)this$radiusBottomRight).equals(other$radiusBottomRight)) {
            return false;
        }
        Integer this$radiusBottomLeft = this.getRadiusBottomLeft();
        Integer other$radiusBottomLeft = other.getRadiusBottomLeft();
        if (this$radiusBottomLeft == null ? other$radiusBottomLeft != null : !((Object)this$radiusBottomLeft).equals(other$radiusBottomLeft)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$storageId = this.getStorageId();
        String other$storageId = other.getStorageId();
        if (this$storageId == null ? other$storageId != null : !this$storageId.equals(other$storageId)) {
            return false;
        }
        String this$storageName = this.getStorageName();
        String other$storageName = other.getStorageName();
        if (this$storageName == null ? other$storageName != null : !this$storageName.equals(other$storageName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$factoryId = this.getFactoryId();
        String other$factoryId = other.getFactoryId();
        if (this$factoryId == null ? other$factoryId != null : !this$factoryId.equals(other$factoryId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$width = this.getWidth();
        String other$width = other.getWidth();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) {
            return false;
        }
        String this$height = this.getHeight();
        String other$height = other.getHeight();
        if (this$height == null ? other$height != null : !this$height.equals(other$height)) {
            return false;
        }
        String this$cssClass = this.getCssClass();
        String other$cssClass = other.getCssClass();
        if (this$cssClass == null ? other$cssClass != null : !this$cssClass.equals(other$cssClass)) {
            return false;
        }
        String this$borderColor = this.getBorderColor();
        String other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !this$borderColor.equals(other$borderColor)) {
            return false;
        }
        String this$borderSize = this.getBorderSize();
        String other$borderSize = other.getBorderSize();
        if (this$borderSize == null ? other$borderSize != null : !this$borderSize.equals(other$borderSize)) {
            return false;
        }
        String this$boxShadow = this.getBoxShadow();
        String other$boxShadow = other.getBoxShadow();
        if (this$boxShadow == null ? other$boxShadow != null : !this$boxShadow.equals(other$boxShadow)) {
            return false;
        }
        String this$backgroundColor = this.getBackgroundColor();
        String other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !this$backgroundColor.equals(other$backgroundColor)) {
            return false;
        }
        String this$backgroundImage = this.getBackgroundImage();
        String other$backgroundImage = other.getBackgroundImage();
        if (this$backgroundImage == null ? other$backgroundImage != null : !this$backgroundImage.equals(other$backgroundImage)) {
            return false;
        }
        String this$backgroundEffect = this.getBackgroundEffect();
        String other$backgroundEffect = other.getBackgroundEffect();
        if (this$backgroundEffect == null ? other$backgroundEffect != null : !this$backgroundEffect.equals(other$backgroundEffect)) {
            return false;
        }
        String this$backgroundPosition = this.getBackgroundPosition();
        String other$backgroundPosition = other.getBackgroundPosition();
        if (this$backgroundPosition == null ? other$backgroundPosition != null : !this$backgroundPosition.equals(other$backgroundPosition)) {
            return false;
        }
        String this$backgroundSize = this.getBackgroundSize();
        String other$backgroundSize = other.getBackgroundSize();
        if (this$backgroundSize == null ? other$backgroundSize != null : !this$backgroundSize.equals(other$backgroundSize)) {
            return false;
        }
        String this$backgroundRepeat = this.getBackgroundRepeat();
        String other$backgroundRepeat = other.getBackgroundRepeat();
        if (this$backgroundRepeat == null ? other$backgroundRepeat != null : !this$backgroundRepeat.equals(other$backgroundRepeat)) {
            return false;
        }
        String this$appBackgroundColor = this.getAppBackgroundColor();
        String other$appBackgroundColor = other.getAppBackgroundColor();
        if (this$appBackgroundColor == null ? other$appBackgroundColor != null : !this$appBackgroundColor.equals(other$appBackgroundColor)) {
            return false;
        }
        String this$appBackgroundImage = this.getAppBackgroundImage();
        String other$appBackgroundImage = other.getAppBackgroundImage();
        if (this$appBackgroundImage == null ? other$appBackgroundImage != null : !this$appBackgroundImage.equals(other$appBackgroundImage)) {
            return false;
        }
        String this$appBackgroundEffect = this.getAppBackgroundEffect();
        String other$appBackgroundEffect = other.getAppBackgroundEffect();
        if (this$appBackgroundEffect == null ? other$appBackgroundEffect != null : !this$appBackgroundEffect.equals(other$appBackgroundEffect)) {
            return false;
        }
        String this$appBackgroundPosition = this.getAppBackgroundPosition();
        String other$appBackgroundPosition = other.getAppBackgroundPosition();
        if (this$appBackgroundPosition == null ? other$appBackgroundPosition != null : !this$appBackgroundPosition.equals(other$appBackgroundPosition)) {
            return false;
        }
        String this$appBackgroundSize = this.getAppBackgroundSize();
        String other$appBackgroundSize = other.getAppBackgroundSize();
        if (this$appBackgroundSize == null ? other$appBackgroundSize != null : !this$appBackgroundSize.equals(other$appBackgroundSize)) {
            return false;
        }
        String this$appBackgroundRepeat = this.getAppBackgroundRepeat();
        String other$appBackgroundRepeat = other.getAppBackgroundRepeat();
        if (this$appBackgroundRepeat == null ? other$appBackgroundRepeat != null : !this$appBackgroundRepeat.equals(other$appBackgroundRepeat)) {
            return false;
        }
        String this$textTitleColor = this.getTextTitleColor();
        String other$textTitleColor = other.getTextTitleColor();
        if (this$textTitleColor == null ? other$textTitleColor != null : !this$textTitleColor.equals(other$textTitleColor)) {
            return false;
        }
        String this$textTitleFontSize = this.getTextTitleFontSize();
        String other$textTitleFontSize = other.getTextTitleFontSize();
        if (this$textTitleFontSize == null ? other$textTitleFontSize != null : !this$textTitleFontSize.equals(other$textTitleFontSize)) {
            return false;
        }
        String this$textTitleFontWeight = this.getTextTitleFontWeight();
        String other$textTitleFontWeight = other.getTextTitleFontWeight();
        if (this$textTitleFontWeight == null ? other$textTitleFontWeight != null : !this$textTitleFontWeight.equals(other$textTitleFontWeight)) {
            return false;
        }
        String this$textTitleFontStyle = this.getTextTitleFontStyle();
        String other$textTitleFontStyle = other.getTextTitleFontStyle();
        if (this$textTitleFontStyle == null ? other$textTitleFontStyle != null : !this$textTitleFontStyle.equals(other$textTitleFontStyle)) {
            return false;
        }
        String this$textHeaderColor = this.getTextHeaderColor();
        String other$textHeaderColor = other.getTextHeaderColor();
        if (this$textHeaderColor == null ? other$textHeaderColor != null : !this$textHeaderColor.equals(other$textHeaderColor)) {
            return false;
        }
        String this$textHeaderFontSize = this.getTextHeaderFontSize();
        String other$textHeaderFontSize = other.getTextHeaderFontSize();
        if (this$textHeaderFontSize == null ? other$textHeaderFontSize != null : !this$textHeaderFontSize.equals(other$textHeaderFontSize)) {
            return false;
        }
        String this$textHeaderFontWeight = this.getTextHeaderFontWeight();
        String other$textHeaderFontWeight = other.getTextHeaderFontWeight();
        if (this$textHeaderFontWeight == null ? other$textHeaderFontWeight != null : !this$textHeaderFontWeight.equals(other$textHeaderFontWeight)) {
            return false;
        }
        String this$textHeaderFontStyle = this.getTextHeaderFontStyle();
        String other$textHeaderFontStyle = other.getTextHeaderFontStyle();
        if (this$textHeaderFontStyle == null ? other$textHeaderFontStyle != null : !this$textHeaderFontStyle.equals(other$textHeaderFontStyle)) {
            return false;
        }
        String this$textColor = this.getTextColor();
        String other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !this$textColor.equals(other$textColor)) {
            return false;
        }
        String this$textFontSize = this.getTextFontSize();
        String other$textFontSize = other.getTextFontSize();
        if (this$textFontSize == null ? other$textFontSize != null : !this$textFontSize.equals(other$textFontSize)) {
            return false;
        }
        String this$textFontWeight = this.getTextFontWeight();
        String other$textFontWeight = other.getTextFontWeight();
        if (this$textFontWeight == null ? other$textFontWeight != null : !this$textFontWeight.equals(other$textFontWeight)) {
            return false;
        }
        String this$textFontStyle = this.getTextFontStyle();
        String other$textFontStyle = other.getTextFontStyle();
        if (this$textFontStyle == null ? other$textFontStyle != null : !this$textFontStyle.equals(other$textFontStyle)) {
            return false;
        }
        String this$textSubtitleColor = this.getTextSubtitleColor();
        String other$textSubtitleColor = other.getTextSubtitleColor();
        if (this$textSubtitleColor == null ? other$textSubtitleColor != null : !this$textSubtitleColor.equals(other$textSubtitleColor)) {
            return false;
        }
        String this$textSubtitleFontSize = this.getTextSubtitleFontSize();
        String other$textSubtitleFontSize = other.getTextSubtitleFontSize();
        if (this$textSubtitleFontSize == null ? other$textSubtitleFontSize != null : !this$textSubtitleFontSize.equals(other$textSubtitleFontSize)) {
            return false;
        }
        String this$textSubtitleFontWeight = this.getTextSubtitleFontWeight();
        String other$textSubtitleFontWeight = other.getTextSubtitleFontWeight();
        if (this$textSubtitleFontWeight == null ? other$textSubtitleFontWeight != null : !this$textSubtitleFontWeight.equals(other$textSubtitleFontWeight)) {
            return false;
        }
        String this$textSubtitleFontStyle = this.getTextSubtitleFontStyle();
        String other$textSubtitleFontStyle = other.getTextSubtitleFontStyle();
        if (this$textSubtitleFontStyle == null ? other$textSubtitleFontStyle != null : !this$textSubtitleFontStyle.equals(other$textSubtitleFontStyle)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAccessPermissions(), other.getAccessPermissions())) {
            return false;
        }
        String this$profiles = this.getProfiles();
        String other$profiles = other.getProfiles();
        if (this$profiles == null ? other$profiles != null : !this$profiles.equals(other$profiles)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMoveAppsPermissions(), other.getMoveAppsPermissions())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMoveContainersPermissions(), other.getMoveContainersPermissions())) {
            return false;
        }
        List<PortletInstancePreference> this$preferences = this.getPreferences();
        List<PortletInstancePreference> other$preferences = other.getPreferences();
        if (this$preferences == null ? other$preferences != null : !((Object)this$preferences).equals(other$preferences)) {
            return false;
        }
        List<LayoutModel> this$children = this.getChildren();
        List<LayoutModel> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        String this$contentId = this.getContentId();
        String other$contentId = other.getContentId();
        if (this$contentId == null ? other$contentId != null : !this$contentId.equals(other$contentId)) {
            return false;
        }
        String this$editPermission = this.getEditPermission();
        String other$editPermission = other.getEditPermission();
        if (this$editPermission == null ? other$editPermission != null : !this$editPermission.equals(other$editPermission)) {
            return false;
        }
        PageKey this$pageKey = this.getPageKey();
        PageKey other$pageKey = other.getPageKey();
        if (this$pageKey == null ? other$pageKey != null : !this$pageKey.equals(other$pageKey)) {
            return false;
        }
        String this$ownerType = this.getOwnerType();
        String other$ownerType = other.getOwnerType();
        if (this$ownerType == null ? other$ownerType != null : !this$ownerType.equals(other$ownerType)) {
            return false;
        }
        String this$ownerId = this.getOwnerId();
        String other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        return !(this$link == null ? other$link != null : !this$link.equals(other$link));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LayoutModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowInfoBar() ? 79 : 97);
        result = result * 59 + (this.isShowApplicationState() ? 79 : 97);
        result = result * 59 + (this.isShowApplicationMode() ? 79 : 97);
        result = result * 59 + (this.isShowMaxWindow() ? 79 : 97);
        result = result * 59 + (this.isHideSharedLayout() ? 79 : 97);
        Integer $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Integer $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Integer $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Integer $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Integer $radiusTopRight = this.getRadiusTopRight();
        result = result * 59 + ($radiusTopRight == null ? 43 : ((Object)$radiusTopRight).hashCode());
        Integer $radiusTopLeft = this.getRadiusTopLeft();
        result = result * 59 + ($radiusTopLeft == null ? 43 : ((Object)$radiusTopLeft).hashCode());
        Integer $radiusBottomRight = this.getRadiusBottomRight();
        result = result * 59 + ($radiusBottomRight == null ? 43 : ((Object)$radiusBottomRight).hashCode());
        Integer $radiusBottomLeft = this.getRadiusBottomLeft();
        result = result * 59 + ($radiusBottomLeft == null ? 43 : ((Object)$radiusBottomLeft).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $storageId = this.getStorageId();
        result = result * 59 + ($storageId == null ? 43 : $storageId.hashCode());
        String $storageName = this.getStorageName();
        result = result * 59 + ($storageName == null ? 43 : $storageName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $factoryId = this.getFactoryId();
        result = result * 59 + ($factoryId == null ? 43 : $factoryId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : $width.hashCode());
        String $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : $height.hashCode());
        String $cssClass = this.getCssClass();
        result = result * 59 + ($cssClass == null ? 43 : $cssClass.hashCode());
        String $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : $borderColor.hashCode());
        String $borderSize = this.getBorderSize();
        result = result * 59 + ($borderSize == null ? 43 : $borderSize.hashCode());
        String $boxShadow = this.getBoxShadow();
        result = result * 59 + ($boxShadow == null ? 43 : $boxShadow.hashCode());
        String $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : $backgroundColor.hashCode());
        String $backgroundImage = this.getBackgroundImage();
        result = result * 59 + ($backgroundImage == null ? 43 : $backgroundImage.hashCode());
        String $backgroundEffect = this.getBackgroundEffect();
        result = result * 59 + ($backgroundEffect == null ? 43 : $backgroundEffect.hashCode());
        String $backgroundPosition = this.getBackgroundPosition();
        result = result * 59 + ($backgroundPosition == null ? 43 : $backgroundPosition.hashCode());
        String $backgroundSize = this.getBackgroundSize();
        result = result * 59 + ($backgroundSize == null ? 43 : $backgroundSize.hashCode());
        String $backgroundRepeat = this.getBackgroundRepeat();
        result = result * 59 + ($backgroundRepeat == null ? 43 : $backgroundRepeat.hashCode());
        String $appBackgroundColor = this.getAppBackgroundColor();
        result = result * 59 + ($appBackgroundColor == null ? 43 : $appBackgroundColor.hashCode());
        String $appBackgroundImage = this.getAppBackgroundImage();
        result = result * 59 + ($appBackgroundImage == null ? 43 : $appBackgroundImage.hashCode());
        String $appBackgroundEffect = this.getAppBackgroundEffect();
        result = result * 59 + ($appBackgroundEffect == null ? 43 : $appBackgroundEffect.hashCode());
        String $appBackgroundPosition = this.getAppBackgroundPosition();
        result = result * 59 + ($appBackgroundPosition == null ? 43 : $appBackgroundPosition.hashCode());
        String $appBackgroundSize = this.getAppBackgroundSize();
        result = result * 59 + ($appBackgroundSize == null ? 43 : $appBackgroundSize.hashCode());
        String $appBackgroundRepeat = this.getAppBackgroundRepeat();
        result = result * 59 + ($appBackgroundRepeat == null ? 43 : $appBackgroundRepeat.hashCode());
        String $textTitleColor = this.getTextTitleColor();
        result = result * 59 + ($textTitleColor == null ? 43 : $textTitleColor.hashCode());
        String $textTitleFontSize = this.getTextTitleFontSize();
        result = result * 59 + ($textTitleFontSize == null ? 43 : $textTitleFontSize.hashCode());
        String $textTitleFontWeight = this.getTextTitleFontWeight();
        result = result * 59 + ($textTitleFontWeight == null ? 43 : $textTitleFontWeight.hashCode());
        String $textTitleFontStyle = this.getTextTitleFontStyle();
        result = result * 59 + ($textTitleFontStyle == null ? 43 : $textTitleFontStyle.hashCode());
        String $textHeaderColor = this.getTextHeaderColor();
        result = result * 59 + ($textHeaderColor == null ? 43 : $textHeaderColor.hashCode());
        String $textHeaderFontSize = this.getTextHeaderFontSize();
        result = result * 59 + ($textHeaderFontSize == null ? 43 : $textHeaderFontSize.hashCode());
        String $textHeaderFontWeight = this.getTextHeaderFontWeight();
        result = result * 59 + ($textHeaderFontWeight == null ? 43 : $textHeaderFontWeight.hashCode());
        String $textHeaderFontStyle = this.getTextHeaderFontStyle();
        result = result * 59 + ($textHeaderFontStyle == null ? 43 : $textHeaderFontStyle.hashCode());
        String $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : $textColor.hashCode());
        String $textFontSize = this.getTextFontSize();
        result = result * 59 + ($textFontSize == null ? 43 : $textFontSize.hashCode());
        String $textFontWeight = this.getTextFontWeight();
        result = result * 59 + ($textFontWeight == null ? 43 : $textFontWeight.hashCode());
        String $textFontStyle = this.getTextFontStyle();
        result = result * 59 + ($textFontStyle == null ? 43 : $textFontStyle.hashCode());
        String $textSubtitleColor = this.getTextSubtitleColor();
        result = result * 59 + ($textSubtitleColor == null ? 43 : $textSubtitleColor.hashCode());
        String $textSubtitleFontSize = this.getTextSubtitleFontSize();
        result = result * 59 + ($textSubtitleFontSize == null ? 43 : $textSubtitleFontSize.hashCode());
        String $textSubtitleFontWeight = this.getTextSubtitleFontWeight();
        result = result * 59 + ($textSubtitleFontWeight == null ? 43 : $textSubtitleFontWeight.hashCode());
        String $textSubtitleFontStyle = this.getTextSubtitleFontStyle();
        result = result * 59 + ($textSubtitleFontStyle == null ? 43 : $textSubtitleFontStyle.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAccessPermissions());
        String $profiles = this.getProfiles();
        result = result * 59 + ($profiles == null ? 43 : $profiles.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMoveAppsPermissions());
        result = result * 59 + Arrays.deepHashCode(this.getMoveContainersPermissions());
        List<PortletInstancePreference> $preferences = this.getPreferences();
        result = result * 59 + ($preferences == null ? 43 : ((Object)$preferences).hashCode());
        List<LayoutModel> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        String $contentId = this.getContentId();
        result = result * 59 + ($contentId == null ? 43 : $contentId.hashCode());
        String $editPermission = this.getEditPermission();
        result = result * 59 + ($editPermission == null ? 43 : $editPermission.hashCode());
        PageKey $pageKey = this.getPageKey();
        result = result * 59 + ($pageKey == null ? 43 : $pageKey.hashCode());
        String $ownerType = this.getOwnerType();
        result = result * 59 + ($ownerType == null ? 43 : $ownerType.hashCode());
        String $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        return result;
    }

    public String toString() {
        return "LayoutModel(id=" + this.getId() + ", storageId=" + this.getStorageId() + ", storageName=" + this.getStorageName() + ", name=" + this.getName() + ", icon=" + this.getIcon() + ", template=" + this.getTemplate() + ", factoryId=" + this.getFactoryId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", cssClass=" + this.getCssClass() + ", borderColor=" + this.getBorderColor() + ", borderSize=" + this.getBorderSize() + ", boxShadow=" + this.getBoxShadow() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", marginRight=" + this.getMarginRight() + ", marginLeft=" + this.getMarginLeft() + ", radiusTopRight=" + this.getRadiusTopRight() + ", radiusTopLeft=" + this.getRadiusTopLeft() + ", radiusBottomRight=" + this.getRadiusBottomRight() + ", radiusBottomLeft=" + this.getRadiusBottomLeft() + ", backgroundColor=" + this.getBackgroundColor() + ", backgroundImage=" + this.getBackgroundImage() + ", backgroundEffect=" + this.getBackgroundEffect() + ", backgroundPosition=" + this.getBackgroundPosition() + ", backgroundSize=" + this.getBackgroundSize() + ", backgroundRepeat=" + this.getBackgroundRepeat() + ", appBackgroundColor=" + this.getAppBackgroundColor() + ", appBackgroundImage=" + this.getAppBackgroundImage() + ", appBackgroundEffect=" + this.getAppBackgroundEffect() + ", appBackgroundPosition=" + this.getAppBackgroundPosition() + ", appBackgroundSize=" + this.getAppBackgroundSize() + ", appBackgroundRepeat=" + this.getAppBackgroundRepeat() + ", textTitleColor=" + this.getTextTitleColor() + ", textTitleFontSize=" + this.getTextTitleFontSize() + ", textTitleFontWeight=" + this.getTextTitleFontWeight() + ", textTitleFontStyle=" + this.getTextTitleFontStyle() + ", textHeaderColor=" + this.getTextHeaderColor() + ", textHeaderFontSize=" + this.getTextHeaderFontSize() + ", textHeaderFontWeight=" + this.getTextHeaderFontWeight() + ", textHeaderFontStyle=" + this.getTextHeaderFontStyle() + ", textColor=" + this.getTextColor() + ", textFontSize=" + this.getTextFontSize() + ", textFontWeight=" + this.getTextFontWeight() + ", textFontStyle=" + this.getTextFontStyle() + ", textSubtitleColor=" + this.getTextSubtitleColor() + ", textSubtitleFontSize=" + this.getTextSubtitleFontSize() + ", textSubtitleFontWeight=" + this.getTextSubtitleFontWeight() + ", textSubtitleFontStyle=" + this.getTextSubtitleFontStyle() + ", accessPermissions=" + Arrays.deepToString(this.getAccessPermissions()) + ", profiles=" + this.getProfiles() + ", moveAppsPermissions=" + Arrays.deepToString(this.getMoveAppsPermissions()) + ", moveContainersPermissions=" + Arrays.deepToString(this.getMoveContainersPermissions()) + ", preferences=" + String.valueOf(this.getPreferences()) + ", children=" + String.valueOf(this.getChildren()) + ", contentId=" + this.getContentId() + ", showInfoBar=" + this.isShowInfoBar() + ", showApplicationState=" + this.isShowApplicationState() + ", showApplicationMode=" + this.isShowApplicationMode() + ", editPermission=" + this.getEditPermission() + ", pageKey=" + String.valueOf(this.getPageKey()) + ", ownerType=" + this.getOwnerType() + ", ownerId=" + this.getOwnerId() + ", showMaxWindow=" + this.isShowMaxWindow() + ", hideSharedLayout=" + this.isHideSharedLayout() + ", type=" + this.getType() + ", link=" + this.getLink() + ")";
    }

    public LayoutModel() {
    }

    public LayoutModel(String id, String storageId, String storageName, String name, String icon, String template, String factoryId, String title, String description, String width, String height, String cssClass, String borderColor, String borderSize, String boxShadow, Integer marginTop, Integer marginBottom, Integer marginRight, Integer marginLeft, Integer radiusTopRight, Integer radiusTopLeft, Integer radiusBottomRight, Integer radiusBottomLeft, String backgroundColor, String backgroundImage, String backgroundEffect, String backgroundPosition, String backgroundSize, String backgroundRepeat, String appBackgroundColor, String appBackgroundImage, String appBackgroundEffect, String appBackgroundPosition, String appBackgroundSize, String appBackgroundRepeat, String textTitleColor, String textTitleFontSize, String textTitleFontWeight, String textTitleFontStyle, String textHeaderColor, String textHeaderFontSize, String textHeaderFontWeight, String textHeaderFontStyle, String textColor, String textFontSize, String textFontWeight, String textFontStyle, String textSubtitleColor, String textSubtitleFontSize, String textSubtitleFontWeight, String textSubtitleFontStyle, String[] accessPermissions, String profiles, String[] moveAppsPermissions, String[] moveContainersPermissions, List<PortletInstancePreference> preferences, List<LayoutModel> children, String contentId, boolean showInfoBar, boolean showApplicationState, boolean showApplicationMode, String editPermission, PageKey pageKey, String ownerType, String ownerId, boolean showMaxWindow, boolean hideSharedLayout, String type, String link) {
        this.id = id;
        this.storageId = storageId;
        this.storageName = storageName;
        this.name = name;
        this.icon = icon;
        this.template = template;
        this.factoryId = factoryId;
        this.title = title;
        this.description = description;
        this.width = width;
        this.height = height;
        this.cssClass = cssClass;
        this.borderColor = borderColor;
        this.borderSize = borderSize;
        this.boxShadow = boxShadow;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
        this.marginRight = marginRight;
        this.marginLeft = marginLeft;
        this.radiusTopRight = radiusTopRight;
        this.radiusTopLeft = radiusTopLeft;
        this.radiusBottomRight = radiusBottomRight;
        this.radiusBottomLeft = radiusBottomLeft;
        this.backgroundColor = backgroundColor;
        this.backgroundImage = backgroundImage;
        this.backgroundEffect = backgroundEffect;
        this.backgroundPosition = backgroundPosition;
        this.backgroundSize = backgroundSize;
        this.backgroundRepeat = backgroundRepeat;
        this.appBackgroundColor = appBackgroundColor;
        this.appBackgroundImage = appBackgroundImage;
        this.appBackgroundEffect = appBackgroundEffect;
        this.appBackgroundPosition = appBackgroundPosition;
        this.appBackgroundSize = appBackgroundSize;
        this.appBackgroundRepeat = appBackgroundRepeat;
        this.textTitleColor = textTitleColor;
        this.textTitleFontSize = textTitleFontSize;
        this.textTitleFontWeight = textTitleFontWeight;
        this.textTitleFontStyle = textTitleFontStyle;
        this.textHeaderColor = textHeaderColor;
        this.textHeaderFontSize = textHeaderFontSize;
        this.textHeaderFontWeight = textHeaderFontWeight;
        this.textHeaderFontStyle = textHeaderFontStyle;
        this.textColor = textColor;
        this.textFontSize = textFontSize;
        this.textFontWeight = textFontWeight;
        this.textFontStyle = textFontStyle;
        this.textSubtitleColor = textSubtitleColor;
        this.textSubtitleFontSize = textSubtitleFontSize;
        this.textSubtitleFontWeight = textSubtitleFontWeight;
        this.textSubtitleFontStyle = textSubtitleFontStyle;
        this.accessPermissions = accessPermissions;
        this.profiles = profiles;
        this.moveAppsPermissions = moveAppsPermissions;
        this.moveContainersPermissions = moveContainersPermissions;
        this.preferences = preferences;
        this.children = children;
        this.contentId = contentId;
        this.showInfoBar = showInfoBar;
        this.showApplicationState = showApplicationState;
        this.showApplicationMode = showApplicationMode;
        this.editPermission = editPermission;
        this.pageKey = pageKey;
        this.ownerType = ownerType;
        this.ownerId = ownerId;
        this.showMaxWindow = showMaxWindow;
        this.hideSharedLayout = hideSharedLayout;
        this.type = type;
        this.link = link;
    }
}

